/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/util/RCS/power.c,v 5.5 1995/09/22 13:03:46 jpo Exp $
    $Date: 1995/09/22 13:03:46 $
    $Author: jpo $
    $Id: power.c,v 5.5 1995/09/22 13:03:46 jpo Exp $
    $Locker:  $
    $Log: power.c,v $
    Revision 5.5  1995/09/22 13:03:46  jpo
    Added worlwide power and date

    Revision 5.4  1995/09/12 18:51:13  jpo
    Change to use strings

    Revision 5.3  1995/09/12 18:11:37  jpo
    Add power display window

    Revision 5.2  1995/09/08 07:49:05  jpo
    const

 * Revision 5.1  93/03/14  16:52:58  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:24:11  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:45:54  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"

#define POWER_WW 9999

typedef char SBuf [10];

typedef struct s_power * PowerEntry;
typedef struct s_powerl * PowerList;

struct s_power
{
	int ranking;
	int nat;
	SBuf nr_sects;
	SBuf eff;
	SBuf civ;
	SBuf mil;
	SBuf shells;
	SBuf guns;
	SBuf pet;
	SBuf iron;
	SBuf dust;
	SBuf food;
	SBuf oil;
	SBuf pln;
	SBuf ship;
	SBuf unit;
	SBuf money;
};

struct s_powerl
{
	PowerEntry entry;
	PowerList next, prev;
};

static int sects_start = 0;
static int eff_start;
static char *power_date;

static PowerList power_head, power_tail;

static PowerEntry NewPowerEntry ()
{
	PowerEntry new_entry;
	PowerList new_list;

	new_entry = (PowerEntry) doalloc ((unsigned) sizeof (struct s_power));
	new_list = (PowerList) doalloc ((unsigned) sizeof (struct s_powerl));

	new_list-> entry = new_entry;
	new_list-> next = (PowerList) 0;
	new_list-> prev = power_tail;	

	if (power_head == (PowerList) 0)
	{
		power_head = power_tail = new_list;
	}
	else
	{
		power_tail-> next = new_list;
		power_tail = new_list;
	}

	return new_entry;
}

static void FreeLastPowerEntry (entry)
PowerEntry entry;
{
	if (power_tail == (PowerList) 0)
		Panic ("FreeLastPowerEntry", __FILE__, "power_tail is NULL");
	
	(void) free ((char *) (power_tail-> entry));
	if (power_tail == power_head)
	{
		(void) free ((char *) power_head);
		power_head = power_tail = (PowerList) 0;
	}
	else
	{
		power_tail = power_tail-> prev;
		(void) free ((char *) power_tail-> next);
		power_tail -> next = NULL;
	}
}

static bool ScanPowerLine (entry, line)
PowerEntry entry;
char * line;
{
	char buf [100];
	char * ptr;
	int len, i;

	if (StrStr (line, "---") != (char *) 0)
		return False;
	
	if ((ptr = StrStr (line, "as of ")) != (char *)0) {
	    if (power_date) free (power_date);
	    power_date = Str(ptr + 5);
	    return False;
	}
	ptr = StrStr (line, "sects");
	if (ptr != (char *) 0)
	{
		sects_start = (ptr - line);
		ptr = StrStr (line, "eff");
		eff_start = (ptr - line);
		return False;
	}

	if (eff_start == 0)
		return False;
	
	if (strlen (line) < eff_start + 2)
		return False;
	
	if (line [eff_start + 2] != '%')
		return False;

		/* find nation */

	i = 0;
	while (line [i] == ' ')
		i ++;
	strncpy (buf, line + i, sects_start - i);
	buf [sects_start - i] = '\0';

	if (strcmp (buf, "worldwide") == 0) {
		i = POWER_WW;
	}
	else {
		i = CountryId (buf);

		if (i < 0)
		{
			Message (Fmt ("Unknown country (%s) in power report", buf));
			Bell ();
			Pause ();
			return False;
		}
	}

	entry-> nat = i;

	ptr = line + sects_start;
	ScanFmt ((ConstVP)& ptr, entry-> nr_sects, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> eff, "0-9%");
	ScanFmt ((ConstVP)& ptr, entry-> civ, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> mil, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> shells, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> guns, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> pet, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> iron, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> dust, "0-9KM.");
	if (!land_units)
		ScanFmt ((ConstVP)& ptr, entry-> food, "0-9KM.");
	else	strcpy (entry -> food, "---");
	ScanFmt ((ConstVP)& ptr, entry-> oil, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> pln, "0-9KM.");
	ScanFmt ((ConstVP)& ptr, entry-> ship, "0-9KM.");
	if (land_units)
		ScanFmt ((ConstVP)& ptr, entry-> unit, "0-9KM.");
	else strcpy (entry->unit, "---");
	ScanFmt ((ConstVP)& ptr, entry-> money, "0-9KM.");

	return True;
}

void FreePowerList ()
{
	if (power_date) free (power_date);
	power_date = NULL;
	while (power_tail != (PowerList) 0)
		FreeLastPowerEntry ();
}

static void DoScanPower (force)
bool force;
{
	int ranking;
	char * line;
	PowerEntry entry;

	if (power_tail == (PowerList) 0 || force)
	{
		if (power_tail != (PowerList) 0)
			FreePowerList ();
		
		FeedEmpire ("power", PRINT);
		PrintAtEmpire ("xemp: scanning power output");

		ranking = 0;
		eff_start = sects_start = 0;
		entry = NewPowerEntry ();
		entry-> ranking = ++ ranking;

		for (;;)
		{
			line = ReadEmpire (DONT_PRINT);

			if (EmpireStatus () == E_COMMAND)
			{
				FreeLastPowerEntry ();
				PrintAtEmpire (line);
				return;
			}

			if (EmpireStatus () != E_PRINTING)
			{
				Message ("Sync error");
				Bell ();
				continue;
			}

			if (ScanPowerLine (entry, line))
			{
				entry = NewPowerEntry ();
				entry-> ranking = ++ ranking;
			}
		}
	}
}

void ScanNewPower ()
{
	DoScanPower (True);
}

void ScanPower ()
{
	DoScanPower (False);
}

static PowerEntry FindNationPowerEntry (natid)
int natid;
{
	PowerList ptr;

	if (power_head == (PowerList) 0)
		return (PowerEntry) 0;
	
	for (ptr = power_head; ptr != (PowerList) 0; ptr = ptr-> next)
		if (ptr-> entry-> nat == natid)
			return ptr-> entry;
	
	return (PowerEntry) 0;
}

void PrintPowerString (strings, natid)
Strings strings;
int natid;
{
	PowerEntry entry;

	entry = FindNationPowerEntry (natid);
	if (entry == (PowerEntry) 0)
	{
		AddString (strings, "No power information found");
		return;
	}

	AddString (strings, Fmt ("Power report  (ranking #%d)",
				 entry-> ranking));
	AddString (strings, "");
	AddString (strings, Fmt ("Sects: %4s  Shells: %4s  Food: %4s  Planes: %4s",
				 entry-> nr_sects, entry -> shells,
				 entry -> food, entry -> pln));
	AddString (strings, Fmt ("Eff:   %4s  Guns:   %4s  Oil:  %4s  Ships:  %4s",
				 entry -> eff, entry -> guns, entry -> oil,
				 entry -> ship));
	AddString (strings, Fmt ("Civ:   %4s  Petrol: %4s  Money: %4s",
				 entry -> civ, entry -> pet, entry -> money));
	AddString (strings, Fmt ("Mil:   %4s  Dust:   %4s  Units: %4s",
				 entry -> mil, entry -> dust, entry -> unit));
}

void DisplayPower ()
{
	Strings strings;
	PowerList ptr;
				/*      name sect eff   civ mil she gun pet iro dus oil pln shp unt mon */
	static const char *fmtstring = "%10s %4s  %4s %4s %4s %4s %4s %4s %4s %4s %4s %4s %4s %4s %4s";
	PowerEntry entry;

	ScanPower ();

	strings = InitStrings ();
	if (power_date) {
		AddString (strings, Fmt ("Power Report as of %s", power_date));
		AddString (strings, "");
	}
	AddString (strings, Fmt (fmtstring, "who", "sect", "eff", "civ",
				 "mil", "shel", "gun", "pet", "iron",
				 "dust", "oil", "pln", "ship", "unit",
				 "money"));
	for (ptr = power_head; ptr != (PowerList) 0; ptr = ptr-> next) {
		entry = ptr -> entry;
		if (entry -> nat == POWER_WW)
			AddString (strings, "");
		AddString (strings, Fmt (fmtstring,
					 entry -> nat == POWER_WW ?
					 "Worldwide" :
					 CountryName(entry -> nat),
					 entry -> nr_sects,
					 entry -> eff,
					 entry -> civ,
					 entry -> mil,
					 entry -> shells,
					 entry -> guns,
					 entry -> pet,
					 entry -> iron,
					 entry -> dust,
					 entry -> oil,
					 entry -> pln,
					 entry -> ship,
					 entry -> unit,
					 entry -> money));
	}
	InitWMPager (strings, "power listing");
}

void SavePowerData (fp)
FILE *fp;
{
	fprintf (fp, "END OF POWER DATA\n");
}

void LoadPowerData (fp)
FILE *fp;
{
}
