/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/update/RCS/ship.c,v 5.2 1995/09/08 07:47:36 jpo Exp $
    $Date: 1995/09/08 07:47:36 $
    $Author: jpo $
    $Id: ship.c,v 5.2 1995/09/08 07:47:36 jpo Exp $
    $Locker:  $
    $Log: ship.c,v $
    Revision 5.2  1995/09/08 07:47:36  jpo
    more land stuff

 * Revision 5.1  93/03/14  16:52:39  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:23:58  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:44:42  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "var.h"
#include "ship.h"
#include "sector.h"
#include "nation.h"
#include "version.h"

extern double upd_ship_eff;
extern double upd_ship_main;
extern double upd_ship_crew;
extern long upd_totalmil;
extern long upd_totalciv;
extern long upd_totaluw;
extern int ship_eff_gain;

bool UpdShipRepair(ship, etus)
register Ship ship;
int etus;
{
	Sector sct;
	register int delta;
	int	wf;
	int	left;
	int	avail;
	int	w_p_eff;
	int mult;
	int nlcm, nhcm;

	mult = 1;
	if (n_tech (nation) < sh_tech (ship) * 0.85)
		mult = 2;

	upd_ship_main += mult * etus *
		dmin (0.0,money_ship * shiptypes [sh_type (ship)]. cos);

	if (sh_eff (ship) == 100)
		return True;

	sct = ShipSector (ship);

	if (land_units && s_des (sct) == '.' && sh_eff (ship) > 79)
		return True;

		/*
		 *	Testing for some-one elses harbor: below
		 */

	if (land_units && s_des (sct) == '.')
		left = 80 - sh_eff (ship);  /* can only go to 80% eff at sea */
	else
		left = 100 - sh_eff (ship);

	wf = 0;

	/* only military can work on a military boat */
	if (ShipMaxGuns (ship) > 0)
		wf = etus * sh_mil (ship) / 2;
	else
		wf = etus * (sh_civ (ship) / 2 + sh_mil (ship) / 5);

	if (s_des (sct) != 'h')
	{
		wf /= 3;
		avail = wf;
	}
	else
	{
		if (! s_owned (sct) && (s_des (sct) == 'h' && !EMPOption (ALLYHARBORWORK)))
			return True;

		avail = wf + s_ava (sct) * 100;
	} 

	w_p_eff = 20 + (shiptypes [sh_type (ship)]. lcm +
			2 * shiptypes [sh_type (ship)]. hcm);

	delta = roundavg ((double) avail / w_p_eff);
	if (delta <= 0)
		return True;
	if (delta > ship_eff_gain)
		delta = ship_eff_gain;
	if (delta > left)
		delta = left;

	if (land_units && s_des (sct) != '.') {
		nlcm = shiptypes [sh_type (ship)]. lcm * left / 100;
		nhcm = shiptypes [sh_type (ship)]. hcm * left / 100;

		if (nlcm > q_lcm (sct)) {
			delta = q_lcm (sct) * 100 / left;
			nhcm = shiptypes [sh_type (ship)]. hcm * left / 100;
			nlcm = q_lcm (sct);
		}
		if (nhcm > q_hcm (sct)) {
			delta = q_hcm (sct) * 100 / left;
			nhcm = shiptypes [sh_type (ship)]. lcm * left / 100;
			nhcm = q_hcm (sct);
		}
		set_q_lcm (sct, nlcm);
		set_q_hcm (sct, nhcm);
	} 

	wf -= delta * w_p_eff;

	if (wf < 0)
	{
		avail = (s_owned (sct) ?  s_ava (sct) * 100 : 0 + wf) / 100;
		if (avail < 0)
			avail = 0;
		if (s_owned (sct))
			set_ava (sct, avail);
	}

	upd_ship_eff -= mult * shiptypes [sh_type (ship)]. cos *
			delta / 100.0;

	inc_sh_eff (ship, delta);

	return True;
}

static void UpdShip (ship, shipno, etus, strings)
register Ship ship;
int shipno;
int etus;
Strings strings;
{
	Sector sct;
	int	oil_gained;
	int	max_oil;
	int	max_food;
	struct	pchrstr *product;
	int	resource;
	int	n;

	(void) UpdShipRepair (ship, etus);

	if (sh_eff (ship) < 20)
	{
		AddString (strings, 
			Fmt ("Lost %s #%d (eff < 20)",
				ShipName (ship), shipno));
		DeleteShip (ship);
		return;
	}

	if (ShipHas (ship, M_OIL))
	{
		/*
		 * take care of oil production
		 */

		sct = ShipSector (ship);

		oil_gained = (int) ((sh_civ (ship) * etus / 10000.0)
								* s_oil (sct));

		inc_sh_oil (ship, oil_gained);
		max_oil = MaxShipCargo (ship, 'o');
		if (sh_oil (ship) > max_oil)
		{
				/* empire doesn't do this */
			AddString (strings,
				Fmt ("production backlog on %s #%d",	
					ShipName (ship), shipno));
			set_sh_oil (ship, max_oil);
		}

		product = ProdChr ('o');	/* JAKKES */
		if (product->p_nrdep != 0 && oil_gained > 0)
		{
			resource = GiveProdResource (sct, product->p_nrndx);
			SetProdResource (sct, product->p_nrndx,
					resource - roundavg(oil_gained *
						product->p_nrdep / 100.0));
		}
	}
	else if (ShipHas (ship, M_FISH))
	{
		sct = ShipSector (ship);
		inc_sh_foo (ship, ((sh_civ (ship) * etus) / 10000.0) *
								s_fer (sct));
	}

	upd_ship_crew += (long) sh_mil (ship) * etus * money_mil;
	upd_totalciv += (long) sh_civ (ship);
	upd_totaluw += (long) sh_uw (ship);

	if ((n = FeedShipPeople (ship, etus, True)) > 0)
		AddString (strings,
			Fmt ("%d starved on %s #%d",
				n, ShipName (ship), shipno));
	
	max_food = MaxShipCargo (ship, 'f');
	if (sh_foo (ship) > max_food)
		set_sh_foo (ship, max_food);
		
		/*
		 *	XXX:	Xemp doesn't handle plagues
		 */
}

void UpdProdShip (realm, etus, strings)
char * realm;
int etus;
Strings strings;
{
	Ship ptr;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for ALL_SHIPS (ptr)
	{
		if (! sh_owned (ptr) ||
		    sh_xcd (ptr) < sx || sh_xcd (ptr) > ex ||
		    sh_ycd (ptr) < sy || sh_ycd (ptr) > ey)
			continue;

		UpdShip(ptr, sh_nr (ptr), etus, strings);
	}
}
