/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/update/RCS/produce.c,v 5.1 1993/03/14 16:52:34 etienne Exp $
    $Date: 1993/03/14 16:52:34 $
    $Author: etienne $
    $Id: produce.c,v 5.1 1993/03/14 16:52:34 etienne Exp $
    $Locker:  $
    $Log: produce.c,v $
    Revision 5.1  1993/03/14 16:52:34  etienne

 * Revision 5.0  93/02/06  09:23:58  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:44:42  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "var.h"
#include "sector.h"
#include "nation.h"

extern long upd_prodcost [];

char	*levelnames[] = { "Technology", "Research", "Education", "Happiness" };

int UpdProduce(sct, work, strings)
Sector sct;
int work;
Strings strings;
{
	extern struct pchrstr pchr [];
	register struct pchrstr *product;
	int	item;
	char itemchar;
	double	p_e;
	double	level_p_e;
	int	resource;
	int	output;
	int	actual;
	int	unit_work;
	double	depend;
	int	worker_limit;
	int	material_limit;
	int	material_consume;
	int	val;
	int quant;

	product = ProdChr (s_des (sct));
	if (product == (struct pchrstr *) 0 || product == & pchr[0])
		return 0;

	item = product->p_type;
	itemchar = ItemChar (item);
	if (GiveQuant (sct, itemchar) >= max_comm)
	{
		if (item != V_FOOD)
			AddString (strings,
				Fmt("%s production backlog in %s",
				product->p_name, CrdStr (sct)));
		return 0;
	}

	if ((material_limit = materials_cost (product, sct, & unit_work)) <= 0)
		return 0;

	/*
	 * calculate production efficiency.
	 */

	p_e = s_eff (sct) / 100.0;

	if (product->p_nrndx != 0)
	{
		unit_work++;
		resource = GiveProdResource (sct, product-> p_nrndx);
		p_e = (resource * p_e) / 100.0;
		if (product->p_nrdep > 0)
		{
			/* XXX this looks way wrong */
			depend = (resource * 100.0) / product->p_nrdep;
			if (p_e > depend)
				p_e = depend;
		}
	}

	/*
	 * determine number that can be made with
	 * the available workforce
	 */

	material_consume = material_limit;
	worker_limit = roundavg (work * p_e / unit_work);
	if (material_consume > worker_limit)
		material_consume = worker_limit;
	if (material_consume == 0)
		return 0;
	level_p_e = 1.0;
	if (product->p_nlndx >= 0)
	{
		level_p_e = (int) GiveNatLevel (product->p_nlndx)
							- product->p_nlmin;
		if (level_p_e < 0.0)
		{
			AddString (strings,
			   Fmt("%s level too low to produce in %s (need %d)",
				    levelnames[product->p_nlndx],
				    CrdStr (sct),
				    product->p_nlmin));
			return 0;
		}

		level_p_e = level_p_e / (level_p_e + product->p_nllag);
	}

	/*
	 *	Adjust produced amount by commodity production ratio
	 */

	output = roundavg (product->p_effic * 0.01 * material_consume);

	if (item == 0)
	{
/* 
 * 		levels[sp->sct_own][product->p_level] += output * level_p_e;
 */
		AddString (strings,
			Fmt("%s (%.2f) produced in %s",
				product->p_name,
				output * level_p_e,
				CrdStr (sct)));
	}
	else
	{
		if ((actual = roundavg(level_p_e * output)) <= 0)
			return 0;

		SetQuant (sct, itemchar, GiveQuant (sct, itemchar) + actual);
		quant = GiveQuant (sct, itemchar);
		if (quant > max_comm)
		{
			material_consume =
			   roundavg((max_comm - quant + actual) * 
				material_consume  / actual);
			SetQuant (sct, itemchar, max_comm);
			if (item != V_FOOD)
				AddString (strings, 
					Fmt("%s production backlog in %s",
					product->p_name,
					CrdStr (sct)));
		}
	}

	/*
	 *	Reset produced amount by commodity production ratio
	 */

	materials_charge (product, sct, material_consume);
	if (product->p_nrdep != 0)
	{
		/*
		 * lower natural resource in sector depending on
		 * amount produced
		 */

		val = resource - roundavg(product->p_nrdep *
			material_consume / 100.0);
		if (val < 0)
			val = 0;
		SetProdResource (sct, product-> p_nrndx, val);
	}
	
	if (item == 0)
		upd_prodcost [V_MAX + product-> p_level] +=
				(long) product-> p_cost * material_consume;
	else
		upd_prodcost [item] += (long) product-> p_cost *
				material_consume;

	return (int) (unit_work * material_consume / p_e);
}

int materials_cost(product, sct, costp)
struct	pchrstr *product;
Sector sct;
int	*costp;
{
	register u_char *vp;
	register u_int *ap;
	register int count;
	register int cost;
	register int n;
	register u_char *endp;

	count = 9999;
	cost = 0;
	ap = product-> p_vamt;
	endp = product-> p_vtype + product-> p_nv;
	for (vp = product->p_vtype; vp < endp; vp ++, ap ++)
	{
		n = GiveQuant (sct, ItemChar (* vp)) / * ap;
		if (n < count)
			count = n;
		cost += *ap;
	}
	* costp = cost;
	return count;
}

int materials_charge(product, sct, count)
struct pchrstr *product;
Sector sct;
register int count;
{
	register u_char *vp;
	register u_int *ap;
	register u_char *endp;
	register char itemchar;
	register int n;
	int quant;

	ap = product->p_vamt;
	endp = product->p_vtype + product->p_nv;
	for (vp = product->p_vtype; vp < endp; vp++, ap++)
	{
		itemchar = ItemChar (*vp);
		quant = GiveQuant (sct, itemchar);
		if ((n = (quant - *ap * count)) < 0) {
			Panic (
				"materials_charge",
				"update/produce",
				Fmt ("%d > %d %s",
				     n,
				     quant,
				     ItemName (*vp)));
			n = 0;
		}
		SetQuant (sct, itemchar, n);
	}
}
