/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/update/RCS/main.c,v 5.2 1995/09/08 07:46:09 jpo Exp $
    $Date: 1995/09/08 07:46:09 $
    $Author: jpo $
    $Id: main.c,v 5.2 1995/09/08 07:46:09 jpo Exp $
    $Locker:  $
    $Log: main.c,v $
    Revision 5.2  1995/09/08 07:46:09  jpo
    touch ups

 * Revision 5.1  93/03/14  16:52:25  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:23:58  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:44:42  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "nation.h"
#include "var.h"
#include "ship.h"
#include "sector.h"
#include "plane.h"
#include "nuke.h"
#include "land.h"
#include "version.h"

long upd_buildeff;
long upd_totalciv;
long upd_totalmil;
long upd_totaluw;
long upd_enlist;

long upd_prodcost [V_MAX + 4];

double upd_ship_eff;
double upd_ship_main;
double upd_ship_crew;
double upd_plane_eff;
double upd_plane_main;
double upd_milcost;
double upd_land_eff;
double upd_land_main;
double upd_landmilcost;
double upd_bankint;
double upd_civ_taxes;

extern char * levelnames [];

static Sector **s_world;
static Plane s_plane;
static Ship	s_ship;
static Land	l_land;

static void relink_ships (slist, olist)
Ship	*slist, olist;
{
	Ship sp;
	for (;olist != (Ship)0; olist = sh_nxtsct(olist)) {
		for ALL_SHIPS (sp) {
			if (sh_nr(sp) == sh_nr(olist))
				break;
		}
		if (sp) {
			*slist = sp;
			slist = &(*slist) -> nextsct;
		}
	}
}

static void relink_lands (llist, olist)
Land	*llist, olist;
{
	Land lp;
	for (;olist != (Land)0; olist = ld_nxtsct(olist)) {
		for ALL_LANDS (lp) {
			if (ld_nr(lp) == ld_nr(olist))
				break;
		}
		if (lp) {
			*llist = lp;
			llist = &(*llist) -> nextsct;
		}
	}
}

static void relink_plane (plist, olist)
Plane	*plist, olist;
{
	Plane pp;

	for (; olist != (Plane)0; olist = pl_nxtsct(olist)) {
		for ALL_PLANES (pp) {
			if (pl_nr(pp) == pl_nr(olist))
				break;
		}
		if (pp) {
			*plist = pp;
			plist = &(*plist)->nxtsct;
		}
	}
}

static void relink_nuke (nlist, olist)
Stockp *nlist, olist;
{
	Stockp sp;

	for (; olist; olist = sp_next(olist)) {
		*nlist = (Stockp) doalloc (sizeof *sp);
		**nlist = *olist;
		nlist = &(*nlist) -> next;
		*nlist = NULL;
	}
}

static void push_world ()
{
	Sector sct, osct;
	Plane plane, *pp;
	Ship ship, *sp;
	Land land, *lp;
	int ix, iy;

	/* push planes */
	pp = &s_plane;
	for ALL_PLANES(plane) {
		*pp = (Plane) doalloc(sizeof *plane);
		**pp = *plane;
		(*pp) -> next = (Plane)0;
		pp = &(*pp) -> next;
	}
	/* now swap */
	plane = first_plane;
	first_plane = s_plane;
	s_plane = plane;

	/* push ships */
	sp = &s_ship;
	for ALL_SHIPS(ship) {
		*sp = (Ship) doalloc (sizeof *ship);
		**sp = *ship;
		(*sp)->next = (Ship)0;
		sp = &(*sp) -> next;
	}
	ship = shiplist;
	shiplist = s_ship;
	s_ship = ship;

	if (land_units) {
		/* push lands */
		lp = &l_land;
		for ALL_LANDS(land) {
			*lp = (Land) doalloc (sizeof *land);
			**lp = *land;
			(*lp)->next = (Land)0;
			lp = &(*lp) -> next;
		}
		land = landlist;
		landlist = l_land;
		l_land = land;
	}

	/* push world */
	s_world = world;
	world = MallocWorld ();
	for (ix = 0; ix < MAX_X; ix++)
		for (iy = 0; iy < MAX_Y/2; iy++) {
			if ((osct = s_world[ix][iy]) == (Sector) 0)
				continue;
			sct = (Sector) doalloc ((unsigned) sizeof (struct s_sector1));
			world [ix][iy] = sct;
			*sct = *osct;
			if (osct -> sct2 != (Sct2)0) {
				sct->sct2 = (Sct2)
					doalloc ((unsigned) sizeof (struct s_sector2));
				*sct -> sct2 = *osct -> sct2;
			}
			if (osct -> sct2 && osct -> sct2 -> sct3 != (Sct3)0) {
				sct -> sct2 -> sct3 =
					(Sct3) doalloc ((unsigned) sizeof (struct s_sector3));
				*sct -> sct2 -> sct3 =
					*osct -> sct2 -> sct3;
			}
			if (osct -> fship)
				relink_ships(&sct -> fship, osct -> fship);
			if (osct -> fland && land_units)
				relink_lands(&sct -> fland, osct -> fland);
			if (osct -> fplane)
				relink_plane (&sct -> fplane, osct -> fplane);
			if (osct -> stock)
				relink_nuke(&sct -> stock, osct -> stock);
		}
}

static void pop_world ()
{
	Sector sct;
	Plane pp, p2;
	Ship sp, s2;
	Land lp, l2;
	int ix, iy;

	/* pop planes */
	for (pp = first_plane; (p2 = pp) != (Plane)0;) {
		pp = pl_next(pp);
		free ((char *)p2);
	}
	first_plane = s_plane;
	s_plane = (Plane)0;

	/* pop ships */
	for (sp = shiplist; (s2 = sp) != (Ship)0;) {
		sp = sh_next(sp);
		free ((char *)s2);
	}
	shiplist = s_ship;
	s_ship = (Ship)0;

	if (land_units) {
		/* pop lands */
		for (lp = landlist; (l2 = lp) != (Land)0;) {
			lp = ld_next(lp);
			free ((char *)l2);
		}
		landlist = l_land;
		l_land = (Land)0;
	}

	/* pop sectors */
	for (ix = 0; ix < MAX_X; ix++) {
		for (iy = 0; iy < MAX_Y/2; iy++) {
			if ((sct = world[ix][iy]) == (Sector)0)
				continue;
			if (sct -> sct2) {
				if (sct -> sct2 -> sct3)
					free ((char *)sct -> sct2 -> sct3);
				free ((char *)sct -> sct2);
			}
			if (sct -> stock) {
				Stockp sp, sp2;
				for (sp = sct -> stock; sp; sp = sp2) {
					sp2 = sp_next(sp);
					free ((char *)sp);
				}
			}
					
			free ((char *)sct);
		}
		free ((char *)world[ix]);
	}
	free ((char *)world);
	world = s_world;
	s_world = 0;
}

void SimulateUpdate (realm)
char * realm;
{
	Strings strings;
	double update_delta;
	register int i;
	static bool world_pushed = False;
	long upd_enlcost = 3;

	upd_buildeff = upd_enlist = upd_totalciv = upd_totalmil =
		upd_totaluw = 0L;
	
	upd_ship_eff = upd_ship_main = upd_plane_eff = upd_plane_main =
		upd_land_eff = upd_land_main = upd_landmilcost =
		upd_ship_crew = upd_bankint =  upd_milcost = 
		upd_civ_taxes = (double) 0;
	
	for (i = 1; i < V_MAX + 4; i ++)
		upd_prodcost [i] = 0L;

	if (! world_pushed)
	{
		push_world ();
		world_pushed = True;
	}
	strings = InitStrings ();
		Message ("updating ships");
		UpdProdShip (realm, etu_per_update, strings);
		Message ("updating planes");
		UpdProdPlane (realm, etu_per_update, strings);
		if (land_units) {
			Message ("updating lands");
			UpdProdLand (realm, etu_per_update, strings);
		}
		Message ("updating sectors");
		UpdProdSect (realm, etu_per_update, strings);
	/* prod_nat(etu); */
	/* age_levels(etu); */
	Message ("updating mobility");
	UpdMobShip (realm, etu_per_update);
	UpdMobSect (realm, etu_per_update);
	UpdMobPlane (realm, etu_per_update);
	if (land_units)
		UpdMobLand (realm, etu_per_update);
	Message ("Update simulated");

	AddString (strings, "");
	AddString (strings, "Financial report");
	AddString (strings, "----------------");

	AddString (strings, Fmt ("Income:  %-18.18s       $%.2lf",
			Fmt ("%ld civilians:", upd_totalciv),
			upd_civ_taxes));

	if (EMPOption(MERC)) {
		AddString (strings, Fmt ("         %-18.18s       $%.2lf",
			Fmt ("%ld unc. workers:", upd_totaluw),
			etu_per_update * upd_totaluw * money_uw));
	}

	AddString (strings, Fmt ("         bank interest:           $%.2lf",
			upd_bankint));

	AddString (strings, "");
	AddString (strings, Fmt ("Costs:   %-18.18s       $%.2lf",
			Fmt ("%ld mils:", upd_totalmil),
			- upd_totalmil * etu_per_update * money_mil));
	AddString (strings, Fmt ("         national reserve:        $%.2lf",
			- n_mil_res (nation) * etu_per_update * money_res));

	AddString (strings, Fmt ("         building efficiency:     $%d",
			- upd_buildeff));

	AddString (strings, "");
	AddString (strings, Fmt ("         ship build efficiency:   $%.2lf",
			- upd_ship_eff));
	AddString (strings, Fmt ("         ship maintainance:       $%.2lf",
			- upd_ship_main));
	AddString (strings, Fmt ("         ship crew:               $%.2lf",
			- upd_ship_crew));
	AddString (strings, Fmt ("         Total navy delta:        $%.2lf",
			- upd_ship_eff - upd_ship_main - upd_ship_crew));

	AddString (strings, "");
	AddString (strings, Fmt ("         plane build efficiency:  $%.2lf",
			- upd_plane_eff));
	AddString (strings, Fmt ("         plane maintainance:      $%.2lf",
			- upd_plane_main));
	AddString (strings, Fmt ("         plane crew:              $%.2lf",
			- upd_milcost));
	AddString (strings, Fmt ("         Total airforce delta:    $%.2lf",
			- upd_plane_eff - upd_plane_main - upd_milcost));

	if (land_units) {

		AddString (strings, "");
		AddString (strings, Fmt ("         land build efficiency:  $%.2lf",
                        - upd_land_eff));
		AddString (strings, Fmt ("         land maintainance:      $%.2lf",
                        - upd_land_main));
		AddString (strings, Fmt ("         land crew:              $%.2lf",
                        - upd_landmilcost));
		AddString (strings, Fmt ("         Total landforce delta:  $%.2lf",
                        - upd_land_eff - upd_land_main - upd_landmilcost));

	}

	AddString (strings, "");
	AddString (strings, "Production costs:");

	for (i = 1; i < V_MAX; i ++)
		if (upd_prodcost [i] > 0L)
			AddString (strings,
				Fmt ("         %-16.16s         $%ld",
					ItemName (i),
					upd_prodcost [i]));
	
	for (i = 0; i <=3 ; i++)
		if (upd_prodcost [V_MAX + i] > 0L)
			AddString (strings,
				Fmt ("         %-16.16s         $%ld",
					levelnames [i],
					upd_prodcost [V_MAX + i]));


	if (upd_enlist != 0L)
		AddString (strings, Fmt ("         enlistment:              $%ld",
				- upd_enlist * upd_enlcost));

	AddString (strings, "");
	update_delta =
		upd_civ_taxes +
		upd_bankint +
		etu_per_update * upd_totalmil * money_mil +
		etu_per_update * n_mil_res (nation) * money_res +
		upd_buildeff +
		upd_ship_eff +
		upd_ship_main +
		upd_ship_crew +
		upd_plane_eff +
		upd_plane_main +
		upd_enlist * upd_enlcost +
		upd_milcost;

		if (EMPOption (MERC))
			update_delta += etu_per_update * upd_totaluw  * money_uw;

		if (land_units)
			update_delta += upd_land_eff + upd_land_main + upd_landmilcost;

	for (i = 1; i <= V_MAX + 3; i ++)
		if (upd_prodcost [i] > 0L)
			update_delta -= (double) upd_prodcost [i];

	AddString (strings, Fmt ("Total money delta: $%.2f", update_delta));
#ifdef TERMC_VERSION
	ShowStringsInPager (strings, "Simulated update");
#else /* TERMC_VERSION */
	InitWMPager (strings, "Simulated update");
#endif /* TERMC_VERSION */
	if (Confirm ("Reset world", True))
	{
		world_pushed = False;
		pop_world ();
	}
}
