/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/path.c,v 5.2 1995/08/15 08:01:07 jpo Exp $
    $Date: 1995/08/15 08:01:07 $
    $Author: jpo $
    $Id: path.c,v 5.2 1995/08/15 08:01:07 jpo Exp $
    $Locker:  $
    $Log: path.c,v $
    Revision 5.2  1995/08/15 08:01:07  jpo
    changes to NavigOK

 * Revision 5.1  93/03/14  16:51:37  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "slist.h"

void FreeSList (list)
SList * list;
{
	SList next;

	while (* list != (SList) 0)
	{
		next = (* list)-> next;
		if ((* list)-> path != (char *) 0)
			free ((* list)-> path);
		free ((char *) * list);
		* list = next;
	}
}

bool InSList (list, sct)
SList list;
Sector sct;
{
	while (list != (SList) 0)
	{
		if (list-> sct == sct)
			return True;
		
		list = list-> next;
	}

	return False;
}

	/*
	 *	Add to the end of the list
	 */

	/*
	 *	        \   /
	 *     y u  uj   \ /   u y
	 *    g S j    ujj|jj j E g
	 *     b n       / \   n b
	 */

void AddToSList (list, sct, from, forw)
SList * list;
Sector sct;
SList from;
bool forw;
{
	SList new;
	SList ptr;

	new = (SList) doalloc ((unsigned) sizeof (struct s_slist));
	new-> sct = sct;
	new-> marked = False;
	new-> next = (SList) 0;

	if (from == (SList) 0)
		new-> path = (char *) 0;
	else if (from-> path == (char *) 0)
		new-> path = Str (Fmt ("%c",
			forw ?  GiveDirChar (from-> sct, sct)
			     :  GiveDirChar (sct, from-> sct)));
	else if (forw)
		new-> path = Str (Fmt ("%s%c", from-> path,
						GiveDirChar (from-> sct, sct)));
	else
		new-> path = Str (Fmt ("%c%s", GiveDirChar (sct, from-> sct),
						from-> path));
	
	if (* list == (SList) 0)
	{
		* list = new;
		return;
	}
	else
	{
		for (ptr = * list; ptr-> next != (SList) 0; ptr = ptr-> next);

		ptr-> next = new;
		return;
	}
}

char * GivePath (list, sct)
SList list;
Sector sct;
{
	for (; list != (SList) 0 && list-> sct != sct; list = list-> next);
	if (list == (SList) 0)
	{
		Panic ("GivePath", "ship/path.c", "Can't find sector");
		return "";
	}

	if (list-> path == (char *) 0)
		return "";

	return list-> path;
}

SList FirstNotMarked (list)
SList list;
{
	SList ptr;

	for (ptr = list; ptr != (SList) 0; ptr = ptr-> next)
		if (! ptr-> marked)
		{
			ptr-> marked = True;
			return ptr;
		}

	return (SList) 0;
}

bool NavigOK (sct)
Sector sct;
{
	if (NO_INFO (sct))
		return True;

	if (s_mines (sct) != 0)
		return False;

	if (s_des (sct) == '.')
		return True;
	
	if (s_des (sct) == 'h' || s_des (sct) == '=')
		return True;
	
	return False;
}
	
char * BestSeaPath (from, to)
Sector from;
Sector to;
{
	SList start, end;
	int in_start, in_end;
	int i, j;
	SList tmp;
	Neighb neighb;
	Sector nxt;
	static char buffer [BUFSIZ];

	InitNeighbours (from, & neighb);
	while (NextNeighbour (& nxt, S_EXIST, neighb))
		if (nxt == to)
			return Fmt ("%c", GiveDirChar (from, to));


	end = start = (SList) 0;
	AddToSList (& start, from, (SList) 0, True);
	AddToSList (& end, to, (SList) 0, False);
	in_start = in_end = 1;

	for (;;)
	{
		if (in_start == 0 || in_end == 0)
		{
			FreeSList (& start);
			FreeSList (& end);
			return (char *) 0;
		}

		j = 0;
		for (i = 1; i <= in_start; i ++)
		{
			tmp = FirstNotMarked (start);
			InitNeighbours (tmp-> sct, & neighb);
			while (NextNeighbour (& nxt, S_DESIG, neighb))
			{
				if (NavigOK (nxt) && ! InSList (start, nxt))
				{
					j ++;
					AddToSList (& start, nxt, tmp, True);
				}

				if (InSList (end, nxt))	/* found */
				{
					strcpy (buffer, Fmt ("%s%s",
						GivePath (start, nxt),
						GivePath (end, nxt)));
					FreeSList (& start);
					FreeSList (& end);
					return buffer;
				}
			}
		}
		in_start = j;

		if (in_end == 0)
		{
			FreeSList (& start);
			FreeSList (& end);
			return (char *) 0;
		}

		j = 0;
		for (i = 1; i <= in_end; i ++)
		{
			tmp = FirstNotMarked (end);
			InitNeighbours (tmp-> sct, & neighb);
			while (NextNeighbour (& nxt, S_DESIG, neighb))
			{
				if (NavigOK (nxt) && ! InSList (end, nxt))
				{
					j ++;
					AddToSList (& end, nxt, tmp, False);
				}

				if (InSList (start, nxt))	/* found */
				{
					strcpy (buffer, Fmt ("%s%s",
						GivePath (start, nxt),
						GivePath (end, nxt)));
					FreeSList (& start);
					FreeSList (& end);
					return buffer;
				}
			}
		}
		in_end = j;
	}
}
