/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/mark.c,v 5.2 1995/09/08 07:43:06 jpo Exp $
    $Date: 1995/09/08 07:43:06 $
    $Author: jpo $
    $Id: mark.c,v 5.2 1995/09/08 07:43:06 jpo Exp $
    $Locker:  $
    $Log: mark.c,v $
    Revision 5.2  1995/09/08 07:43:06  jpo
    const

    Revision 5.1  1993/03/14 16:51:36  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

void UnmarkAllShips ()
{
	Ship ptr;

	for ALL_SHIPS (ptr)
		set_sh_marked (ptr, False);
}

void MarkShips (form)
const char * form;
{
	Ship ptr;
	int sx, sy, ex, ey;
	int nr;

	if (strcmp (form, "*") == 0)
	{
		for ALL_SHIPS (ptr)
			set_sh_marked (ptr, True);

		return;
	}

	if (strlen (form) == 1 && (isalpha (* form) || * form == '~'))
	{
		for ALL_SHIPS (ptr)
			if (sh_fleet (ptr) == * form)
				set_sh_marked (ptr, True);
		return;
	}

	if (ConvRealmToCoord (form, & sx, & sy, & ex, & ey))
	{
		for ALL_SHIPS (ptr)
			if (sh_xcd (ptr) >= sx && sh_xcd (ptr) <= ex &&
			    sh_ycd (ptr) >= sy && sh_ycd (ptr) <= ey)
				set_sh_marked (ptr, True);
		return;
	}

	while (ScanDigit (& form, & nr))
	{
		ptr = NrToShip (nr);
		if (ptr != (Ship) 0)
			set_sh_marked (ptr, True);
		if (* form == '/')
			form ++;
	}
}

int MinMobMarkedShips (ship)
Ship * ship;
{
	Ship ptr;
	bool found;
	int min;

	if (ship != (Ship *) 0)
		* ship = (Ship) 0;

	found = False;
	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			if (! found)
			{
				found = True;
				if (ship != (Ship *) 0)
					* ship = ptr;
				min = sh_mob (ptr);
			}
			else if (sh_mob (ptr) < min)
			{
				min = sh_mob (ptr);
				if (ship != (Ship *) 0)
					* ship = ptr;
			}
	
	if (! found)
		return -1;
	else
		return min;
}

bool CrewOnMarkedShips (ship)
Ship * ship;
{
	Ship ptr;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			if (sh_mil (ptr) == 0 && sh_civ (ptr) == 0)
			{
				if (ship != (Ship *) 0)
					* ship = ptr;
				return False;
			}
	
	if (ship != (Ship *) 0)
		* ship = (Ship) 0;

	return True;
}

bool MarkedColocated ()
{
	Ship ptr;
	bool found;
	int x, y;

	found = False;
	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			if (! found)
			{
				found = True;
				x = sh_xcd (ptr);
				y = sh_ycd (ptr);
			}
			else
				if (x != sh_xcd (ptr) || y != sh_ycd (ptr))
					return False;
	
	return True;
}

bool LandLockedMarked (ship)
Ship * ship;
{

	Ship ptr;
	Sector sct;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
		{
			sct = World (sh_xcd (ptr), sh_ycd (ptr), S_EXIST);
			if (sct == (Sector) 0 || ! AllowNavigate (sct))
			{
				if (ship != (Ship *) 0)
					* ship = ptr;

				return True;
			}
		}
	
	return False;
}

Sector SctMarkedShips ()
{
	Ship ptr;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			return World (sh_xcd (ptr), sh_ycd (ptr),
						S_EXIST);
	
	return (Sector) 0;
}

void FScanResoMarked (sct)
Sector sct;
{
	bool oil, food;
	Ship ptr;

	food = False;
	oil = False;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
		{
			if (ShipHas (ptr, M_FISH))
				food = True;
			if (ShipHas (ptr, M_OIL))
				oil = True;
		}

	if (oil || (food && ! KNOW_FER (sct)))
		FScanReso ();
}

void CheckShips (what)
const char * what;
{
	Ship ptr, next;
	char buffer [1024];
	bool first;

	if (command_state == TEST_STATE)
		return;

	UnmarkAllShips ();
	MarkShips (what);
	(void) DumpShips (what, DONT_PRINT);
	buffer [0] = '\0';
	first = True;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
		{
			if (first)
			{
				first = False;
				strcat (buffer, Fmt ("%d", sh_nr (ptr)));
			}
			else
				strcat (buffer, Fmt ("/%d", sh_nr (ptr)));
		}
	
	if (first)
		return;
			
	DumpShips (buffer, DONT_PRINT);

	ptr = shiplist;
	while (ptr != (Ship) 0)
		if (sh_marked (ptr))
		{
			Error (Fmt ("You seem to have lost %s #%d",
					ShipName (ptr),
					sh_nr (ptr)));
			next = sh_next (ptr);
			DeleteShip (ptr);
			ptr = next;
		}
		else
			ptr = sh_next (ptr);
}

int MaxSonarMarked (shnr)
int * shnr;
{
	Ship ptr;
	int max;
	int shipnr;

	max = -1;
	shipnr = -1;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			if (sh_sonar (ptr) > max)
			{
				max = sh_sonar (ptr);
				shipnr = sh_nr (ptr);
			}
	
	if (shnr != (int *) 0)
		* shnr = shipnr;
	
	return max;
}

int MaxRadarMarked (shnr)
int * shnr;
{
	Ship ptr;
	int max;
	int shipnr;

	max = -1;
	shipnr = -1;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			if (sh_radar (ptr) > max)
			{
				max = sh_radar (ptr);
				shipnr = sh_nr (ptr);
			}
	
	if (shnr != (int *) 0)
		* shnr = shipnr;
	
	return max;
}
	
void MoveMarkedTo (sct)
Sector sct;
{
	Ship ptr;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			MoveShip (ptr, sct);
}

int BestMarkedRadar ()
{
	int max;
	Ship ptr;
	int shipnr;

	max = -1;
	shipnr = -1;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			if (sh_radar (ptr) > max)
			{
				shipnr = sh_nr (ptr);
				max = sh_radar (ptr);
			}

	return shipnr;
}

int FirstMarkedShipnr ()
{
	register Ship ptr;

	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			return sh_nr (ptr);
	
	return -1;
}

void DeleteMarkedEnemyShips ()
{
	register Ship ptr;
	Ship next;
	int flag = 0;

	ptr = shiplist;
	while (ptr != (Ship) 0)
		if (sh_marked (ptr) && ! sh_owned (ptr))
		{
	/* TARL - Speak up when ships are deleted */
			PrintAtEmpire(Fmt(
			"%s #%d owned by %s last seen at %d,%d is off the radar screens",
			ShipName (ptr), sh_nr(ptr), CountryName (ptr->owner),
			ptr->x, ptr->y));
			flag = 1;
			next = sh_next (ptr);
			DeleteShip (ptr);
			ptr = next;
		}
		else
			ptr = sh_next (ptr);
	if (flag)
		PrintAtEmpire ("");
}
