/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/assault.c,v 5.2 1995/08/15 07:58:35 jpo Exp $
    $Date: 1995/08/15 07:58:35 $
    $Author: jpo $
    $Id: assault.c,v 5.2 1995/08/15 07:58:35 jpo Exp $
    $Locker:  $
    $Log: assault.c,v $
    Revision 5.2  1995/08/15 07:58:35  jpo
    fixed a few spellings...

 * Revision 5.1  93/03/14  16:51:32  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "land.h"
#include "version.h"

static Ship last_ship = (Ship) 0;
static int last_mil;
static int last_x, last_y;

	/* ARGSUSED */
void BindAssault (x, y, str)
int x, y;
char * str;
{
	DoAssault (x, y, (Ship) 0, 0);
}

void RedoAssault ()
{
	DoAssault (last_x, last_y, last_ship, last_mil);
}

void Assault (x, y)
int x, y;
{
	DoAssault (x, y, (Ship) 0, 0);
}

void DoAssault (x, y, ship, amils)
int x, y;
Ship ship;
int amils;
{
	Strings strings;
	Pager pager;
	Sector nxt;
	int select, nr;
	Neighb neighb;
	int taken, def, mils, a_mils, units = 0, lnd;
	bool gotmils;
	bool rescan;
	bool won;
	bool ownassault = False;
	int i;
	char *line, *answer;
	char * ans;
	double needed;
	Sector sct;
	char * ptri;
	int left;

	nr = 0;
	gotmils = False;

	strings = InitStrings ();

	if (cursct == (Sector) 0 || (s_owned (cursct) && !EMPOption(OWNASSAULT)) || index ("s\\.", s_des (cursct)) != (char *) 0)
	{
		Message ("You cannot assault that.");
		Bell ();
		return;
	}

	if (ship == (Ship) 0)
	{
		InitNeighbours (cursct, & neighb);
		nxt = cursct;
		do
		{
			if (nxt == (Sector) 0 || NO_INFO (nxt))
				continue;

			if (cursct != nxt && s_des (nxt) != '.')
				continue;

			for (ship = s_fship (nxt); ship != (Ship) 0;
						   ship = sh_nxtsct (ship))
			{

				if (! sh_owned (ship))
					continue;

				nr++;
				mils = sh_mil (ship);
				if (land_units)
					units = sh_land (ship);
				if (mils <= 0 && units <= 0)
					continue;

				gotmils = True;

				AddStringID (strings,
					       Fmt ("%s #%d @ %s (%d mils)%s",
								ShipName (ship),
								sh_nr (ship),
								CrdStr (nxt),
								mils,
								land_units ? Fmt (" (%d units)",units) : ""),
							sh_nr (ship));
			}
		}
		while (NextNeighbour (& nxt, S_EXIST, neighb));

		if (nr == 0)
		{
			Message ("No ships nearby the target sector");
			Bell ();
			FreeStrings (strings);
			return;
		}

		if (! gotmils)
		{
			Message (
			"None of the ships have military on board");
			Bell ();
			FreeStrings (strings);
			return;
		}
				
		pager = InitPager (strings, "Assault from which ship ?");
		MapPagerFromTop (pager, map_win, x, y);
		select = PagerMenu (pager);
		FreePager (pager);
		FreeStrings (strings);

		if (select < 0)
		{
			Message ("Assault cancelled");
			return;
		}

		ship = NrToShip (select);
	}
	else
	{
		/* Hope we didn't loose the ship since last time */

		if (sh_mil (ship) == 0 && sh_land (ship) == 0)
		{
			Message ("No military to assault with!");
			Bell ();
			last_ship = (Ship) 0;
			last_mil = 0;
			return;
		}

		sct = ShipSector (ship);
		select = sh_nr (ship);
		if (cursct != sct)
		{
			if (! IsNeighbour (sct, cursct))
			{
				Message ("Target too far away");
				Bell ();
				return;
			}

			if (s_des (sct) != '.')
			{
				Message ("Too far inland");
				Bell ();
				return;
			}
		}
	}

	FeedEmpire (Fmt ("assault %s %d", CrdStr (cursct), select), PRINT);
	SetAgain (RedoAssault);
	last_ship = ship;
	last_mil = 0;
	last_x = x;
	last_y = y;

	for (;;)
	{
		line = WaitForPrompt (PRINT);

			/*
			 *	Treaty check
			 */

		if (StrEQ (line, "Do you wish to go ahead"))
		{
			ans = InputAtMessage (line, 1, "yn");
			if (ans == (char *) 0 || interrupt || * ans == '\0'
				|| * ans == 'n')
			{
				FeedEmpire ("n", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}
			FeedEmpire (ans, PRINT);

			continue;
		}

		if (EmpireStatus () != E_QUESTION)
		{
			Bell ();
			Message ("Assault failed");
			(void) WaitForPrompt (PRINT);
			return;
		}


		ptri = index (line, '(');
		if (ptri == (char *) 0 ||
					sscanf (ptri, "( max %d )", & def) == 0)
			def = sh_mil (ship);

		break;
	}

	rescan = False;	/* rescan ship */
	won = False;	/* rescan sector */

	if (def == sh_mil (ship) && sh_civ (ship) == 0 && def > 1)
		def --;

	for (;;)
	{
		if (amils == 0)
		{
			Bell ();
			answer = InputAtMessage (Fmt (
				"Attack with [%d]: ", def), 3, GS_PNUMBER);

			/*
			answer = InputAtMessage (Fmt ("%s", line), 3,
								GS_PNUMBER);
			*/


			if (interrupt || answer == (char *) 0)
			{
				interrupt = False;
				Message ("Assault cancelled");
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}

			if (* answer == '\0')
				a_mils = def;
			else
				a_mils = atoi (answer);
		}
		else
		{
			a_mils = amils;
			amils = 0;
		}

		mils = sh_mil (ship);

		if (a_mils <= 0 && sh_land (ship) == 0)
		{
			Message ("No mils to attack");
			Bell ();
			FeedEmpire ("aborted", PRINT);
			(void) WaitForPrompt (PRINT);
			return;
		}

		if (a_mils > mils)
		{
			Message (Fmt ("Only %d mils to assault", mils));
			a_mils = mils;
		}
		else
			Message (Fmt ("Assaulting with %d military", a_mils));
		
		if (a_mils == sh_mil (ship) && sh_civ (ship) == 0)
			if (! Confirm (
				"Would leave ship unpopulated, continue?",
				True))
			{
					Message ("Assault cancelled");
					FeedEmpire ("aborted", PRINT);
					(void) WaitForPrompt (PRINT);
					return;
			}


			/*
			 *	Check if there will be enough food on the ship
			 *
			 *	Changed on 920218 -> a_mils inst. off mils
			 */

		taken = (int) (sh_foo (ship) * a_mils / (sh_civ (ship) +
							sh_mil (ship)) + 0.5);
		left = sh_foo (ship) - taken;
		needed = (sh_civ (ship) + sh_mil (ship) - mils + sh_uw (ship))
					* etu_per_update * eatrate;

		if (needed > (double) left)
		{
		   if (no_food == False)
		      if (! Confirm (Fmt (
		"Will leave ship #%d with not enough food! (%d vs. %.1f)",
					  sh_nr (ship), left, needed), False))
			 continue;
		}

		break;
	}

	FeedEmpire (Fmt ("%d", a_mils), PRINT);
	last_mil = a_mils;
	set_sh_mil (ship, sh_mil (ship) - a_mils);

	while (line = ReadEmpire (PRINT))
	{
		if (line == (char *) 0 && !ownassault)
			return;

		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (line);
			Bell ();
			answer = InputAtMessage (line, 10, GS_YN);
			if (interrupt || answer == (char *) 0)
			{
				interrupt = False;
				Message ("Assault cancelled");
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}

			FeedEmpire (answer, PRINT);
			continue;
		}

		if (sscanf (line, "Yours%*[.] %d", & i) == 1)
		{
			set_sh_mil (ship, sh_mil (ship) - i);
			continue;
		}

		if (sscanf (line, "Theirs%*[.] %d", & i) == 1)
		{
			if (! KNOW_LOO (cursct) && ! KNOW_SPY (cursct))
				break;

			set_civ (cursct, s_civ (cursct) - i);
			break;	/* last message */
		}
		if (sscanf (line, "You reinforce sector %*d,%*d with %d troops", &i) == 1) {
			set_mil (cursct, s_mil (cursct) + i);
			ownassault = True;
			continue;
		}
		ptri = index (line, '#');
		if (ptri != (char *) 0) {
			(void) sscanf (ptri, "%d lands ", &lnd);
			MoveLand (NrToLand (lnd), cursct);
			RedumpLand (NrToLand (lnd), DONT_PRINT);
			ownassault = True;
			continue;
		}

		ptri = index (line, '%');
		if (ptri != (char *) 0)
			if (StrEQ (ptri, "% damage"))	/* incomming shells */
				rescan = True;

		if (EmpireStatus () == E_COMMAND)
		{
			if (ownassault)
				break;	
			Bell ();
			Message ("Bad answer from empire. Command Failed ?");
			PrintAtEmpire (line);
			return;
		}

		if (StrEQ (line, "You have been defeated"))
		{
			Bell ();
			Message ("Sorry Boss, seems we've been defeated");
			continue;
		}

		if (StrEQ (line, "You have taken sector"))
		{
			Bell ();
			Message ("Veni Vedi Vici !!!");
			won = True;
		}
	}

	if (EmpireStatus () != E_COMMAND)
		(void) WaitForPrompt (PRINT);

	if (rescan)
		RedumpShip (ship, PRINT);
	
	if (won)
	{
		RedumpSector (cursct, DONT_PRINT);
		rescan = False;
		InitNeighbours (cursct, & neighb);
		while (NextNeighbour (& nxt, S_EXIST, neighb))
			if (nxt == (Sector) 0 || NO_INFO (nxt))
			{
				rescan = True;
				break;
			}

		if (rescan)
		{
			FScanMap (Fmt ("%d:%d,%d:%d",
				s_xcd (cursct) - 2, s_xcd (cursct) + 2,
				s_ycd (cursct) - 1, s_ycd (cursct) + 1),
			  PRINT);

			DrawNeighbours (cursct);
		}
	}
}
