/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/plane/RCS/launch.c,v 5.2 1995/09/08 07:39:44 jpo Exp $
    $Date: 1995/09/08 07:39:44 $
    $Author: jpo $
    $Id: launch.c,v 5.2 1995/09/08 07:39:44 jpo Exp $
    $Locker:  $
    $Log: launch.c,v $
    Revision 5.2  1995/09/08 07:39:44  jpo
    renamed routines

 * Revision 5.1  93/03/14  16:51:08  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:20  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:42:01  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"

static Sector LaunchDesignation (quest, range)
char * quest;
int range;
{
	Sector sct;
	int button;
	int x, y;

	Message (Fmt ("%s (range %d)", quest, range));
	MesBut ("View", "Cancel", "Launch");

	for (;;)
	{
		if (! SelectSctCrd (& x, & y, & button) || interrupt ||
						button == MIDDLE_BUTTON)
		{
			Message ("Launch cancelled");
			interrupt =  False;
			ClearMes ();
			MesClearBut ();
			return (Sector) 0;
		}

		sct = World (x, y, S_DESIG);
		if (sct == (Sector) 0)
			continue;

		if (button == LEFT_BUTTON)
		{
			CensusSct (sct);
			continue;
		}

		if (Dist (s_xcd (cursct), x, s_ycd (cursct), y) > range)
		{
			Message (Fmt ("Too far away (range is %d)", range));
			Bell ();
			continue;
		}

		MesClearBut ();
		return sct;
	}
}

void LaunchWing (wing)
char *wing;
{
	Sector sct;
	Plane missile, plane;
	bool nuke, launched;
	register char * p;
	char * ptr, * ans;
	int x, y;
	int nr;

	missile = 0;
	launched = nuke = False;
	FeedEmpire (Fmt ("launch %s", wing), PRINT);

	for (;;)
	{
		ptr = ReadEmpire (PRINT);
		if ((p = index(ptr,'#')) != 0) {
			nr = atoi(p+1);
			curplane = missile = NrToPlane(nr);
		}
		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (ptr);
			if (StrEQ (ptr, "RV #") || StrEQ (ptr, "Target"))
			{
				nuke = StrEQ (ptr, "RV");
				launched = True;

				do {
					sct = LaunchDesignation (
						"Launch missile",
						pl_range (missile));
				} while (sct == (Sector) 0);

				FeedEmpire (CrdStr (sct), PRINT);
				continue;
			}

			ans = InputAtMessage (ptr, 10, GS_TEXT);
			if (ans == (char *) 0 || interrupt)
			{
				Message ("Aborting launch");
				while (EmpireStatus () != E_COMMAND)
				{
					FeedEmpire ("aborted", PRINT);
					ptr = WaitForPrompt (PRINT);
				}
				PrintAtEmpire (ptr);
				Message ("Launch aborted");
				return;
			}

			FeedEmpire (ans, PRINT);
			continue;
		}
		else if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			if (launched)
			{
				plane = pl_nxtsct (curplane);
				curplane = plane;
				Message ("Launch done");
			}
			else
			{
				Message ("Launch failed!");
				Bell ();
			}
			if (! nuke)
				FScanDump (CrdStr (cursct), PRINT);
			CensusPlane (curplane);
			return;
		}
		else if (EmpireStatus () == E_PRINTING)
		{
			if (sscanf (ptr, "turned %d,%d into a radio",
						& x, & y) == 2)
			{
					/* Gniffel */
				sct = World (x, y, S_DESIG);
				UpdateSectorDes (sct, '\\', True);
				DrawSector (sct);
				continue;
			}
			else if (sscanf (ptr, "left nothing but water in %d,%d",
						& x, & y) == 2)
			{
				sct = World (x, y, S_DESIG);
				UpdateSectorDes (sct, '\\', True);
				DrawSector (sct);
				continue;
			}

				/*
				 *	Think you don't want to redump
				 *	YOUR sectors while nuking...
				 *
				 *	Also no use scanning damages.
				 */

			if (StrEQ (ptr, "KABOOOOM"))
			{
				Message ("Damned, launch failed !");
				Bell ();
				(void) WaitForPrompt (PRINT);
				plane = curplane;
				DeletePlane (curplane);
				curplane = plane;
			}
			if (StrEQ (ptr, "Launching!"))
			{
				DeletePlane (curplane);
			}
		}
	}
}

void LaunchMissile (missile)
Plane missile;
{
	Sector sct;
	Plane plane;
	bool nuke, launched;
	char * ptr, * ans;
	int x, y;

	if (pl_eff (missile) < 60)
	{
		Message ("You can't launch that, must be at least 60%");
		Bell ();
		return;
	}

	launched = nuke = False;
	FeedEmpire (Fmt ("launch %d", pl_nr (missile)), PRINT);

	for (;;)
	{
		ptr = ReadEmpire (PRINT);
		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (ptr);
			if (StrEQ (ptr, "RV #") || StrEQ (ptr, "Target"))
			{
				nuke = StrEQ (ptr, "RV");
				launched = True;

				do {
					sct = LaunchDesignation (
						"Launch missile",
						pl_range (missile));
				} while (sct == (Sector) 0);

				FeedEmpire (CrdStr (sct), PRINT);
				continue;
			}

			ans = InputAtMessage (ptr, 10, GS_TEXT);
			if (ans == (char *) 0 || interrupt)
			{
				Message ("Aborting launch");
				while (EmpireStatus () != E_COMMAND)
				{
					FeedEmpire ("aborted", PRINT);
					ptr = WaitForPrompt (PRINT);
				}
				PrintAtEmpire (ptr);
				Message ("Launch aborted");
				return;
			}

			FeedEmpire (ans, PRINT);
			continue;
		}
		else if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			if (launched)
			{
				plane = pl_nxtsct (curplane);
				DeletePlane (curplane);
				curplane = plane;
				Message ("Launch done");
			}
			else
			{
				Message ("Launch failed!");
				Bell ();
			}
			if (! nuke)
				FScanDump (CrdStr (cursct), PRINT);
			CensusPlane (curplane);
			return;
		}
		else if (EmpireStatus () == E_PRINTING)
		{
			if (sscanf (ptr, "turned %d,%d into a radio",
						& x, & y) == 2)
			{
					/* Gniffel */
				sct = World (x, y, S_DESIG);
				UpdateSectorDes (sct, '\\', True);
				DrawSector (sct);
				continue;
			}
			else if (sscanf (ptr, "left nothing but water in %d,%d",
						& x, & y) == 2)
			{
				sct = World (x, y, S_DESIG);
				UpdateSectorDes (sct, '\\', True);
				DrawSector (sct);
				continue;
			}

				/*
				 *	Think you don't want to redump
				 *	YOUR sectors while nuking...
				 *
				 *	Also no use scanning damages.
				 */

			if (StrEQ (ptr, "KABOOOOM"))
			{
				Message ("Damned, launch failed !");
				Bell ();
				(void) WaitForPrompt (PRINT);
				plane = curplane;
				DeletePlane (curplane);
				curplane = plane;
				if (! nuke)
					FScanDump (CrdStr (cursct), PRINT);
				PlaneCensus (curplane);
				return;
			}
		}
	}
}
	
void LaunchSatellite (plane)
Plane plane;
{
	Sector sct;
	Sector des;
	int x, y;
	bool launched;
	char * ptr, * ans, * ptri;

	launched = False;
	sct = LaunchDesignation ("Launch satellite", pl_range (plane));
	if (sct == (Sector) 0)
	{
		Message ("Launch cancelled");
		return;
	}

	FeedEmpire (Fmt ("launch %d", pl_nr (plane)), PRINT);
	for (;;)
	{
		ptr = ReadEmpire (PRINT);
		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (ptr);
			if (StrEQ (ptr, "Target sector"))
			{
				if (launched)
				{
					FeedEmpire ("aborted", PRINT);
					(void) WaitForPrompt (PRINT);
					Message ("Error, no launch done");
					Bell ();
					return;
				}
				FeedEmpire (CrdStr (sct), PRINT);
				launched = True;
				continue;
			}

			ans = InputAtMessage (ptr, 10, GS_TEXT);
			if (ans == (char *) 0 || interrupt)
			{
				Message ("Aborting launch");
				while (EmpireStatus () != E_COMMAND)
				{
					FeedEmpire ("aborted", PRINT);
					ptr = WaitForPrompt (PRINT);
				}
				PrintAtEmpire (ptr);
				Message ("Launch aborted");
				return;
			}

			FeedEmpire (ans, PRINT);
			continue;
		}
		else if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			if (launched)
			{
				Message ("Launch done");
				return;
			}
			else
			{
				Message ("Launch failed!");
				Bell ();
				return;
			}
		}
		else if (EmpireStatus () == E_PRINTING)
		{
			if (StrEQ (ptr, "KABOOOOM"))
			{
				Message ("Damned, launch failed !");
				Bell ();
				(void) WaitForPrompt (PRINT);
				DeletePlane (plane);
				return;
			}

			ptri = index (ptr, ',');
			if (ptri == (char *) 0)
				continue;
			
			while (ptri >= ptr && * ptri != 'o')
				ptri --;

			if (ptri == ptr)
				continue;

			if (sscanf (ptri, "over %d , %d", & x, & y) == 2)
			{
				set_pl_launc (plane);
				des = World (x, y, S_DESIG);
				MovePlaneTo (plane, des);
			}
		}
	}
}

void DoLaunch (plane)
Plane plane;
{
	if (pl_launc (plane))
	{
		Message ("Already launched !");
		Bell ();
		return;
	}

	if (PlaneHas (plane, P_M))
		LaunchMissile (plane);
	else if (PlaneHas (plane, P_O))
		LaunchSatellite (plane);
	Census ();
}

void DoLaunchWing ( wing )
char *wing;
{
	LaunchWing (wing);
	Census ();
}
