/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/misc/RCS/scan.c,v 5.7 1995/10/12 07:22:02 jpo Exp $
    $Date: 1995/10/12 07:22:02 $
    $Author: jpo $
    $Id: scan.c,v 5.7 1995/10/12 07:22:02 jpo Exp $
    $Locker:  $
    $Log: scan.c,v $
    Revision 5.7  1995/10/12 07:22:02  jpo
    Use regexps

    Revision 5.6  1995/10/10 07:25:29  jpo
    Added regex matching
    sorted out some compatibility stuff

    Revision 5.5  1995/09/29 07:56:33  jpo
    Better handling of ship reports.

    Revision 5.4  1995/09/27 13:20:43  jpo
    Patricks fixes for satellite scanning
    plus my fixes for errors in nation scanning

    Revision 5.3  1995/09/14 20:02:38  jpo
    Fix up scanning detecting illegal stuff

    Revision 5.2  1995/09/08 07:31:37  jpo
    const - mostly

 * Revision 5.1  93/03/14  16:49:41  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/*
	 *	Emptool				<file: scan.c>
	 *	
	 *	Written by HJ. Visscher.
	 *
	 *	ScanDump ()
	 *		Scans the output of "dump" that empire is printing
	 *
	 *	ScanNation ()
	 *		Scans the output of "nation" that empire is printing
	 *
	 *	ScanMap ()
	 *		Scans the output of "map" that empire is printing
	 */

#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "version.h"
#include "ship.h"
#include "regex.h"

static void ScanSatellite _PROTO((void));
static double ScanFloat _PROTO((char *ptr));
static bool AddSatelliteShip _PROTO((char *line, int sector));
static bool AddSatelliteLand _PROTO((char *line, int sector));

char *DelControl (s)
     char *s;
{
	register char *ptr;
	register char *bptr;
	static char buffer [BUFSIZ];

	bptr = buffer;
	ptr = s;

	while (*ptr != '\0')
	{
		*ptr &= 0x7F;
		if (*ptr < ' ')
		{
			*bptr++ = '^';
			*bptr++ = *ptr++ - ' ' + 'A';
		}
		else
			*bptr++ = *ptr++;
	}

	*bptr = '\0';

	return buffer;
}

char *DelTabs (s)
     char *s;
{
	int i;
	register char *ptr;
	register char *bptr;
	static char buffer [BUFSIZ];

	if (s == (char *) 0 || *s == '\0')
		return s;

	i = 0;
	ptr = s;
	bptr = buffer;

	while (*ptr != '\0')
		if (*ptr == '\t')
		{
			do
			{
				* (bptr ++)  = ' ';
				i ++;
			} while ((i % 8) != 0);
			ptr ++;
		}
		else
		{
			* (bptr ++) = * (ptr ++);
			i ++;
		}

	*bptr = '\0';

	return buffer;
}

char * DelNewline (str)
     char *str;
{
	char *p;

	if ((p = strchr (str, '\n')) != (char *) 0)
		*p = '\0';
	
	return str;
}

void SkipPtr (pptr, toskip)
ConstVP pptr;
const char *toskip;
{
	if (*toskip == '^')
		while ((strchr (toskip + 1, **pptr) == (char *) 0) &&
							 **pptr != '\0')
			(*pptr) ++;
	else
		while ((strchr (toskip, **pptr) != (char *) 0) &&
							**pptr != '\0')
			(*pptr) ++;
}

void SkipBlank (pptr)
ConstVP pptr;
{
	SkipPtr (pptr, " \t");
}

bool ScanWordQuot (pptr, word)
ConstVP pptr;
char *word;
{
	char buffer [BUFSIZ];
	char *ptr;
	bool quot = False;

	ptr = (word == (char *) 0) ? buffer : word;
	SkipBlank (pptr);

	if (**pptr == '\0')
		return False;

	while (**pptr != '\0' && ((**pptr != ' ' && **pptr != '\t') || quot))
	{
		if (**pptr == '\\')
		{
			if (*++(*pptr) == '\0')
				return False;
			*ptr++ = **pptr;
		}
		else if (**pptr == '"')
			quot = ! quot;
		else
			*ptr++ = **pptr;
		(*pptr) ++;
	}

	*ptr = '\0';
	return ! quot;
}

bool ScanWord (pptr, word)
ConstVP pptr;
char *word;
{
	char buffer [BUFSIZ];
	char *ptr;

	ptr = (word == (char *) 0) ? buffer : word;
	SkipBlank (pptr);

	if (**pptr == '\0')
		return False;

	while (**pptr != '\0' && **pptr != ' ' && **pptr != '\t')
	{
		*ptr = **pptr;
		ptr ++;
		(*pptr) ++;
	}

	*ptr = '\0';
	return True;
}

bool ScanFmt (pptr, word, fmt)
const char ** pptr;
char * word;
const char * fmt;
{
	char buffer [BUFSIZ];
	char * ptr;

	ptr = (word == (char *) 0) ? buffer : word;
	SkipBlank (pptr);
	while (CharInFormat (** pptr, fmt))
	{
		* ptr = ** pptr;
		ptr ++;
		(* pptr) ++;
	}

	* ptr = '\0';
	return True;
}

bool ScanDigit (pptr, num)
ConstVP pptr;
int *num;
{
	int negated = 0;
	register int value = 0;

	SkipBlank (pptr);

	if (**pptr == '-')
	{
		negated = 1;
		(*pptr) ++;
	}
	else if (**pptr == '+')
		(*pptr) ++;

	if (**pptr < '0' || **pptr > '9')
		return False;

	while (**pptr >= '0' && **pptr <= '9') 
	{

		value = 10 * value + **pptr - '0';
		(*pptr) ++;
	}

	*num =  negated ? -value : value;

	return True;
}

static double ScanFloat (ptr)
     char *ptr;
{
	double p;

	(void) sscanf (ptr, "%lf", &p);
	return p;
}

int safe_civ, safe_uw;
double happy_req;

void FScanNation ()
{
	char *ptr, *ind;
	char word[100];
	int num, i;
	int norealms;
	extern int capitol_x, capitol_y;

/*	if(!EMPOption(REALM_IN_NAT)) {  */
	if(chainsaw_version) { 
       		FeedEmpire ("realm", PRINT);
        	MessageAtEmpire ("scanning realm");
                /* scan realms */
        	i = 0;
        	for (;;)
        	{
                	ptr = ReadEmpire (DONT_PRINT);
                	if (ptr == (char *) 0) continue;
                	if (* ptr != 'R')
                        	break;

                	if(sscanf(ptr, "Realm #%*d is %s", nation->realm [i++]) != 1) {
                       		Error ("Illegal realm, try with less realms");
                	}
        	}
        	nr_realms = i;
	}

	FeedEmpire ("", PRINT);
	(void) WaitForPrompt (PRINT);
	FeedEmpire ("nation", PRINT);
	MessageAtEmpire ("scanning nation");

	(void) SkipNLines (1, DONT_PRINT);
	ptr = ReadEmpire (DONT_PRINT);
	if (ptr == NULL) return;
	if (sscanf (ptr, "(#%d)", &i) == 1) /* new version */
		my_cnum = i;
	(void) SkipNLines (1, DONT_PRINT);
	ind = ptr = ReadEmpire (DONT_PRINT);
	if (ptr == (char *) 0) return;
	capitol_x = 123456;
	if (strncmp (ind, "No capit", 8) == 0)
		capitol_x = capitol_y = 0;
	else {
		while (ScanWord ((ConstVP)&ptr, word)) { /* search for word at */
			if (strcmp (word, "at") == 0) {
				if (sscanf (ptr, "%d,%d",
					    &capitol_x, &capitol_y) != 2)
					break;
			}
		}
	}
	if (capitol_x == 123456)
		Error ("Bad Nation output");
		
	norealms = 0;
	if(chainsaw_version) {
		ptr = ReadEmpire (DONT_PRINT);
		if (ptr == (char *) 0) return;
		if (index (ptr, '$'))
			norealms = 1;
	}

	if(norealms == 0 && (ksu_version || EMPOption(REALM_IN_NAT))) {
                /* scan realms */
	        i = 0;
        	for (;;)
        	{
                	ptr = ReadEmpire (DONT_PRINT);
                	if (ptr == (char *) 0) return;
                	if (* ptr != '#')
                        	break;
			if (!EMPOption(REALM_IN_NAT)) {
                		if (sscanf (ptr, "# %*d %s # %*d %s # %*d %s",
					nation-> realm [i],
					nation-> realm [i + 1],
					nation-> realm [i + 2]) != 3) {
					Error ("Illegal realm, try with less realms");
                		}
			} else {
/*				if (sscanf (ptr, "#%*d %s #%*d %s #%*d %s",
					nation-> realm [i],
					nation-> realm [i + 1],
					nation-> realm [i + 2]) != 3) {
					Error ("Illegal realm, try with less realms");
                        	} */
			}
                	i += 3;
        	}
        	nr_realms = i;
	}

	if ((ind = index (ptr, '$')) == NULL) {
		Error ("Bad nation output");
		WaitForPrompt (PRINT);
		return;
	}
	n_treas (nation) = ScanFloat (ind + 1);

	ind = index (ptr, ':') + 1;

	if (!ScanDigit ((ConstVP)&ind, &num))
		Error ("Bad nation output");

	n_mil_res(nation) = (long) num;

	if(other_version) {
		ptr = ReadEmpire (DONT_PRINT);
		ptr = ReadEmpire (DONT_PRINT);
	} 

	ptr = ReadEmpire (DONT_PRINT);
	if (ptr == (char *) 0) return;
	n_educ (nation) = ScanFloat (ptr + 19);
	if ((ptr = strchr (ptr, 'H')) != (char *) 0)
		n_hap (nation) = ScanFloat (ptr + 16);

	ptr = ReadEmpire (DONT_PRINT);
	if (ptr == (char *) 0) return;
	n_tech (nation) = ScanFloat (ptr + 19);
	if ((ptr = strchr (ptr, 'R')) != (char *) 0)
		n_research (nation) = ScanFloat (ptr + 16);

	ptr = ReadEmpire (DONT_PRINT);
	if (ptr == (char *) 0) return;
	if (ind = index (ptr, ':')) {
		ind ++;
		n_tech_fact (nation) = ScanFloat (ind);
		if (ind = index (ind, ':')) {
			ind ++;
			n_plag_fact (nation) = ScanFloat (ind + 1);
		}
	}
	if (land_units) {
		ptr = ptr + 20;
		ind = index (ptr, ':') + 1;
		if (!ScanDigit ((ConstVP)&ind, &max_civ_uw))
			max_civ_uw = 999;
	}

	if (land_units) {
		(void) SkipNLines (1, DONT_PRINT);
		ptr = ReadEmpire (DONT_PRINT);
		ind = index(ptr, ':') + 1;
		if (!ScanDigit ((ConstVP)&ind, &max_civ_uw))
			max_civ_uw = 999;

		ptr =  ReadEmpire (DONT_PRINT);
		ind = index(ptr, ':') + 1;
		if (!ScanDigit ((ConstVP)&ind, &safe_civ))
			safe_civ = max_civ_uw;

		ind = index(ind, '/') + 1;
		if (!ScanDigit ((ConstVP)&ind, &safe_uw))
			safe_uw = safe_civ;

	} else {
		max_civ_uw = 999;
	}
	ptr = ReadEmpire (PRINT);
	if ((ind = StrStr (ptr, "Happiness needed is")) != NULL) {
		ind += strlen ("Happiness needed is");
		happy_req = ScanFloat (ind);
	}
	(void) WaitForPrompt (PRINT);
}

	/*
	 *	ScanDump returns the # of sectors read
	 */

int FScanDump (part, flag)
const char *part;
int flag;
{
	int nr_s;

	FeedEmpire (Fmt ("dump %s", part), flag);
	nr_s = ScanDump (flag);
	(void) WaitForPrompt (flag);

	return nr_s;
}

int ScanDump (flag)
int flag;
{
	register Sector sct;
	char *ptr, *line, des;
	int lx, ly;
	int owner;
	int sectors_read;
	bool err;

#ifndef lint
	int nr; 
	int off;
	int eff, mob, min, gol, fer, oil, ura, wor, ter;
	char dist_path [20];
	int u_cut, f_cut, s_cut, g_cut, p_cut, i_cut,
	      d_cut, b_cut, o_cut, l_cut, h_cut, r_cut;
	char  u_del, f_del, s_del, g_del, p_del, i_del,
	      d_del, b_del, o_del, l_del, h_del, r_del;
	int deltox, deltoy;
#endif lint


	if (flag == PRINT)
		MessageAtEmpire ("scanning dump");

	sectors_read = 0;

	(void) SkipNLines (1, DONT_PRINT);

	if (EmpireStatus () != E_PRINTING)
		return 0;

	ptr = ReadEmpire (DONT_PRINT);
	if (ptr == (char *) 0) return 0;

	SkipBlank ((ConstVP)&ptr);
	if (strncmp (ptr, "DUMP", 4))
		/* no sector to scan */
		return 0;


	ptr = ReadEmpire (DONT_PRINT);
	if (ptr == (char *) 0) return 0;

	deity = (*ptr == 'o');

	for (;;)
	{
		line = ptr = ReadEmpire (DONT_PRINT);

		if (ptr == (char *) 0 || *ptr == '\0')
			break;

		if (deity)
			if (!ScanDigit ((ConstVP)&ptr, &owner))
			{
				PrintAtEmpire (
				"Warning: Expected country num in dump");
				PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
				Bell ();
				(void) EmpireMore ();
				continue;
			}

		err = ! ScanDigit ((ConstVP)&ptr, &lx);
		err = err || ! ScanDigit ((ConstVP)&ptr, &ly);

		if (err)
		{
			if (strncmp (ptr, "sector", 6) == 0)
				/* End of Dump */
				break;
			PrintAtEmpire ("Warning: Expected coordinats in dump");
			PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
			Bell ();
			(void) EmpireMore ();
			continue;
		}
			

		sct = World (lx, ly, S_OWNED);

		if (deity)
			set_owner (sct, owner);
		else
			set_owner (sct, my_cnum);

		SkipBlank ((ConstVP)&ptr);
		des = *ptr;

/* 
 *		Why? HJV
 *
 * 		if (! UpdateSectorDes (sct, des, True))
 * 		{
 * 			PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
 * 			(void) EmpireMore ();
 * 			continue;
 * 		}
 */

		sectors_read ++;
		set_des (sct, des);

		/*
		 * lint complains & quits: 
		 *
		 * pass 2 error:(file scan.c) more than 67 args?
		 *
		 */
#ifndef lint
	/*
	 *	You should NOT do it this way, but I'm afraid it
	 *	takes too long when you read it in dummy vars
	 */

/* out of date ET 
 * nds eff mob occ min gol fer
 * oil ura wor ava ter civ mil d(uw) d(foo) d(she) d(gun)
 * d(pet) d(iro) d(dus) d(bar) d(oil) d(lcm) d(hcm) d(rad) udel fdel sdel gdel
 * pdel idel ddel bdel odel ldel hdel rdel ucut fcut dcut gcut pcut
 * icut dcut bcut ocut lcut hcut rcut dpath dxc dyc tuw
 * tfoo tshe tgun tpet tiro tdus tbar toil tlcm thcm trad 
 */

	    if(land_units) {
		 nr = sscanf (ptr + 2, " %c %hd %d %c %d %d %d %d \
		      %d %d %d %hd %d %hd %hd %hd %hd %hd %hd \
		      %hd %hd %hd %hd %hd %hd %hd %hd %c %c %c %c \
		      %c %c %c %c %c %c %c %c %d %d %d %d %d \
		      %d %d %d %d %d %d %d %d %d %hd \
		      %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd",
				& sct-> sct2-> sct3-> nds,
				& sct-> sct2-> eff,
				& mob,
				& sct-> sct2-> sct3-> occ,
				& off,
				& min, & gol, & fer, & oil, & ura, & wor,
				& sct-> sct2-> sct3-> ava,
				& ter,
				& sct-> sct2-> civ,
				& sct-> sct2-> mil,
				& sct-> sct2-> qua [D_UW],
				& sct-> sct2-> qua [D_FOO],
				& sct-> sct2-> qua [D_SHE],
				& sct-> sct2-> qua [D_GUN],
				& sct-> sct2-> qua [D_PET],
				& sct-> sct2-> qua [D_IRO],
				& sct-> sct2-> qua [D_DUS],
				& sct-> sct2-> qua [D_BAR],
				& sct-> sct2-> qua [D_OIL],
				& sct-> sct2-> qua [D_LCM],
				& sct-> sct2-> qua [D_HCM],
				& sct-> sct2-> qua [D_RAD],
				& u_del, & f_del, & s_del, & g_del, & p_del,
				& i_del, & d_del, & b_del, & o_del, & l_del,
				& h_del, & r_del, & u_cut, & f_cut, & s_cut,
				& g_cut, & p_cut, & i_cut, & d_cut, & b_cut,
				& o_cut, & l_cut, & h_cut, & r_cut,
				& deltox, & deltoy,
				& sct-> sct2-> sct3-> tre [D_CIV],
				& sct-> sct2-> sct3-> tre [D_MIL],
				& sct-> sct2-> sct3-> tre [D_UW],
				& sct-> sct2-> sct3-> tre [D_FOO],
				& sct-> sct2-> sct3-> tre [D_SHE],
				& sct-> sct2-> sct3-> tre [D_GUN],
				& sct-> sct2-> sct3-> tre [D_PET],
				& sct-> sct2-> sct3-> tre [D_IRO],
				& sct-> sct2-> sct3-> tre [D_DUS],
				& sct-> sct2-> sct3-> tre [D_BAR],
				& sct-> sct2-> sct3-> tre [D_OIL],
				& sct-> sct2-> sct3-> tre [D_LCM],
				& sct-> sct2-> sct3-> tre [D_HCM],
				& sct-> sct2-> sct3-> tre [D_RAD]);

			if (nr != 67)
			{
				PrintAtEmpire ("Bad dump Format");
				PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
				Bell ();
				(void) EmpireMore ();
			}
		} else {
		 nr = sscanf (ptr + 2, " %c %hd %d %c %d %d %d \
		      %d %d %d %hd %d %hd %hd %hd %hd %hd %hd \
		      %hd %hd %hd %hd %hd %hd %hd %hd %c %c %c %c \
		      %c %c %c %c %c %c %c %c %d %d %d %d %d \
		      %d %d %d %d %d %d %d %s %d %d %hd \
		      %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd",
				& sct-> sct2-> sct3-> nds,
				& sct-> sct2-> eff,
				& mob,
				& sct-> sct2-> sct3-> occ,
				& min, & gol, & fer, & oil, & ura, & wor,
				& sct-> sct2-> sct3-> ava,
				& ter,
				& sct-> sct2-> civ,
				& sct-> sct2-> mil,
				& sct-> sct2-> qua [D_UW],
				& sct-> sct2-> qua [D_FOO],
				& sct-> sct2-> qua [D_SHE],
				& sct-> sct2-> qua [D_GUN],
				& sct-> sct2-> qua [D_PET],
				& sct-> sct2-> qua [D_IRO],
				& sct-> sct2-> qua [D_DUS],
				& sct-> sct2-> qua [D_BAR],
				& sct-> sct2-> qua [D_OIL],
				& sct-> sct2-> qua [D_LCM],
				& sct-> sct2-> qua [D_HCM],
				& sct-> sct2-> qua [D_RAD],
				& u_del, & f_del, & s_del, & g_del, & p_del,
				& i_del, & d_del, & b_del, & o_del, & l_del,
				& h_del, & r_del, & u_cut, & f_cut, & s_cut,
				& g_cut, & p_cut, & i_cut, & d_cut, & b_cut,
				& o_cut, & l_cut, & h_cut, & r_cut, dist_path,
				& deltox, & deltoy,
				& sct-> sct2-> sct3-> tre [D_UW],
				& sct-> sct2-> sct3-> tre [D_FOO],
				& sct-> sct2-> sct3-> tre [D_SHE],
				& sct-> sct2-> sct3-> tre [D_GUN],
				& sct-> sct2-> sct3-> tre [D_PET],
				& sct-> sct2-> sct3-> tre [D_IRO],
				& sct-> sct2-> sct3-> tre [D_DUS],
				& sct-> sct2-> sct3-> tre [D_BAR],
				& sct-> sct2-> sct3-> tre [D_OIL],
				& sct-> sct2-> sct3-> tre [D_LCM],
				& sct-> sct2-> sct3-> tre [D_HCM],
				& sct-> sct2-> sct3-> tre [D_RAD]);

			if (nr != 65)
			{
				PrintAtEmpire ("Bad dump Format");
				PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
				Bell ();
				(void) EmpireMore ();
			}
		}
	
		set_mob (sct, mob);
		if (land_units)
			set_off (sct, off);
		set_min (sct, min);
		set_gol (sct, gol);
		set_fer (sct, fer);
		set_oil (sct, oil);
		set_ura (sct, ura);
		set_ter (sct, ter);
		set_wor (sct, wor);

		set_dc_uw  (sct, u_del, u_cut);
		set_dc_foo (sct, f_del, f_cut);
		set_dc_she (sct, s_del, s_cut);
		set_dc_gun (sct, g_del, g_cut);
		set_dc_pet (sct, p_del, p_cut);
		set_dc_iro (sct, i_del, i_cut);
		set_dc_dus (sct, d_del, d_cut);
		set_dc_bar (sct, b_del, b_cut);
		set_dc_oil (sct, o_del, o_cut);
		set_dc_lcm (sct, l_del, l_cut);
		set_dc_hcm (sct, h_del, h_cut);
		set_dc_rad (sct, r_del, r_cut);

		set_dxc (sct, EX (deltox));
		set_dyc (sct, EX (deltoy));

		if (land_units == 0 && * dist_path != '_')
		    SetDistPath (sct, dist_path);
			
		if (s_nds (sct) == '_')
			s_nds (sct) = s_des (sct);

		DEL_INFO (sct);
		SET_INFO_ALL (sct);
#endif lint
	}

	return sectors_read;
}

void FScanMap (part, flag)
const char *part;
int flag;
{
	FeedEmpire (Fmt ("map %s", part), flag);
	ScanMap (flag);
	(void) WaitForPrompt (flag);
}

void FScanBmap (part, flag)
const char *part;
int flag;
{
	FeedEmpire (Fmt ("bmap %s", part), flag);
	ScanMap (flag);
	(void) WaitForPrompt (flag);
}

void ScanMap (flag)
     int flag;
{
	register char *line;
	char *ptri;
	int first, second, len;
	char first1, first2, second1, second2;
	int xcoord, ycoord, length;
	bool first_line;
	register int i;
	register Sector sct;

	if (flag == PRINT)
		MessageAtEmpire ("scanning map");

	line = ptri = ReadEmpire (DONT_PRINT);
	if (line == (char *) 0) return;
	if (EmpireStatus () == E_COMMAND) {
		if (flag == PRINT)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
		}
		Message ("map command failed");
		Bell ();
		return;
	}

	len = strlen (line);

	SkipBlank ((ConstVP)&ptri);

	second1 = second2 = '\0';
	first = second = 0;

	first1 = *ptri++;
	length = 1;

	if (*ptri != '\0' && *ptri != '\n')
	{
		second1 = *ptri++;
		length++;
	}

	while (*ptri != '\0' && *ptri != '\n')
	{
		ptri ++;
		length ++;
	}

	line = ptri = ReadEmpire (DONT_PRINT);
	if (line == (char *) 0) return;
	if (EmpireStatus () == E_COMMAND) {
		if (flag == PRINT)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
		}
		Message ("map command failed");
		Bell ();
		return;
	}

	SkipBlank ((ConstVP)&ptri);
	first2 = *ptri++;

	if (*ptri != '\0' && *ptri != '\n')
		second2 = *ptri;

	if (first1 == '-')
		first = '0' - first2;
	else
	{
		first = 10 * (first1 - '0') + (first2 - '0');
		
		if (second1 != '\0')
		{
			if (second1 == '-')
				second = '0' - second2;
			else 
				second = 10 * (second1 - '0') + (second2 - '0');

			if (first > second)
				first = -first;
		}
	}

	first_line = True;
	for (;;)
	{
		ptri = line = ReadEmpire (DONT_PRINT);

		if (line == (char *) 0)
			return;

		if (EmpireStatus () != E_PRINTING)
		{
			if (flag == PRINT)
			{
				PrintAtEmpire ("");
				PrintAtEmpire (line);
			}
			return;
		}
			/* the hunderds */

		if (first_line)
		{
			char *ptr;

			first_line = False;
			ptr = ptri + 5;
			if (* ptr >= '0' && * ptr <= '9')
			{
				if (first < 0) {
					first = 10 * first + ('0' - * ptr);
					continue;
				}
				first = 10 * first + (* ptr - '0');
				if (second < 0 || second1 == '\0')
					continue;

				if (*++ptr != '\0' && *ptr != '\n') {
					second = 10 * second + (* ptr - '0');

					if (first > second)
						first = -first;
				}
				continue;
			}
		}

		if (line [3] == ' ' || strlen (line) < len)
			continue;

		if (! ScanDigit ((ConstVP)&ptri, &ycoord))
		{
			PrintAtEmpire ("Map : Coordinate expected in map");
			PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
			Bell ();
			(void) EmpireMore ();
			continue;
		}

		for (i = ABS (ycoord + first) % 2; i < length; i += 2)
			if (line [5 + i]  != ' ')
			{
				xcoord = first + i;
				sct = World (xcoord, ycoord, S_DESIG);

				if (!UpdateSectorDes (sct, line [5 + i], True))
				{
					PrintAtEmpire (Fmt (
						"Map : Skipping \"%s\"", line));
					Bell ();
					(void) EmpireMore ();
					break;
				}
			}
	}
}

void FScanRadar (rad)
const char *rad;
{
	FeedEmpire (Fmt ("radar %s", rad), PRINT);
	ScanRadar ();
	(void) WaitForPrompt (PRINT);
}

void FScanLRadar (rad)
const char *rad;
{
	FeedEmpire (Fmt ("lradar %s", rad), PRINT);
	ScanRadar ();
	(void) WaitForPrompt (PRINT);
}

void FeedSatellite ()
{
	FeedEmpire (Fmt ("satellite %s", "*"), PRINT);
	scanning_satellites=True;
	ScanSatellite ();
	scanning_satellites=False;
	(void) WaitForPrompt (PRINT);
}

void ScanRadar ()
{
	int x, y, d, sx, sy;
	char *line, *ptri;
	char des;
	Sector sct;
	char tbuf[3];
	regmatch_t rmatch[10];

	if (EmpireStatus () == E_COMMAND)
		return;

	MessageAtEmpire ("scanning radar(s)");

	for (;;)
	{
		if (EmpireStatus () == E_PRINTING)
		{
			line = ReadEmpire (DONT_PRINT);
			if (line == (char *) 0) return;
		}

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}

		if (sscanf (line, "%d,%d efficiency %*d%%, max range %d",
			&sx, &sy, &d) != 3) 
		{
		   
			if ((ptri = index (line, '#')) == (char *) 0)
			{
				PrintAtEmpire (Fmt (
			    "ScanRadar: new kind of radar ?\n\"%s\"\n",
						    line));
				Bell ();
				(void) EmpireMore ();
				continue;
			}

			if (match_str (ptri,
				       "#\\d+\\)? at (-?\\d+),(-?\\d+) efficiency \\d+%, max range (\\d+)",
				       rmatch, 10) == 0) {
				sx = atoi(ptri + rmatch[1].rm_so);
				sy = atoi(ptri + rmatch[2].rm_so);
				d = atoi(ptri + rmatch[3].rm_so);
			}			    
			else {
/* pre RE days
			if (sscanf (ptri,
				    "#%*d at %d,%d efficiency %*d%%, max range %d",
				    &sx, &sy, &d) != 3 &&
			    sscanf (ptri,
				    "#%*d) at %d,%d efficiency %*d%%, max range %d",
				    &sx, &sy, &d) != 3)
			{
*/
				PrintAtEmpire (Fmt (
					   "ScanRadar: nothing? ??\n\"%s\"\n",
						    line));
				Bell ();
				(void) EmpireMore ();
				continue;
			}
			sct = World (sx, sy, S_DESIG);
			(void) UpdateSectorDes (sct, '.', False);
		}

		if (d == 0)
		{
			(void) SkipNLines (2, DONT_PRINT);
			continue;
		}

		for (y = sy - d; y <= sy + d; y++)
		{
			ptri = line = ReadEmpire (DONT_PRINT);
			if (line == (char *) 0) return;

			for (x = sx - 2*d; x < (sx + 2*d); ptri++, x++)
			{
				if (*ptri == '\0')
				{
		  PrintAtEmpire (Fmt (" Trying to scan 0 (%d, %d) %d\"%s\"\n",
				      x, y, d, line));
					Bell ();
					(void) EmpireMore ();
					break;
				}
				if ((x + y) % 2 != 0)
					continue;

				des = *ptri;

				if (des == ' ' || des == '0')
					continue;

				sct = World (x, y, S_DESIG);
				if (des >= 'A' && des <= 'Z')
				{
					if (!ShipAtSect (sct, des))
					{
						PrintAtEmpire (
  	Fmt ( "Warning Enemy ship (%c) at %s detected with no further info",
	     des, CrdStr (sct)));
/*			  tbuf[0] = des; tbuf[1] = 0;
			  AddEnemyShip (x, y, 0, 0, tbuf); */
#ifdef MORE_ON_ENEMY_SHIPS
						Bell ();
						(void) EmpireMore ();
#endif
					}
					
					(void) UpdateSectorDes (sct, '.', False);
				}
				else if (des == '$') {

					PrintAtEmpire (Fmt
						       ("Satellite detected at %s", CrdStr (sct)));
					(void) UpdateSectorDes (sct, '.', False);
#ifdef MORE_ON_SATELLITES
					Bell ();
					(void) EmpireMore ();
#endif
				}
				else if (!UpdateSectorDes (sct, des, True))
				{
					PrintAtEmpire (
						       Fmt ("Skipping \"%s\"", line));
					Bell ();
					(void) EmpireMore ();
				}
			
			}
		}
		line = ReadEmpire (DONT_PRINT);

		if (line == (char *) 0)
			return;
	}
}

void FScanLookout (where)
const char *where;
{
	FeedEmpire (Fmt ("lookout %s", where), PRINT);
	ScanLookout ();
	(void) WaitForPrompt (PRINT);
}

void FScanCoastWatch (where)
const char *where;
{
	FeedEmpire (Fmt ("coastwatch %s", where), PRINT);
	if (! SkipNLines (2, PRINT))
		return;
	ScanLookout ();
	(void) WaitForPrompt (PRINT);
}

void FScanLLookout (where)
const char *where;
{
	FeedEmpire (Fmt ("llook %s", where), PRINT);
	ScanLookout ();
	(void) WaitForPrompt (PRINT);
}

void ScanLookout ()
{

	char *line, *ptri, *tmpptr, savechar, *name;
	int owner, num, x, y, last_ship = -1;
	char des;
	Sector sct;
	bool err, showit, found;
	time_t tt, time ();
	regmatch_t rmatch[10];

	MessageAtEmpire ("scanning lookout");

	tt = time ((time_t *) 0);
	for (;;)
	{
		ptri = line = ReadEmpire (DONT_PRINT);
		if (line == (char *) 0) return;

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}
		if (StrStr (line, "Legal directions are") != NULL) {
			while (EmpireStatus () == E_PRINTING)
				line = ReadEmpire (DONT_PRINT);
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}

		SkipBlank ((ConstVP)&ptri);

		if (*ptri == '\n' || *ptri == '\0') continue;

		if (!strncmp (ptri, "Your ", 5))
			/* It's one of my own sectors, just skip it */
			continue;
		
		name = ptri;
		ptri = index (ptri, '(');
		if (ptri == (char *) 0)
		{
			Ship ship;
			if (last_ship == -1) {
				PrintAtEmpire ("Scan L/S/C : no country");
				PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
				Bell ();
				(void) EmpireMore ();
				continue;
			}
			ptri = name;
			SkipBlank ((ConstVP)&ptri);
			if ((ship = NrToShip (last_ship)) != NULL)
				set_sh_name (ship, ptri);
			continue;
		}
		tmpptr = ptri;

		ptri ++;
		if (*ptri == '#')
		    ptri ++;
		if (! ScanDigit ((ConstVP)&ptri, &owner))
		{
			PrintAtEmpire ("Scan L/S/C : Bad country format");
			PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
			Bell ();
			(void) EmpireMore ();
			continue;
		}

		do
			tmpptr--;
		while (isspace (*tmpptr));

		savechar = * ++tmpptr;
		* tmpptr = '\0';

		AddCountry (owner, name);

		* tmpptr = savechar;


		if (*ptri != ')')
			ptri = index (ptri, ')');

		if (ptri == (char *) 0 && !chainsaw_version)
		{
			PrintAtEmpire ("Scan L/S/C : Bad country format");
			PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
			Bell ();
			(void) EmpireMore ();
			continue;
		}
		ptri++; /* skip ')' */

		SkipBlank ((ConstVP)&ptri);

		tmpptr = index (ptri, '#');

		if (tmpptr == (char *) 0)
		{
			/* it's a sector */
			int eff, civ, mil;

			des = CharOfDesigName (ptri);
			if (des == '\0')
			{
				PrintAtEmpire (
				"Scan L/S/C : Unknown Designation ?");
				PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
				Bell ();
				(void) EmpireMore ();
				continue;
			}
			ptri += strlen  (DesignName (des));
			err = ! ScanDigit ((ConstVP)&ptri, &eff) ||
			    *ptri != '%';
			ptri++; /* Skip '%' */

			SkipBlank ((ConstVP)&ptri);

			if (err || (strncmp (ptri, "efficient", 9) != 0))
			{
				PrintAtEmpire ("Scan L/S/C : Bad eff Format");
				PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
				Bell ();
				(void) EmpireMore ();
				continue;
			}
			ptri += 9;

			SkipBlank ((ConstVP)&ptri);

			civ = 0;
			mil = 0;
			for (;;)
			{
				if (strncmp (ptri, "with approx", 11) == 0)
				{
					ptri += 12;
					err = ! ScanDigit ((ConstVP)&ptri,
							   &num);
					ptri++;
					if (!err && *ptri == 'c')
						civ = num == 0 ? 1 : num;
					else if (!err && *ptri == 'm')
						mil = num == 0 ? 1 : num;
					else
					{
						PrintAtEmpire (
					"Scan L/S/C : Bad Lookout format");
						PrintAtEmpire (
					Fmt ("Skipping \"%s\"", line));
						Bell ();
						(void) EmpireMore ();
						break;
					}
					ptri += 4;
				}
				else
					break;
			}

			SkipBlank ((ConstVP)&ptri);
			if  (*ptri != '@' ||
			     sscanf (ptri, "@ %d,%d", &x, &y) != 2)
			{
				PrintAtEmpire (
					"Scan L/S/C : Unknown @ format ?");
				PrintAtEmpire (Fmt ( "Skipping \"%s\"", line));
				Bell ();
				(void) EmpireMore ();
				continue;
			}

			sct = World (x, y, S_RESOU);

			if (s_time (sct) == tt)
				/* Already got it */
				continue;

			if (s_owned (sct))
			{
				/* Must have been captured */

				PrintAtEmpireMode (
				     Fmt ("Your sector at %s has been captured",
				     CrdStr (sct)), BOLD);
				Bell ();
				DEL_INFO (sct);
				SET_INFO_RES (sct); /* save resources */
				set_owner (sct, UNKNOWN_CNUM);
			}
			/* This is most uptodate info overwrite anythin else */
			set_des (sct, des);
			set_owner (sct, owner);
			set_eff (sct, eff);
			set_civ (sct, civ);
			set_mil (sct, mil);
			set_time (sct, tt);
			SET_INFO_LOO (sct);
			PrintAtEmpire (line);
		}
		else
		{
			/* it's a ship, plane or unit (in chain 3.0) */
			/* #10) @ -2,2 or #10 @ -2,2 */
			if (match_str (tmpptr,
				       "#(\\d+)\\)?\\s+@\\s*(-?\\d+),(-?\\d+)",
				       rmatch, 10) == 0) {
				num = atoi (tmpptr + rmatch[1].rm_so);
				x = atoi(tmpptr + rmatch[2].rm_so);
				y = atoi(tmpptr + rmatch[3].rm_so);
			}
			else {
				PrintAtEmpire (
					"Scan L/S/C : Unknown ship/plane/unit format ?");
				PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
				Bell ();
				(void) EmpireMore ();
				continue;
			}

			do
				tmpptr--;
			while (*tmpptr == '(' || isspace (*tmpptr));

			savechar = * ++tmpptr;
			* tmpptr = '\0'; /* leave's in ptri name */
			last_ship = -1;
			if (!land_units) {
				if (AddEnemyShip (x, y, num, owner, ptri))
				{
					* tmpptr = savechar;
					PrintAtEmpire (line);
				}
				/* else ship already on list and at same loc.
			 	* don't tell player what he already knows
			 	*/
			} else {
				showit = found = False;
				/* find out, what we have seen */

				if (FindShipTypeByName (ptri, False) != -1) {
					showit = AddEnemyShip (x, y, num, owner, ptri);
					last_ship = num;
					found = True;
				}

				if (FindLandTypeByName (ptri, False) != -1) {
					showit = AddEnemyLand (x, y, num, owner, ptri, False, False);
					found = True;
				}

				if (FindPlaneTypeByName (ptri, False) != -1) {
					showit = AddEnemyPlane (x, y, num, owner, ptri);
					found = True;
				}

				if (!found) { /* assume its a ship? */
					Sector s;

					s = World (x, y, S_DESIG);
					if (s_des (s) == '.' ||
					    s_des (s) == 'h' ||
					    s_des (s) == '=') {
						showit = AddEnemyShip (x, y,
								       num,
								       owner,
								       ptri);
						last_ship = num;
					}
					else
						showit = AddEnemyPlane (x, y,
									num,
									owner,
									ptri);
						
				}

				if (showit) {
					* tmpptr = savechar;
					PrintAtEmpire (line);
				}
			}
		}
	}
}

void FScanReport (who)
const char *who;
{
	FeedEmpire (Fmt ("report %s", who), PRINT);
	ScanReport ();
	(void) WaitForPrompt (PRINT);
}

void ScanReport ()
{
	char *line, *ptri, *tmpptr;
	int nr;
	extern WinInfo empire_win;

	MessageAtEmpire ("searching country names");

	if (! SkipNLines (1, DONT_PRINT))
		return;

	for (;;)
	{
		ptri = line = ReadEmpire (DONT_PRINT);

		if (line == (char *) 0)
			return;

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}

		SkipBlank ((ConstVP)&ptri);

		if (*ptri == '#') /* # name ... */
			continue;

		if (! ScanDigit ((ConstVP)& ptri, & nr))
		{
			PrintAtEmpire ("Bad relation format");
			PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
			Bell ();
			(void) EmpireMore ();
			continue;
		}

		SkipBlank ((ConstVP)& ptri);

		tmpptr = line + 21;

		do
			tmpptr--;
		while (isspace (*tmpptr));

		* ++ tmpptr = '\0';

		AddCountry (nr, ptri);
	}
}

void FScanRelations (cnum)
     int cnum;
{
	FeedEmpire (Fmt ("relations %d", cnum), PRINT);
	ScanRelations ();
	(void) WaitForPrompt (PRINT);
}

void ScanRelations ()
{
	char *line, *ptri, *tmpptr;
	int nr;
	bool err;
	extern WinInfo empire_win;

	MessageAtEmpire ("searching country names");

	(void) SkipNLines (3, DONT_PRINT);

	for (;;)
	{
		ptri = line = ReadEmpire (DONT_PRINT);
		if (line == (char *) 0) return;

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}

		SkipBlank ((ConstVP)&ptri);

		err = ! ScanDigit ((ConstVP)& ptri, &nr);


		ptri = index (ptri, ')') + 1;

		if (err || ptri == (char *) 0)
		{
			PrintAtEmpire ("Bad relation format");
			PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
			Bell ();
			(void) EmpireMore ();
			continue;
		}

		SkipBlank ((ConstVP)& ptri);

		tmpptr = line + 26;

		do
			tmpptr--;
		while (isspace (*tmpptr));

		* ++ tmpptr = '\0';

		AddCountry (nr, ptri);
	}
}

void FScanSpy (where)
const char *where;
{
	FeedEmpire (Fmt ("spy %s", where), PRINT);
	ScanSpy ();
	(void) WaitForPrompt (PRINT);
}
	
bool ScanSpySatLine (line, oldline)
char * line;
char * oldline;
{
	bool err;
	int x, y;
	Sector sct;
	int own, oldown, nr, idx;
	int eff = 0, tech = 0;
	char *ptri, *ptri2;
	char name [30];

	if (land_units && (StrStr(line,"Spies report enemy unit: ") != (char *) 0)) {
		err = sscanf (oldline , " %d,%d %*c %d", &x, &y, & own) != 3;
		ptri = index(line, ':');
		ptri = ptri + 3;
		ptri2 = index(ptri, '#');
		idx = (ptri2 - ptri) - 1;
		strncpy (name, ptri, idx);
		name [idx] = '\0';
		idx = sscanf (ptri2, "#%d %*s %d%*c %*s %d)", & nr, & eff, & tech);
		if (!err) {
			eff++;
			tech++;
			if (idx < 2) {
				eff--;
				tech--;
			}
			if (idx == 2) 
				tech--;
			
			AddEnemyLand (x, y, nr, own, name, eff, tech);
			return True;
		} else
			return False;
	}

	err = sscanf (line , " %d,%d ", &x, &y) != 2;

	if (! err)
	{
		sct = World (x, y, S_RESOU);
		/*
		 *	Spyplanes also reports your own sectors
		 */

		if (s_owned (sct))
			return True;

		nr = sscanf (line,
			     " %*d,%*d %c %d %d %hd %hd %hd %hd %hd %hd %hd",
			     & sct-> des,
			     & own,
			     & eff,
			     & sct-> sct2-> civ,
			     & sct-> sct2-> mil,
			     & sct-> sct2-> qua [D_SHE],
			     & sct-> sct2-> qua [D_GUN],
			     & sct-> sct2-> qua [D_IRO],
			     & sct-> sct2-> qua [D_PET],
			     & sct-> sct2-> qua [D_FOO]);
	}

	if (err || nr != 10)
		return False;

	set_owner (sct, own);
	set_eff (sct, eff);
	SET_INFO_SPY (sct);
	SetSectorTime (sct);
	DrawSector (sct);

	return True;
}

bool ScanSpyLine (line, oldline)
char * line;
char * oldline;
{
	bool err;
	int x, y;
	Sector sct;
	int own, oldown, nr, idx;
	int eff = 0, tech = 0;
	char *ptri, *ptri2;
	char name [30];

	if (land_units && (StrStr(line,"Spies report enemy unit: ") != (char *) 0)) {
		err = sscanf (oldline , " %d,%d %*c %d", &x, &y, & own) != 3;
		ptri = index(line, ':');
		ptri = ptri + 3;
		ptri2 = index(ptri, '#');
		idx = (ptri2 - ptri) - 1;
		strncpy (name, ptri, idx);
		name [idx] = '\0';
		idx = sscanf (ptri2, "#%d %*s %d%*c %*s %d)", & nr, & eff, & tech);
		if (!err) {
			eff++;
			tech++;
			if (idx < 2) {
				eff--;
				tech--;
			}
			if (idx == 2) 
				tech--;
			
			AddEnemyLand (x, y, nr, own, name, eff, tech);
			return True;
		} else
			return False;
	}

	err = sscanf (line , " %d,%d ", &x, &y) != 2;

	if (! err)
	{
		sct = World (x, y, S_RESOU);
			/*
			 *	Spyplanes also reports your own sectors
			 */

		if (s_owned (sct))
			return True;

	/* changed by pkenny, added a fix to spy, added & oldown, 11 */
		if (sscanf (line,
			    " %*d,%*d %c %d %d %d %hd %hd %hd %hd %hd %hd %hd",
			    & sct-> des,
			    & own,
			    & oldown,
			    & eff,
			    & sct-> sct2-> civ,
			    & sct-> sct2-> mil,
			    & sct-> sct2-> qua [D_SHE],
			    & sct-> sct2-> qua [D_GUN],
			    & sct-> sct2-> qua [D_IRO],
			    & sct-> sct2-> qua [D_PET],
			    & sct-> sct2-> qua [D_FOO]) != 11 &&
		    sscanf (line,
			    " %*d,%*d %c %d %d %hd %hd %hd %hd %hd %hd %hd",
			    & sct-> des,
			    & own,
			    & eff,
			    & sct-> sct2-> civ,
			    & sct-> sct2-> mil,
			    & sct-> sct2-> qua [D_SHE],
			    & sct-> sct2-> qua [D_GUN],
			    & sct-> sct2-> qua [D_IRO],
			    & sct-> sct2-> qua [D_PET],
			    & sct-> sct2-> qua [D_FOO]) != 10)
		    err = True;
	}

	if (err)
		return False;

	set_owner (sct, own);
	set_eff (sct, eff);
	SET_INFO_SPY (sct);
	SetSectorTime (sct);
	DrawSector (sct);

	return True;
}

void ScanSpy ()
{
	char *line;
	char *oldline;
	int x, y;

	MessageAtEmpire ("scanning spy output");

	do {
		line = ReadEmpire (PRINT);

		if (EmpireStatus () == E_COMMAND)
			return;
	}
	while (match_str (line, "\\s+sect\\s+type\\s+own", NULL, 0)  != 0);

	for (;;)
	{
		line = ReadEmpire (PRINT);
		if (line == (char *) 0)
			return;
		
		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}

		if (land_units && !StrEQ (line, "Spies")) {
			oldline = (char *) malloc(strlen(line)+1);
			strcpy (oldline, line);
		}

		if (!ScanSpyLine (line, oldline))
		{
			Message ("Spy failed");
			Bell ();
			(void) EmpireMore ();
			ClearMes ();
			continue;
		}
	}
}

bool SetOffset (country)
     char *country;
{
	char *line;

	FeedEmpire (Fmt ("offset %s", country), PRINT);
	for (;;) {
		line = ReadEmpire (PRINT);
		if (line == (char *) 0)
			return False;
		if (EmpireStatus () == E_COMMAND) {
			PrintAtEmpire (line);
			return False;
		}
		
		if (! strncmp (line, "No such country", 15)) {
			fprintf (stderr, "No such country : %s\n", country);
			leave ();
		}

		if (! strncmp (line, "Old offset was", 14)) {
			(void) WaitForPrompt (PRINT);
			deity = True;
			return True;
		}
	}
}

/*
 * new code mta Fri Nov 30 22:26:02 EET 1990
 */
void ScanSatellite ()
{
	register int x, y, start_x, end_x, start_y, end_y;
	int d, sx, sy, off_sector;
	char *line, *ptri;
	char des;
	Sector sct;
   
	if (EmpireStatus () == E_COMMAND)
		return;
   
	MessageAtEmpire ("scanning satellite(s)");
   
	for (;;)
	{
		if (EmpireStatus () == E_PRINTING)
		{
			line = ReadEmpire (DONT_PRINT);
			if (line == (char *) 0) return;
		}
	 
		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}
	 
		if (!strncmp (line, "Satellite", 9))
			continue;
	 
		if (!strncmp (line, "(c) 1989 Imaginative Images Inc.", 32))
			continue;

		if (sscanf (line, 
			    "landsat #%*d at %d,%d efficiency %*d%%, max range %d",
			    &sx, &sy, &d) != 3) {
			ptri = index(line, '#');
			if (!ptri) ptri = line;
			/* "spysat %*[12] #%*d at %d,%d efficiency %*d%%, max range %d", */
			if (sscanf (ptri, 
				    "#%*d at %d,%d efficiency %*d%%, max range %d", 
				    &sx, &sy, &d) != 3) {
				PrintAtEmpire (Fmt (
			    "ScanSatellite: new kind of satellite ?\n\"%s\"\n",
						    ptri));
				Bell ();
				(void) EmpireMore ();
				continue;
			} 
			MessageAtEmpire("scanning spysat");
			/* skip:
			 *    Satellite sector report
			 *    date
			 *    sect  type own eff civ mil shl gun iron  pet  food
			 */
			SkipNLines(1, PRINT); 
			SkipNLines(3, DONT_PRINT); 
			line = ReadEmpire (DONT_PRINT);
			while( ScanSpySatLine(line, NULL) )
				line = ReadEmpire (DONT_PRINT);
			/* skip:
			 *      empty
			 *      Satellite ship report
			 *      date
			 *      own  shp# ship type  sector   eff
			 */
			SkipNLines(1, DONT_PRINT);
			SkipNLines(1, PRINT);
			SkipNLines(1, DONT_PRINT);
			line = ReadEmpire (DONT_PRINT);
			off_sector = (char *)StrStr(line, "sector") - line;
			line = ReadEmpire (DONT_PRINT);
			while ( AddSatelliteShip(line, off_sector) )
				line = ReadEmpire (DONT_PRINT);

			if (land_units) {

				/* skip:
				 *      empty
				 *      Satellite unit report
				 *      date
				 *      own  lnd# unit type  sector   eff
				 */
				SkipNLines(1, DONT_PRINT);
				SkipNLines(1, PRINT);
				SkipNLines(1, DONT_PRINT);
				line = ReadEmpire (DONT_PRINT);
				off_sector = (char *)StrStr(line, "sector") - line;
				line = ReadEmpire (DONT_PRINT);
				while ( AddSatelliteLand(line, off_sector) )
					line = ReadEmpire (DONT_PRINT);
			}
			/* skip:
			 *      empty
			 *      Satellite radar report
			 */
			SkipNLines(1, DONT_PRINT);
			SkipNLines(1, PRINT);
		} else {
			       MessageAtEmpire("scanning landsat");
			       SkipNLines(1, DONT_PRINT);
		       }	
	 
		sct = World (sx, sy, S_DESIG);
		(void) UpdateSectorDes (sct, '.', False);
	 
	 
		if (d == 0)
		{
			(void) SkipNLines (2, DONT_PRINT);
			continue;
		}

		/* Don't try to scan more than width of world */
		if ( d < MAX_X/4 ) {
			start_x = sx - (2 * d);
			end_x = sx + (2 * d);
		} else {
			start_x = sx - (MAX_X/2);
			end_x = sx + (MAX_X/2) - 1;
		}
	 
		if (d < MAX_Y/2) { /* TARL - Don't scan more than height */
			start_y = sy - d; /* of world. */
			end_y = sy + d;
		} else {
			start_y = sy - (MAX_Y/2);
			end_y = sy + (MAX_Y/2) - 1;
		}

		for (y = start_y; y <= end_y; y++)
		{
			ptri = line = ReadEmpire (DONT_PRINT);
			if (line == (char *) 0) return;
	       
			for (x = start_x; x <= end_x; ptri++, x++)
			{
				if (*ptri == '\0')
				{
					PrintAtEmpire (Fmt (" Trying to scan 0 (%d, %d) %d\"%s\"\n",
							    x, y, d, line));
					Bell ();
					(void) EmpireMore ();
					break;
				}
				if ((x + y) % 2 == 0)
				{
					des = *ptri;
			   
					if (des == ' ' || des == '0')
						continue;
			   
					sct = World (x, y, S_DESIG);
					if (des >= 'A' && des <= 'Z')
					{
						if (!ShipAtSect (sct, des))
						{
							PrintAtEmpire (
       Fmt ( "Warning Enemy ship (%c) at %s detected with no further info",
	    des, CrdStr (sct)));
							Bell ();
							(void) EmpireMore ();
						}
				 
						(void) UpdateSectorDes
							(sct, '.', False);
					}
					else if (des == '$') {
						PrintAtEmpire (Fmt ("Satellite detected at %s", CrdStr (sct)));
						Bell ();
						(void) EmpireMore ();
					}
					else if (!UpdateSectorDes (sct, des,
								   (des == '?')? False:True))
					{
						PrintAtEmpire (
							       Fmt ("Skipping \"%s\"", line));
						Bell ();
						(void) EmpireMore ();
					}
				}
			}
		}
	 
		line = ReadEmpire (DONT_PRINT);
	 
		if (line == (char *) 0)
			return;
	}
}

static bool AddSatelliteShip (line, sector)
char *line;
int sector;
{
	bool err;
	int x, y;
	Sector sct;
	int own, eff, shp;
	char type[128], *tmpptr;
	char *coords = line+sector;
   
	if (strlen(line) < 20)
		return False;

	SkipBlank((ConstVP) &line );
	err = !ScanDigit((ConstVP) &line, &own);
	err |= !ScanDigit((ConstVP) &line, &shp);

	SkipBlank((ConstVP) &line );

	if (! err && own != my_cnum)
	{
		tmpptr = line+17; /* was 18, off by one */
		do
			tmpptr--;
		while (isspace (*tmpptr));
		*(tmpptr+1) = '\0';
		sscanf(coords, "%d,%d %d%%", &x, &y, &eff);
		if (AddEnemyShip(x, y, shp, own, line))
			PrintAtEmpire(Fmt ("Enemy (%d) ship (%s) at %d,%d",
					   own, line, x, y));
	}

	if ( err )
		return False;
	else
		return True;
}

static bool AddSatelliteLand (line, sector)
char *line;
int sector;
{
	bool err;
	int x, y;
	Sector sct;
	int own, eff, lnd;
	char type[128], *tmpptr;
	char *coords = line+sector;
   
	SkipBlank((ConstVP) &line );
	err = !ScanDigit((ConstVP) &line, &own);
	err |= !ScanDigit((ConstVP) &line, &lnd);

	SkipBlank((ConstVP) &line );

	if (! err && own != my_cnum)
	{
		tmpptr = line+10;
		do
			tmpptr--;
		while (isspace (*tmpptr));
		*(tmpptr+1) = '\0';
		sscanf(coords, "%d,%d %d%%", &x, &y, &eff);
		if (AddEnemyLand(x, y, lnd, own, line, eff, 0))
			PrintAtEmpire(Fmt ("Enemy (%d) unit (%s) at %d,%d",
					   own, line, x, y));
	}

	if ( err )
		return False;
	else
		return True;
}
