/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/realm.c,v 5.2 1995/09/08 07:31:30 jpo Exp $
    $Date: 1995/09/08 07:31:30 $
    $Author: jpo $
    $Id: realm.c,v 5.2 1995/09/08 07:31:30 jpo Exp $
    $Locker:  $
    $Log: realm.c,v $
    Revision 5.2  1995/09/08 07:31:30  jpo
    const

 * Revision 5.1  93/03/14  16:49:40  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

struct s_realm
{
	int sx, sy, ex, ey;
	int cx, cy;
	int rx, ry;
	int flag;
	bool done, first;
};

Realm InitRealm (realm, flag)
char * realm;
int flag;
{
	Realm new;

	new = (Realm) doalloc ((unsigned) sizeof (struct s_realm));
	new-> flag = flag;
	if (! ConvRealmToCoord (realm,
			& (new-> sx), & (new-> sy),
			& (new-> ex), & (new-> ey)))
	{
		free ((char *) new);
		return (Realm) 0;
	}
	new-> done = False;
	new-> first = True;
	new-> rx = new-> sx > new-> ex;
	new-> ry = new-> sy > new-> ey;
	new-> cx = new-> rx ? new-> ex : new-> sx;
	new-> cy = new-> ry ? new-> ey : new-> sy;
	return new;
}

void FreeRealm (realm)
Realm realm;
{
	free ((char *) realm);
}

bool InRealm (realm, sct)
Realm realm;
Sector sct;
{
	if (realm-> rx)
	{
		if (s_xcd (sct) > realm-> sx || s_xcd (sct) < realm-> ex)
			return False;
	}
	else
		if (s_xcd (sct) < realm-> sx || s_xcd (sct) > realm-> ex)
			return False;

	if (realm-> ry)
	{
		if (s_ycd (sct) > realm-> sy || s_ycd (sct) < realm-> ey)
			return False;
	}
	else
		if (s_ycd (sct) < realm-> sy || s_ycd (sct) > realm-> ey)
			return False;

	return True;
}

static AdvanceInRealm (realm)
Realm realm;
{
	realm-> cx = EX (realm-> cx + 1);

	if ((realm-> rx && (realm-> cx > realm-> sx)) ||
	    (! realm-> rx && (realm-> cx > realm-> ex)))
	{
		realm-> cx = realm-> rx ? realm-> ex : realm-> sx;
		realm-> cy = EY (realm-> cy + 1);
		if ((realm-> ry && (realm-> cy > realm-> sy)) ||
		    (! realm-> ry && (realm-> cy > realm-> ey)))
		{
			realm-> done = True;
			return;
		}
	}
}

bool NextSctInRealm (realm, ret)
Realm realm;
Sector * ret;
{
	Sector sct;

	if (realm-> done)
	{
		* ret = (Sector) 0;
		return False;
	}

	if (realm-> first)
	{
		realm-> cx = realm-> sx;
		realm-> cy = realm-> sy;
		realm-> first = False;
	}
	else
	{
		AdvanceInRealm (realm);
		if (realm-> done)
		{
			* ret = (Sector) 0;
			return False;
		}
	}

	sct = World (realm-> cx, realm-> cy, S_EXIST);
	while (sct == (Sector) 0 ||
	       (realm-> flag == S_OWNED && ! s_owned (sct)))
	{
		AdvanceInRealm (realm);
		if (realm-> done)
		{
			* ret = (Sector) 0;
			return False;
		}
		sct = World (realm-> cx, realm-> cy, S_EXIST);
	}

	* ret = sct;
	return True;
}

bool ConvRealmToCoord (realm, sx, sy, ex, ey)
const char * realm;
int * sx, * sy, * ex, * ey;
{
	SkipBlank (& realm);

	if (realm [0] == '#')
	{
		if (realm [1] >= '0' && realm [1] <= '9')
			realm = n_realm (nation, realm [1] - '0');
		else
			realm = n_realm (nation, 0);
	} else if (realm[0] == '*') {
		*sx = -MAX_X / 2;
		*ex = (MAX_X / 2) - 1;
		*sy = -MAX_Y / 2;
		*ey = (MAX_Y / 2) - 1;
		return True;
	}
		
	
	if (! ScanDigit (& realm, sx))
		return False;
	
	if (* realm == ':')
	{
		realm ++;
		if (! ScanDigit (& realm, ex))
			return False;
	}
	else
		* ex = * sx;
	
	if (* realm ++ != ',' || ! ScanDigit (& realm, sy))
		return False;

	if (* realm == ':')
	{
		realm ++;
		if (! ScanDigit (& realm, ey))
			return False;
	}
	else
		* ey = * sy;

	if (* sx > * ex)
		* ex = - * ex;
	if (* sy > * ey)
		* ey = - * ey;

	return True;
}
