/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/product.c,v 5.2 1995/09/08 07:31:01 jpo Exp $
    $Date: 1995/09/08 07:31:01 $
    $Author: jpo $
    $Id: product.c,v 5.2 1995/09/08 07:31:01 jpo Exp $
    $Locker:  $
    $Log: product.c,v $
    Revision 5.2  1995/09/08 07:31:01  jpo
    constant change

 * Revision 5.1  93/03/14  16:49:39  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "version.h"

static char * fname = "misc/product.c";

#undef OFFSET
#define		OFFSET(x,y)	y

#define		sct_min		1
#define		sct_gmin	2
#define		sct_fertil	3
#define		sct_oil		4
#define		sct_uran	5
	/*
	 *	Just copy this table from lib/global/produce.c
	 *	After that, check 'prod_design' below
	 */

struct pchrstr pchr[]  = {
/*       level      cost    nrndx nrdep nlndx   nlmin nllag effic  sname name */
{0,       0,         0,      0,    0,    0,        0,    0,  0,    
	"unused", 0, { 0 }, { 0 }, "", },
{V_SHELL, -1,        3,      0,    0,    NAT_TLEV, 20,  10, 100, 
	"shells", 2, { V_LCM, V_HCM}, { 2, 1 },  "shells", },
{V_GUN,   -1,        30,     0,    0,    NAT_TLEV, 20,  10, 100, 
	"guns", 3, { V_OIL, V_LCM, V_HCM }, { 1, 5, 10 },  "guns",},
{V_PETROL,-1,        1,      0,    0,    NAT_TLEV, 20,  10, 1000,
	"petrol", 1, { V_OIL }, { 1 },  "petrol",},
{V_IRON,  -1,        0,OFFSET(sctstr, sct_min),0,    -1,       0,    0,  100,
	"iron ore", 0, { 0 }, { 0 },  "iron",	},
{V_DUST,  -1,        0,OFFSET(sctstr, sct_gmin),20,  -1,       0,    0,  100,
	"gold dust", 0, { 0 }, { 0 },  "dust",},
{V_BAR,   -1,        10,     0,    0,    -1,       0,    0,  100, 
	"gold bars", 1, { V_DUST }, { 5 }, "bars",},
{V_FOOD,  -1,        0,OFFSET(sctstr, sct_fertil),0, NAT_TLEV, -10,  10, 900,
	"food", 0, { 0 }, { 0 }, "food",},
{V_OIL,   -1,        0,OFFSET(sctstr, sct_oil),10,   NAT_TLEV, -10,  10, 100, 
	"oil", 0, { 0 }, { 0 }, "oil",},
{V_LCM,   -1,        0,      0,    0,    NAT_TLEV, -10,  10, 100,
	"light construction materials", 1, { V_IRON }, { 1 }, "lcm",},
{V_HCM,   -1,        0,      0,    0,    NAT_TLEV, -10,  10, 100,
	"heavy construction materials", 1, { V_IRON }, { 2 },  "hcm", },
{0,       NAT_TLEV, 300,     0,    0,    NAT_ELEV, 5,    10, 100,
      "technological breakthroughs",3,{V_DUST,V_OIL,V_LCM}, {1,5,10}, "tech",},
{0,       NAT_RLEV, 90,     0,    0,    NAT_ELEV, 5,    10, 100,
      "medical discoveries",3,{V_DUST,V_OIL,V_LCM }, { 1, 5, 10 }, "medical",},
{0,       NAT_ELEV,  9,     0,    0,    -1,       0,    0,  100,
	"a class of graduates", 1, { V_LCM }, { 1 },  "edu",},
{0,       NAT_HLEV,  9,     0,    0,    -1,       0,    0,  100,
	"happy strollers", 1, { V_LCM }, { 1 },  "happy",},
{V_RAD, -1,          2,OFFSET(sctstr, sct_uran),35, NAT_TLEV, 40,  10, 100, 
	"radioactive materials", 0, { 0 }, { 0 },  "rad",},
};

static char * prod_design = "Xid%mgbaojktrlpu";

struct pchrstr * ProdChr (des)
char des;
{
	char * ptr;

	ptr = index (prod_design, des);
	if (des == '\0' || ptr == (char *) 0)
		return (struct pchrstr *) 0;
	
	return & (pchr [ptr - prod_design]);
}

int GiveProdResource (sct, i)
Sector sct;
int i;
{
	switch (i)
	{

	case sct_min:
		return s_min (sct);

	case sct_gmin:
		return s_gol (sct);

	case sct_fertil:
		return s_fer (sct);

	case sct_oil:
		return s_oil (sct);

	case sct_uran:
		return s_ura (sct);

	default:
		Panic ("GiveProdResoure",
			fname, Fmt ("illegal resource: %d", i));
		return 0;
	}
}

void SetProdResource (sct, i, q)
Sector sct;
int i;
int q;
{
	switch (i)
	{

	case sct_min:
		set_min (sct, q);
		break;

	case sct_gmin:
		set_gol (sct, q);
		break;

	case sct_fertil:
		set_fer (sct, q);
		break;

	case sct_oil:
		set_oil (sct, q);
		break;

	case sct_uran:
		set_ura (sct, q);
		break;

	default:
		Panic ("SetProdResoure",
			fname, Fmt ("illegal resource: %d", i));
	}
}

	/*
	 *	Be carefull: no tests
	 */

int ProdCost (item)
int item;
{
	register struct pchrstr * ptr;

	ptr = pchr;
	do {
		ptr ++;

		if (ptr-> p_type == item)
			return ptr-> p_cost;
	}
	while (ptr-> p_type != V_RAD);

	return 0;
}
