/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/misc2.c,v 5.2 1995/09/08 07:30:27 jpo Exp $
    $Date: 1995/09/08 07:30:27 $
    $Author: jpo $
    $Id: misc2.c,v 5.2 1995/09/08 07:30:27 jpo Exp $
    $Locker:  $
    $Log: misc2.c,v $
    Revision 5.2  1995/09/08 07:30:27  jpo
    more string stuff

 * Revision 5.1  93/03/14  16:49:32  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

bool Confirm (str, def)
const char *str;
bool def;
{
	WinInfo tmp;
	char *lines[10], *answer;
	char *estr, *ptr, *s, *realstr;
	int len, cuts, cutlen, maxcutlen, partlen, i, nr;

	len = strlen (str);
	cuts = len/30;

	maxcutlen = 16;
	nr = 0;
	cutlen = (len + cuts)/(cuts + 1);
	realstr = ptr = Str(str);
	estr = ptr + len - 1;;
	while (ptr <= estr)
	{
		s = ptr + cutlen - 1;
		if (s > estr + 1)
			s = estr + 1;
		else
			while (*s != ' ' && *s != '\0')
				s ++;
		*s = '\0';
		partlen = s - ptr;
		if (partlen > maxcutlen)
			maxcutlen = partlen;
		lines[nr ++] = ptr;
		ptr = s + 1;
		SkipBlank ((ConstVP)&ptr);
	}
			

	tmp = OpenWindow (map_win, 5, 0, maxcutlen + 4, cuts + 5,
			  CHARS, MENU, 0);

	for (i = 0; i < nr; i++)
		Print (tmp, 2, 3 + i, lines[i], NORMAL);

	free (realstr);
	Bell ();
	answer = GetQuest (tmp, 1,
			Centered (Fmt (" Confirm [%c]: ", def ? 'y' : 'n'),
							     maxcutlen),
			1, "yn");

	DestroyWindow (tmp);

	if (answer == (char *) 0 || *answer == 'n' ||
			(*answer == '\0' && def == False))
		return False;
	else
		return True;
}

#ifdef TERMC_VERSION

#define		ERROR_MODE	NORMAL

#else	/* X_VERSION */

#define		ERROR_MODE	BOLD

#endif 	/* VERSION */

void Error (str)
const char *str;
{
	WinInfo tmp;
	char *lines[10], savechar;
	char *estr, *ptr, *s, *baseptr;
	int len, cuts, cutlen, maxcutlen, partlen, i, nr;

	if (! xstarted)
	{
		fprintf (stderr, "%s\n", str);
		return;
	}

	len = strlen (str);
	cuts = len/30;

	maxcutlen = nr = 0;
	cutlen = (len + cuts)/(cuts + 1);
	baseptr = ptr = Str(str);
	estr = ptr + len - 1;;
	while (ptr <= estr)
	{
		s = ptr + cutlen - 1;
		if (s > estr + 1)
			s = estr + 1;
		else
			while (*s != ' ' && *s != '\0')
				s ++;

		savechar = *s;
		*s = '\0';
		partlen = s - ptr;
		if (partlen > maxcutlen)
			maxcutlen = partlen;
		lines[nr ++] = ptr;
		*s = savechar;
		ptr = s;
		SkipBlank ((ConstVP)&ptr);
	}
			

	tmp = OpenWindow (map_win, 5, 1, maxcutlen + 2, cuts + 3,
								CHARS, MENU, 0);

	for (i = 0; i < nr; i++)
	{
		Print (tmp, 1, 1 + i, lines[i], ERROR_MODE);
	}
	free(baseptr);
	FlushWindow (tmp);
	Bell ();
	Refresh ();
	Pause ();
	DestroyWindow (tmp);
}

void SwapInt (a, b)
int * a, * b;
{
	int dummy;

	dummy = * a;
	* a = * b;
	* b = dummy;
}

char * GetQuest (win, y, quest, maxlen, fmt)
WinInfo win;
int y;
const char * quest, * fmt;
int maxlen;
{
	PrintN (win, 1, y, quest);
	return GetString (win, strlen (quest) + 1, y, maxlen, fmt);
}

void Disabled ()
{
	Message ("This function has (temp) been disabled");
	Bell ();
}

bool HandleQuestion (quest)
const char * quest;
{
	char * ans;

	PrintAtEmpire (quest);
	ans = InputAtMessage (quest, 15, GS_TEXT);
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		while (EmpireStatus () != E_COMMAND)
		{
			FeedEmpire ("aborted", PRINT);
			(void) WaitForPrompt (PRINT);
		}
		return False;
	}

	FeedEmpire (ans, PRINT);
	return True;
}
