/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/misc/RCS/message.c,v 5.3 1995/09/14 19:40:32 jpo Exp $
    $Date: 1995/09/14 19:40:32 $
    $Author: jpo $
    $Id: message.c,v 5.3 1995/09/14 19:40:32 jpo Exp $
    $Locker:  $
    $Log: message.c,v $
    Revision 5.3  1995/09/14 19:40:32  jpo
    Allow more room for input strings

    Revision 5.2  1995/09/08 07:29:59  jpo
    string stuff

 * Revision 5.1  93/03/14  16:49:28  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"

#ifdef X_VERSION

#define	MES_MODE	BOLD

#else

#define	MES_MODE	NORMAL

#endif

WinInfo mes_win;

static int mes_width;

void InitMessage (inc_width)
int inc_width;
{

#ifdef TERMC_VERSION

	mes_width = screen_cols - CENSUS_WIDTH - 1;

	mes_win = OpenWindow (root_win,
			CENSUS_WIDTH + 1,
			0,
			mes_width,
			MES_HEIGHT,
			0,
			LOWER_BOX,
			0);

#else /* TERMC_VERSION */

	mes_width = ROOT_WIDTH - CENSUS_WIDTH - 2 + inc_width;

	mes_win = OpenWindow (root_win, CENSUS_WIDTH + 1, 0, mes_width,
			      MES_HEIGHT, CHARS, FIXED, 0);

#endif /* TERMC_VERSION */

	FlushWindow (mes_win);
}

void ClearMes ()
{
	Print (mes_win, 0, 0, Fmt ("%*s", mes_width, ""), MES_MODE);
}

void ClearMes2 ()
{
	Print (mes_win, 0, 1, Fmt ("%*s", mes_width, ""), MES_MODE);
}


void Warning (str)
const char * str;
{
	Message (Fmt ("%s -- More", str));
	FlashWindow (mes_win);
	Bell ();
	Pause ();
}

void Message (str)
const char * str;
{
	int at;

	at = (mes_width - strlen (str)) / 2;

	if (at < 0) at = 0;

	ClearMes ();
	Print (mes_win, at, 0, str, MES_MODE);
	FlashWindow (mes_win);
	Refresh ();
}

void Message2 (str)
const char *str;
{
	int at;

	at = (mes_width - strlen (str)) / 2;

	if (at < 0) at = 0;

	ClearMes2 ();
	Print (mes_win, at, 1, str, MES_MODE);
	FlashWindow (mes_win);
	Refresh ();
}

static char *lastb1, *lastb2, *lastb3;

void MesClearBut ()
{
	Print (mes_win, 0, 1, Fmt ("%*s", mes_width, ""), NORMAL);
	FlushWindow (mes_win);
	lastb1 = lastb2 = lastb3 = (char *) 0;
}

void MesBut (b1, b2, b3)
char *b1, *b2, *b3;
{
	lastb1 = b1;
	lastb2 = b2;
	lastb3 = b3;
	Print (mes_win, 0, 1, Fmt ("%*s", mes_width, ""), BOLD);
	Print (mes_win, 0, 1, Fmt ("[%s]", b1), BOLD);
	Print (mes_win, (mes_width - strlen (b2)) / 2 - 2, 1,
		Fmt ("[%s]", b2), BOLD);
	Print (mes_win, mes_width - strlen (b3) - 2, 1, Fmt ("[%s]", b3), BOLD);
	FlushWindow (mes_win);
}

void SameBut ()
{
	if (lastb1 != (char *) 0)
		MesBut (lastb1, lastb2, lastb3);
	else
		MesClearBut ();
}

void MessageMore ()
{
	PrintN (mes_win, (mes_width - 12) / 2, 1, "-=[ MORE ]=-");
	Pause ();
	SameBut ();
}

char *InputAtMessage (str, maxlen, form)
const char *str;
int maxlen;
const char * form;
{
	char *ptr;
	int len, len1, len2;

	Print (mes_win, 0, 0, Fmt ("%*s", mes_width, ""), MES_MODE);

	len = strlen (str);
	while (len > 0 && str[len - 1] == ' ')
		len--;

	if (str[len] == ' ')
		len --;
/*		str[len] = '\0'; */

	if (len > mes_width - 6)
	{
		Print (mes_win, 0, 1, Fmt ("%*s", mes_width, ""), MES_MODE);

		len1 = len/2 + 4; /* put more on first line then on second */

		while (len1 <= len && str[len1 - 1] != ' ')
			len1++;

		if (len1 > mes_width - 4) /* That must be a long word !! */
			len1 = len/2 + 4;

		len2 = len - len1;
		Print (mes_win, 2, 0,
		       Fmt ("%.*s", len1, str), MES_MODE);
		Print (mes_win, 2, 1,
		       Fmt ("%s", str + len1), MES_MODE);

		ptr = GetString (mes_win, 2 + len2 + 1,
				 1, maxlen, form);
		
		Print (mes_win, 0, 1, Fmt ("%*s", mes_width, ""), MES_MODE);
		SameBut ();
	}
	else
	{
		Print (mes_win, 2, 0, Fmt ("%s", str), MES_MODE);
		ptr = GetString (mes_win, 2 + len + 1, 0, maxlen, form);
	}

	return ptr;
}
