/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/map.c,v 5.2 1995/09/08 07:29:22 jpo Exp $
    $Date: 1995/09/08 07:29:22 $
    $Author: jpo $
    $Id: map.c,v 5.2 1995/09/08 07:29:22 jpo Exp $
    $Locker:  $
    $Log: map.c,v $
    Revision 5.2  1995/09/08 07:29:22  jpo
    highlight expression

 * Revision 5.1  93/03/14  16:49:27  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "plane.h"
#include "sector.h"
#include "nation.h"
#include "ship.h"
#include "land.h"
#include "parser.h"
#include <sys/file.h>
#include <errno.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

WinInfo map_win;
Stack expr1;	/* (Stack) 0 means des (newdes)	*/
Stack expr2;
bool shownewdes1, shownewdes2;
bool double_displ;

#define	OVERLAY_NOTHING	0
#define	OVERLAY_SHIPS	1
#define	OVERLAY_PLANES	2
#define	OVERLAY_UNITS	3

int overlay;

	/* The map is centered around : */

static int center_x;
static int center_y;

static int nr_width;		/* # of sectors you can display */
static int nr_height;

static int firstx;		/* first sector to display */
static int firsty;

static char GiveOverlay (sct)
Sector sct;
{
	Ship ship;
	Land land;
	Plane plane;
	const char *cp;
	char ch;

	if (overlay == OVERLAY_SHIPS)
	{
		ship = s_fship (sct);
		if (ship != (Ship) 0 &&	(cp = ShipName (ship)) != NULL) {
			ch = *cp;
			if (ch >= 'a' && ch <= 'z')
				ch += 'A' - 'a';
			
			return ch;
		}
	}

	if (overlay == OVERLAY_PLANES)
	{
		plane = s_fplane (sct);
		if (plane != (Plane) 0 && (cp = PlaneName (plane)) != NULL) {
			ch = *cp;
			if (ch >= 'a' && ch <= 'z')
				ch += 'A' - 'a';

			return ch;
		}
	}

	if (overlay == OVERLAY_UNITS)
	{
		land = s_fland (sct);
		if (land != (Land) 0 && (cp = LandName (land)) != NULL) {
			ch = *cp;
			if (ch >= 'a' && ch <= 'z')
				ch += 'A' - 'a';

			return ch;
		}
	}

	return '\0';
}

static char GiveDisplayChar (sct, expr, newdes, overlay)
Sector sct;
Stack expr;
bool newdes;
bool overlay;
{
	double d;
	char ch;
	PlanEntry plan;

	if (overlay)
	{
		ch = GiveOverlay (sct);
		if (ch != '\0')
			return ch;
	}

	if (expr == (Stack) 0)
	{
		if (command_mode == PLAN_MODE && newdes)
		{
			if (! s_owned (sct))
			{
				if (index ("^-.s", s_des (sct)) != (char *) 0)
					return s_des (sct);
				else
					return '?';
			}

			plan = s_plan (sct);
			if (plan == (PlanEntry) 0)
				return '~';
			
			return PlanDesign (plan);
		}

		if (newdes && s_owned (sct) && sct -> sct2 &&
		    sct -> sct2 -> sct3)
			return s_nds (sct);
		else
			return s_des (sct);
	}

	d = EvaluateExpression (sct, expr);
	if (d < 0.0)
		return '-';
	else if (d > 9.99)
		return '+';
	else if (d == 0.0)
		return ' ';
	else
		return '0' + (char) d;
}

void DrawSector (sct)
Sector sct;
{
	int px, py;
	char buf [3];
	int x, y;

	if (sct == (Sector) 0)
		return;

	buf [0] = GiveDisplayChar (sct, expr1, shownewdes1, True);
	y = WY (s_ycd (sct) - firsty);
	if (y < 0)
		return;

	if (double_displ)
	{
		x = 2 * WX (s_xcd (sct) - firstx);
		buf [1] = GiveDisplayChar (sct, expr2, shownewdes2, False);
		buf [2] = '\0';
		if (s_mar (sct))
			PrintMarked (map_win, x, y, buf,
				HighlightSector (sct) ? BOLD : NORMAL);
		else
			Print (map_win, x, y, buf,
				HighlightSector (sct) ? BOLD : NORMAL);
	} 
	else
	{
		x = WX (s_xcd (sct) - firstx);
		buf [1] = '\0';
		if (s_mar (sct))
			PrintMarked (map_win, x, y, buf,
				HighlightSector (sct) ? BOLD : NORMAL);
		else
			Print (map_win, x, y, buf,
				HighlightSector (sct) ? BOLD : NORMAL);
	}

	FlushWindow (map_win);
}

void DrawNeighbours (sct)
Sector sct;
{
	DrawMapPart (s_xcd (sct) - 2, s_ycd (sct) - 1,
		     s_xcd (sct) + 2, s_ycd (sct) + 1);
}

#ifdef X_VERSION

bool ConvertToSctCrd (px, py)
int * px, * py;
{
	* py =  PixelToCharY (* py);

	if (double_displ)
		* px = PixelToCharX (* px) / 2;
	else
		* px = PixelToCharX (* px);

	if (*px < 0 || *px > nr_width || * py < 0 || *py > nr_height)
		return False;

	* px += firstx;
	* py += firsty;

	return True;
}

#else /* not X_VERSION -> TERMC_VERSION */

bool ConvertToSctCrd (x, y)
int * x, * y;
{
	if (double_displ)
		* x = (* x + 1) / 2;
	else
		(* x);
	
	(* y);

	if (* x < 0 || * x >= nr_width | * y < 0 || * y >= nr_height)
		return False;
	
	* x += firstx;
	* y += firsty;

	return True;
}

#endif /* X_VERSION */

bool AtScreen (x, y)
int x, y;
{
	x -= firstx;
	y -= firsty;

	return ! (x < 0 || x >= nr_width || y < 0 || y >= nr_height);
}
		
Sector FindSector (x, y)
int x, y;
{
	if (! ConvertToSctCrd (& x, & y))
		return (Sector) 0;

	return World (x, y, S_EXIST);
}

void MarkSector (sct)
Sector sct;
{
	if (sct == (Sector) 0)
		return;

	inc_mar (sct);

	if (s_mar (sct) == 1)
		DrawSector (sct);
}

void UnmarkSector (sct)
Sector sct;
{
	if (sct == (Sector) 0)
		return;

	dec_mar (sct);

	if (s_mar (sct) == 0)
		DrawSector (sct);
}
	

void SetCurrentSctShip (sct, ship)
Sector sct;
Ship ship;
{
	if (sct == (Sector) 0 || NO_INFO (sct))
		return;

	UnmarkSector (cursct);
	cursct = sct;

	curship = ship;

	MarkSector (cursct);
	Census ();
}

	/*
	 *	Set current (ship, nuke, plane)
	 */

void SetCurrent (sct)
Sector sct;
{
	if (sct == (Sector) 0 || NO_INFO (sct))
		return;

	if (sct != cursct) {	/* reset everything */
		curship = (Ship)0;
		curplane = (Plane)0;
		curnuke = (Nuke)0;
		curland = (Land)0;
		curfleet = curwing = curarmy = '\0';
	}

	switch (command_mode)
	{
	    case NORMAL_MODE:
		break;

	    case SHIP_MODE:
		if (curship == (Ship) 0)
			curship = s_fship (sct);
		else
			curship = sh_nxtsct (curship);
		Census ();
		break;
		
	    case FLEET_MODE:
		curfleet = GiveNextFleetInSct (sct, curfleet);
		break;

	    case PLANE_MODE:
		if (curplane == (Plane) 0)
			curplane = s_fplane (sct);
		else
			curplane = pl_nxtsct (curplane);

		Census ();
		break;
		
	    case WING_MODE:
		curwing = GiveNextWingInSct (sct, curwing);
		break;

	    case NUKE_MODE:
		curnuke = s_stock (sct);
		break;
	    case LAND_MODE:
		if (curland == (Land) 0)
			curland = s_fland (sct);
		else
			curland = ld_nxtsct (curland);
		Census ();
		break;
	    case ARMY_MODE:
		curarmy = GiveNextArmyInSct (sct, curarmy);
		break;
	}
	UnmarkSector (cursct);
	cursct = sct;

	MarkSector (cursct);
	Census ();
}

void DrawRealm (realm)
char * realm;
{
	int sx, sy, ex, ey;

	if (ConvRealmToCoord (realm, & sx, & sy, & ex, & ey))
		DrawMapPart (sx, sy, ex, ey);
}

void DrawMap ()
{
	ClearWindow (map_win);

	DrawMapPart (firstx, firsty,
		(double_displ) ? firstx + nr_width / 2 - 1
			       : firstx + nr_width - 1,
		EY (firsty + nr_height - 1));
}

	/*
	 *	drawmappart (sector coordinates)
	 */

void DrawMapPart (start_x, start_y, end_x, end_y)
int start_x, start_y, end_x, end_y;
{
	Sector sct;
	char buf[3];
	bool highl;
	int x, y;
	int xx, yy;

	if (end_x < start_x)
		end_x += MAX_X;

	if (end_y < start_y)
		end_y += MAX_Y;

	for (y = start_y; y <= end_y; y ++)
	{
		yy = WY (y - firsty);
		if (yy < 0 || yy >= nr_height)
			continue;

		for (x = start_x; x <= end_x; x ++)
		{
			if (double_displ)
				xx = 2 * WX (x - firstx);
			else
				xx = WX (x - firstx);

			if (xx < 0 || xx >= nr_width)
				continue;

			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0)
			{
				buf [0] = buf [1] = ' ';
				highl = False;
			}
			else
			{
				highl = HighlightSector (sct);
				buf [0] = GiveDisplayChar (sct, expr1,
						shownewdes1, True);
				if (double_displ)
					buf [1] = GiveDisplayChar (sct, expr2,
						shownewdes2, False);
			}

			if (double_displ)
				buf [2] = '\0';
			else 
				buf [1] = '\0';

			if (sct != (Sector) 0 && s_mar (sct))
				PrintMarked (map_win, xx, yy, buf,
					highl ? BOLD : NORMAL);
			else
				Print (map_win, xx, yy, buf,
					highl ? BOLD : NORMAL);
		}
	}

	FlushWindow (map_win);
}

void InitMap (inc_width, inc_height)
int inc_width, inc_height;
{
#ifdef TERMC_VERSION
	int lines;

	lines = screen_rows - MAP_STARTY - 1 - EMPIRE_HEIGHT;
	if (no_empwin)
		lines += EMPIRE_HEIGHT + 1;


	map_win = OpenWindow (root_win,
			MAP_STARTX,
			MAP_STARTY,
			screen_cols - MAP_STARTX,
			lines,
			0,
			NO_BOX,
			0);
	if (! no_empwin)
		LowerWindow (map_win);

	nr_width = screen_cols - MAP_STARTX + 2;
	nr_height = lines;

#else /* X_VERSION */

	map_win = OpenWindow (root_win, MAP_STARTX, MAP_STARTY,
			MAP_WIDTH + inc_width, MAP_HEIGHT + inc_height,
			CHARS, FIXED, 0);

	nr_width = MAP_WIDTH + inc_width;
	nr_height = MAP_HEIGHT + inc_height + 1;

#endif /* TERMC_VERSION */

	SetDefaultCursor (map_win, CR_MAP);

	expr1 = expr2 = (Stack) 0;
	shownewdes1 = True;
	shownewdes2 = False;
	double_displ = False;
	overlay = OVERLAY_SHIPS;

	center_x = s_xcd (cursct);
	center_y = s_ycd (cursct);

	firstx = EX (center_x - (int) (nr_width / 2));
	firsty = EY (center_y - (int) (nr_height / 2));

	FlushWindow (map_win);
}

static const char *overl_str [] = 
{
	"overlay nothing",
	"overlay ships",
	"overlay planes",
	"overlay units",
	(char *) 0
};

void ChangeOverlay (x, y, str)
int x, y;
char * str;
{
	char buf [40];
	Strings strings;
	Pager pager;
	int i;
	int r;

	if (str != (char *) 0 && sscanf (str, " ( %s )", buf) == 1)
	{
		switch (* str)
		{

		case '-':
		case 'n':
		case 'N':
			r = OVERLAY_NOTHING;
			break;

		case 's':
		case 'S':
			r = OVERLAY_SHIPS;
			break;

		case 'L':
		case 'l':
			if (land_units) {
				r = OVERLAY_UNITS;
			} else {
			      Message ("Illegal bind: Overlay No Land Units");
			}
			break;

		case 'P':
		case 'p':
			r = OVERLAY_PLANES;
			break;
		
		default:
			Message (
			    "Illegal bind: Overlay (noth | planes | ships)");
			return;
		}
	}
	else
	{
		strings = InitStrings ();
		AddStringsID (strings, overl_str, 4, 0);
		pager = InitPager (strings, "Overlay what ?");
		MapPagerFromTop (pager, map_win, x, y);
		r = PagerMenu (pager);
		FreePager (pager);
		FreeStrings (strings);
		if (r < 0)
		{
			Message ("Overlay cancelled");
			return;
		}
	}

	overlay = r;
}

#define	DM_OVERLAY	0
#define	DM_EXPR		1
#define	DM_DES 		2
#define	DM_NEWDES 	3
#define DM_HIGHLIGHT	4
#define DM_HIGHEXPR	5
#define DM_NORMAL	6

#define	DM_MAX		6

static const char *dis_menu [] =
{
	"Overlay (planes & ships & units)",
	"expression",
	"designation",
	"new designation",
	"change highlight",
	"highlight expression",
	"switch to normal display",
	(char *) 0
};

static Stack AskOneExpression ()
{
	char * ans;
	Stack expr;

	do {
		ans = InputAtMessage ("Expr: ", 60, GS_TEXT);
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			Message ("cancelled");
			return (Stack) 0;
		}

		expr = ParseExpression (ans);
	}
	while (expr == (Stack) 0);

	return expr;
}

void ChangeDisplay (x, y)
int x, y;
{
	Strings strings;
	Pager pager;
	Stack expr;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, dis_menu, DM_MAX, 0);
	if (double_displ)
		AddStringID (strings, dis_menu [DM_NORMAL], DM_NORMAL);
	pager = InitPager (strings, "Display ?");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (i < 0)
	{
		Message ("change display cancelled");
		return;
	}

	switch (i)
	{

	case DM_OVERLAY:
		ChangeOverlay (x + 2, y + 2, (char *) 0);
		break;

	case DM_EXPR:
		expr = AskOneExpression ();
		if (expr != (Stack) 0)
		{
			DestroyExpression (& expr2);
			expr2 = expr;
		}
		double_displ = True;
		break;

	case DM_DES:
		if (expr1 != (Stack) 0)
		{
			DestroyExpression (& expr1);
			expr1 = (Stack) 0;
		}
		shownewdes1 = False;
		break;

	case DM_NEWDES:
		if (expr1 != (Stack) 0)
		{
			DestroyExpression (& expr1);
			expr1 = (Stack) 0;
		}
		shownewdes1 = True;
		break;

	case DM_HIGHLIGHT:
		SetHighlight ();
		break;

	case DM_HIGHEXPR:
		ExprHighlight (AskOneExpression());
		break;

	case DM_NORMAL:
		double_displ = False;
		break;
	}

	ReCenter ();
	DrawMap ();
}

void BindHighlightExpression ()
{
	Stack expr;
	ExprHighlight (AskOneExpression());
	ReCenter ();
	DrawMap ();
}

void BindExpression ()
{
	Stack expr;

	expr = AskOneExpression ();

	if (expr2 != (Stack) 0)
		DestroyExpression (& expr2);
	expr2 = expr;
	double_displ = expr2 != (Stack) 0;
	ReCenter ();
	DrawMap ();
}

void BindNormalDisplay ()
{
	double_displ = False;
	ReCenter ();
	DrawMap ();
}

void ShiftField (dx, dy)
int dx, dy;
{
	if (dx == -1) 
		dx = -nr_width / 3;
	else if (dx == 1)
		dx = nr_width / 3;

	if (dy == -1)
		dy = -nr_height / 2;
	else if (dy == 1)
		dy = nr_height / 2;

	center_x = EX (center_x + dx);
	center_y = EY (center_y + dy);

	firstx = EX (center_x - (int) (nr_width / 2));
	firsty = EY (center_y - (int) (nr_height / 2));

	DrawMap ();
}

void DoCenterMap (x, y)
int x, y;
{
	CenterMap (s_xcd (cursct), s_ycd (cursct));
}

void CenterMap (x, y)
int x, y;
{
	center_x = EX (x);
	center_y = EY (y);

	firstx = EX (center_x - (int) (nr_width / (double_displ ? 4 : 2)));
	firsty = EY (center_y - (int) (nr_height / 2));

	DrawMap ();
}

void ReCenter ()
{
	firstx = EX (center_x - (int) (nr_width / (double_displ ? 4 : 2)));
	firsty = EY (center_y - (int) (nr_height / 2));
}

int Distance (a, b)
Sector a, b;
{
	register int distx, disty;

	distx = XDIST (s_xcd (a), s_xcd (b));
	if (distx > MAX_X/2) distx = MAX_X - distx;

	disty = YDIST (s_ycd (a), s_ycd (b));
	if (disty > MAX_Y/2) disty = MAX_Y - disty;

	return (disty < distx ? (distx + disty)/2 : disty);
}

int Dist (x1, x2, y1, y2)
int x1, x2, y1, y2;
{
	int distx, disty;

	if (x1 > x2)
		SwapInt (& x1, & x2);
	
	if (y1 > y2)
		SwapInt (& y1, & y2);

	distx = XDIST (x1, x2);
	if (distx > MAX_X/2) distx = MAX_X - distx;

	disty = YDIST (y1, y2);
	if (disty > MAX_Y/2) disty = MAX_Y - disty;

	return (disty < distx ? (distx + disty)/2 : disty);
}

static void Xy (fp, x1, x2, width)
FILE *fp;
int x1, x2, width;
{
	int j, num, nr;


	if (x1 + width > 99 || x2 - width < -99)
	{
		fprintf (fp, "     ");
		for (j = x1, nr = 0; nr < width; nr ++, j ++)
		{
			j = EX (j);
			if (j < 0 && j > -100)
				fprintf (fp, "-");
			else
			{
				num = ABS (j) / 100;
				fprintf (fp, "%d", num % 10);
			}
		}

		fprintf (fp, "\n");
	}

	fprintf (fp, "     ");
	for (j = x1, nr = 0; nr < width; nr ++, j ++)
	{
		j = EX (j);
		if (j < 0 && j > -10)
			fprintf (fp, "-");
		else 
		{
			num = ABS (j) / 10;
			fprintf (fp, "%d", num % 10);
		}
	}

	fprintf (fp, "\n");

	fprintf (fp, "     ");
	for (j = x1, nr = 0; nr < width; nr ++, j ++)
	{
		j = EX (j);
		num = ABS (j);
		fprintf (fp, "%d", num % 10);
	}

	fprintf (fp, "\n");
}

static char let_assigned;

static void InitCountryLet (clets)
char *clets;
{
	int i;

	for (i = 0; i < MAX_NATIONS; i++)
		clets[i] = '\0';

	let_assigned = 'A';
}

static char GiveCountryLet (nr, clets)
int nr;
char *clets;
{
	static char others[] = "#$%&*!+=_-<>/\\~()^;:,\"'[]{}|`@"; /* 30 */

	if (nr < 0)
		return '?';

	if (clets[nr] != '\0')
		return clets[nr];

	clets[nr] = let_assigned < 30 ? others[let_assigned] : let_assigned;

	if (let_assigned == 'Z')
		let_assigned = 'a';
	else if (let_assigned == 'z')
		let_assigned = '0';
	else if (let_assigned == '9')
		let_assigned = 0;
	else
		let_assigned ++;

	return clets[nr];
}

bool SaveMap (file, flag, x1, x2, y1, y2)
const char *file;
int flag;
int x1, x2, y1, y2;
{
	int i, j;
	FILE *fp, *fopen ();
	Sector sct;
	char **buffer;
	int width, length;
	char clets[MAX_NATIONS];
	bool append, force;
	extern char *sys_errlist[];

	append = force = False;
	SkipBlank (&file);
	if (*file == '>')
	{
		append = True;
		file++;
	}
	else if (*file == '!')
	{
		force = True;
		file++;
	}
		
	file = FileStr (file);

	if (access (file, W_OK) < 0) {
		if (errno != ENOENT || append)
		{
			Error (Fmt ("Can't open file %s for writing : %s", file,
				sys_errlist [errno]));
			return False;
		}
	}
	else if (! force && ! append)
	{
		Error (Fmt ("file %s exists", file));
		return False;
	}

	fp = fopen (file, append ? "a" : "w");

	if (fp == (FILE *) 0)
	{
		Error (Fmt ("Can't open file %s for writing : %s", file,
			sys_errlist [errno]));
		return False;
	}

	width = XDIST (x1, x2) + 1;
	length = YDIST (y1, y2) + 1;

	fprintf (fp, "Dimensions : %dx%d\n\n", width, length);

	buffer = (char **) doalloc ((unsigned) length * sizeof (char *));

	InitCountryLet (clets);
	for (i = 0; i < length; i++)
	{
		buffer [i] = (char *) doalloc ((unsigned) width + 1);

		for (j = 0; j < width; j++)
		{
			sct = World (j + x1, i + y1, S_EXIST);
			if (sct == (Sector) 0 || NO_INFO (sct))
				buffer [i][j] = ' ' ;
			else if (flag & W_DES || index ("-.^s\\", s_des (sct)))
				buffer [i][j] = s_des (sct);
			else if (flag & W_COUN)
			       buffer [i][j] =
					GiveCountryLet (s_owner (sct), clets);
			else 
				buffer [i][j] = '?';
		}

		buffer[i][j] = '\0';
	}

	if (flag & W_COORD) Xy (fp, x1, x2, width);

	for (i = 0; i < length; i++)
	{
		if (flag & W_COORD)
			fprintf (fp, "%4d %s %-4d\n", EX (i + y1), buffer [i],
				 EX (i + y1));
		else
			fprintf (fp, "%s\n", buffer [i]);

		free (buffer[i]);
	}

	free (buffer);

	if (flag & W_COORD)
		Xy (fp, x1, x2, width);

	if (flag & W_COUN)
	{
		fprintf (fp, "\n\n");
		for (i = 0; i < MAX_NATIONS; i++) 
			if (clets[i] != '\0')
				fprintf (fp, "%c = %s\n", clets[i],
							  CountryName (i));
	}

	fclose (fp);
	Message ("Map saved");

	return True;
}

void GotoSct ()
{
	char *answer;
	Sector sct;
	int x, y, xdist, ydist;

	answer = InputAtMessage ("Goto sector :", 8, GS_SECTOR);

	if (interrupt || answer == (char *) 0 || *answer == '\0')
	{
		interrupt = False;
		Message ("Goto cancelled");
		return;
	}

	if (sscanf (answer, "%d%*[ 	,]%d", &x, &y) != 2)
	{
		Message ("Bad coordinates");
		Bell ();
		return;
	}

	sct = World (x, y, S_EXIST);

	if (sct == (Sector) 0 || NO_INFO (sct))
	{
		if (! deity)
		{
			Message (Fmt ("No info on sector %d, %d", x, y));
			Bell ();
			return;
		}
		else
		{
			sct = World (x, y, S_DESIG);
			DeityChange (sct);
		}
	}

	Goto (sct);
}

const char * FileStr (file)
const char * file;
{
	static char filename[128];

	if (file == (char *) 0)
		return file;

	SkipBlank (& file);

	if (file [0] == '~' && file [1] == '/')
	{
		sprintf (filename, "%s%s", getenv ("HOME"), file + 1);
		return filename;
	}

	return file;
}

#ifdef X_VERSION
void ConvMapPosToPixelPos (px, py)
int * px, * py;
{
	if (* px < firstx)
		* px =  -1;
	else if (* px > nr_width + firstx)
		* px =  WinWidth (map_win) + 2;
	else
		if (! double_displ)
			* px = CharToPixelX (XDIST (firstx, * px));
		else
			* px = CharToPixelX (2 * XDIST (firstx, * px));

	if (* py < firsty)
		* py = -1;
	else if (* py > nr_height + firsty)
		* py = WinHeight (map_win) + 2;
	else
		* py = CharToPixelY (YDIST (firsty, * py));
}

int MapSctWidth ()
{
	if (double_displ)
		return CharToPixelX (2);
	else
		return CharToPixelX (1);
}

int MapSctHeight ()
{
	return CharToPixelY (1);
}

#endif /* X_VERSION */
