/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/main.c,v 5.5 1995/09/21 07:41:33 jpo Exp jpo $
    $Date: 1995/09/21 07:41:33 $
    $Author: jpo $
    $Id: main.c,v 5.5 1995/09/21 07:41:33 jpo Exp jpo $
    $Locker: jpo $
    $Log: main.c,v $
    Revision 5.5  1995/09/21 07:41:33  jpo
    Reorder break sanctuary stuff

    Revision 5.4  1995/09/20 07:51:12  jpo
    Change so you can leave passwd/country blank in .xemprc for
    one country.

    Revision 5.3  1995/09/19 06:50:21  jpo
    Added some bits for later

    Revision 5.2  1995/09/08 07:29:02  jpo
    const

 * Revision 5.1  93/03/14  16:49:24  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "xrc.h"
#include "sector.h"
#include "nation.h"
#include "version.h"

#ifdef X_VERSION

#define	OPTIONS		"DZz:BFRS:NTsu:t:E:M:C:l:h:p:f:b:rm:nW:12345"

#else /* TERMC_VERSION */

#define	OPTIONS		"c:DZz:BFRS:NTsu:t:M:C:l:h:p:rm:nW:E:12345"

#endif /* VERSION */

bool reversed = False;
bool deity = False;
bool util_mode = False;
bool silent_mode;
bool bbn_version = False;
bool chainsaw_version = False;
bool land_units = False;
bool other_version = False;
bool market = False;
bool budget = True;
bool trade = False;
bool connecting = False;
bool bold_is_reversed = False;
bool deity_mode = False;
#ifdef KSU
bool ksu_version = True;
#else
bool ksu_version = False;
#endif
bool emp3server = False;
int savedbits;

XRC xrc;
/* mta Sun Jan  6 19:24:29 EET 1991 
 * no food on blitz games, see how it works
 */
bool no_food = False;
int nr_realms = NR_REALMS;

bool tersemode = False;
bool no_empwin;

Sector **world;
Sector cursct;
Ship curship;
Land curland;
Plane curplane;
Nuke curnuke;
int curnuketype;
char curwing;
char *host;
int command_state;
int scanning_satellites = 0; /* kludge to make satellite's work */

int max_mil = MAX_MIL;
int max_comm = MAX_COMM;
int max_civ_uw = MAX_CIV_UW;

int MAX_X = DEF_MAX_X, MAX_Y = DEF_MAX_Y;

char *mappart = "#", *allships = "*", * allplanes = "*", * dumppart, * alllands = "*";
char *offset_country;
WinInfo root_win;

void SaveTillPrompt ();
void PrintSaved ();

static void Usage ()
{
	fprintf (stderr, "Usage : %s options country name\n", progname);
	fprintf (stderr, "Options :\n");
	fprintf (stderr, "-Z (no starve checking, mainly used in BlitZ)\n");
	fprintf (stderr, "-z realms (number of realms if not default)\n");
	fprintf (stderr, "-M NxM (mapwindow size)\n");
	fprintf (stderr, "-E NxM (empirewindow size)\n");
	fprintf (stderr, "-l logfile\n");
	fprintf (stderr, "-h host\n");
	fprintf (stderr, "-p port\n");
	fprintf (stderr, "-R reverse highlighted sectors\n");
	fprintf (stderr, "-m mappart (used in initial scan)\n");
	fprintf (stderr, "-n (nodump lookout, coastwatch)\n");
	fprintf (stderr, "-N (Make No connection)\n");
	fprintf (stderr, "-B (buffer commands)\n");
	fprintf (stderr, "-F (force buffering of commands)\n");
	fprintf (stderr, "-t connect timeout\n");
	fprintf (stderr, "-S savelines\n");
	fprintf (stderr, "-u util\n");
	fprintf (stderr, "-T (silent connect after timeout)\n");
	fprintf (stderr, "-W NxM (worldsize)\n");
	fprintf (stderr, "-C country (deity only)\n");

#ifdef X_VERSION

	fprintf (stderr, "\nX options:\n\n");
	fprintf (stderr, "-f normal font\n");
	fprintf (stderr, "-b bold   font\n");

#else /* TERMC_VERSION */
	
	fprintf (stderr, "\nTermcap options:\n\n");
	fprintf (stderr, "-c capabilities\n");
	fprintf (stderr, "-E (no empire window)\n");

#endif /* VERSION */
	exit (1);
}

void main (argc, argv)
int argc;
char **argv;
{
	char * ptr;
	int ch; 
	char *empsize;
	char *mapsize;
	char *font, *bfont;
	char *port;
	char *logfile;
	char *util;
	bool nodump = False;
	int map_inc_height = 0;
	int map_inc_width = 0;
	int emp_inc_height = 0;
	bool retrieved, bin_dump_only;
	int i;
	int N, M;
	int tobe_state;
	bool cont;
	char * ans;
	int savelines;

#ifdef TERMC_VERSION

	char * hs1 = (char *) 0,
	     * he1 = (char *) 0,
	     * hs2 = (char *) 0,
	     * he2 = (char *) 0;

	static char hl_buf [4][10];

#endif TERMC_VERSION

	int skip;

	extern int optind, getopt ();
	extern char *optarg;
	extern unsigned con_timeout;
	extern bool silent_con;
	extern bool buffer_commands;
	extern bool buffer_move;

	srand (getpid ());	/* for the updates */

		/* Search country name */
		/* Incorrect, but it will work (I hope) */

	skip = False;
	for (i = 1; i < argc; i ++)
	{
		if (argv [i][0] != '-')
		{
			if (! skip)
			{
				cname = argv [i];
				break;
			}
			skip = False;
		}
		else
		{
			skip = False;
			ptr = index (OPTIONS, argv [i][1]);
			if (ptr == (char *) 0)
				continue;
		
			if (* (ptr + 1) == ':')
				skip = True;
		}
	}


	ReadRc ();
	progname = argv[0];
	connecting = False;
	pname = xrc. player;
	if (xrc. country != (char *) 0)
		cname = xrc. country;
	bin_dump_only = False;
	empsize = xrc. emp_win_size;
	mapsize = xrc. map_win_size;
	offset_country = (char *) 0;
	font = xrc. normal_font;
	bfont = xrc. bold_font;
	logfile = (char *) 0;
	host = xrc. host;
	port = xrc. port;
	util = (char *) 0;
	silent_mode = xrc. silent_timeout;
	reversed = 0;
	command_state = STARTUP_STATE;
	tobe_state = xrc. buffering;
	con_timeout = xrc. timeout;
	savelines = xrc. savelines == (char *) 0 ? EMPIRE_SAVEL 
						 : atoi (xrc. savelines);
	no_empwin = False;

	
#ifdef TERMC_VERSION

	if (xrc. capab != (char *) 0)
	{
		if (sscanf (xrc. capab, "%[^:]:%[^:]:%[^:]:%[^:]",
			hl_buf [0], hl_buf [1], hl_buf [2], hl_buf [3]) != 4)
		{
			fprintf (stderr, "Error in .xemprc\n");
			fprintf (stderr, "Wrong format for capabilities.\n");
			fprintf (stderr, "Usage: Capab=cc:cc:cc:cc\n");
			exit (-1);
		}

		hs1 = hl_buf [0];
		he1 = hl_buf [1];
		hs2 = hl_buf [2];
		he2 = hl_buf [3];
	}

#endif /* TERMC_VERSION */

	if (xrc. worldsize != (char *) 0)
	{
		if (sscanf (xrc. worldsize, "%d x %d", & N, & M) != 2)
		{
			fprintf (stderr, "Usage: WORLDSIZE= # x #\n");
			exit ();
		}
		MAX_X = N, MAX_Y = M;
	}

	init_opt (argc, argv);
	while ((ch = next_opt ()) != '\0')
		switch (ch)
		{

		case 'Z':
			no_food = True;
			break;

		case 'z':
			nr_realms = atoi(next_arg ());
			break;

		case 'M':
			mapsize = next_arg ();
			break;

		case 'l':	/* logfile */
			logfile = next_arg ();
			break;

		case 'h':
			host = next_arg ();
			break;

		case '1':
			ksu_version = True;
			other_version = False;
			bbn_version = True;
			chainsaw_version = False;
			fprintf(stderr,"KSU/BBN Enabled!\n");
			break;

		case '2':
			bbn_version = True;
			other_version = False;
			ksu_version = True;
			chainsaw_version = False;
			fprintf(stderr,"KSU/BBN Enabled!\n");
			break;

		case '3':
			chainsaw_version = True;
			other_version = False;
			bbn_version = True;
			ksu_version = True;
			fprintf(stderr,"KSU/BBN/Chainsaw Enabled!\n");
			break;

		case '4':
			other_version = True;
			chainsaw_version = False;
			bbn_version = True;
			ksu_version = True;
			fprintf(stderr,"KSU/BBN/ALBERTA Enabled!\n");
			break;

		case '5':
			chainsaw_version = True;
			land_units = True;
			other_version = False;
			bbn_version = True;
			ksu_version = True;
			fprintf(stderr,"Chainsaw Land Units Enabled!\n");
			break;

		case 'p':
			port = next_arg ();
			break;

#ifdef X_VERSION

		case 'b':	/* bold font */
			bfont = next_arg ();
			break;

		case 'f':	/* normal font */
			font = next_arg ();
			break;

		case 'E':
			empsize = next_arg ();
			break;

#endif /* X_VERSION */

		case 'm':
			mappart = next_arg ();
			break;

		case 'r':
			reversed = True;
			break;

#ifdef TERMC_VERSION

		case 'E':
			no_empwin = True;
			break;
			
		case 'c':
			if (sscanf (next_arg (), "%[^:]:%[^:]:%[^:]:%[^:]",
					hl_buf [0], hl_buf [1],
					hl_buf [2], hl_buf [3]) != 4)
			{
				fprintf (stderr,
					"Wrong format for capabilities.\n");
				fprintf (stderr, 
					"Usage: -c \"s:s:s:s\"\n");
				exit (-1);
			}

			hs1 = hl_buf [0];
			he1 = hl_buf [1];
			hs2 = hl_buf [2];
			he2 = hl_buf [3];
			break;

#endif /* TERMC_VERSION */

		case 'R':
			bold_is_reversed = True;
			break;

		case 'n':
			nodump = True;
			break;

		case 'N':
			bin_dump_only = True;
			break;

		case 'T':
			silent_con = True;
			break;

		case 'S':
			savelines = atoi (next_arg ());
			if (savelines < 0)
			{
				fprintf (stderr, "-S savelines must be >= 0\n");
				Usage ();
			}

			break;

		case 't':
			con_timeout = atoi (next_arg ());
			break;

		case 'u':
			util_mode = True;
			util = next_arg ();
			break;

		case 'C':
			offset_country = next_arg ();
			break;

		case 'B':
			tobe_state = BUFFER_STATE;
			break;

		case 'F':
			tobe_state = FORCE_BUF_STATE;
			break;

		case 'D':
			deity_mode = True;
			break;

		case 'W':
			ptr = next_arg ();
			if (! ScanDigit ((ConstVP)& ptr, &N) || * ptr ++ != 'x' ||
			    ! ScanDigit ((ConstVP)& ptr, &M))
				Usage ();
			MAX_X = N, MAX_Y = M;
			break;

		default:
			Usage ();
			/* NOTREACHED */
			break;
		}

	if (MAX_X % 2 == 1 || MAX_Y % 2 == 1)
	{
	    fprintf (stderr, "Bad Worldsize specified : %dx%d\n", MAX_X, MAX_Y);
	    fprintf (stderr, "Must be multiple of 2\n");
	    Usage ();
	}

		/* XXX: Need to check this !!! */

	if (cname == (char *) 0 || *cname == '\0')
		cname = check_arg ();
	if (pname == (char *) 0 || *pname == '\0')
		pname = check_arg ();

/* Greyhelm - re-write of Scan for Version to make it get WorldSize from
              game ... so players do not have to worry about the size. */
/* Etienne - yep, but only if we want to connect, else dont. should add
              something, to get worldsize from savefile then (or always, will
              give you some problems, if this does not correspnd */

	if (! InitClient (host, port, logfile))
		exit (1);

	if (! bin_dump_only) {

		connecting = True;
		if (! HostConnect () || ! Login ())
			FastQuit ();

		SaveTillPrompt ();
		connecting = False;

		FScanVersion ();
		FScanCommandlist ();

	}

		/*
		 *	Parse the argument of -M
		 */

	if (mapsize != (char *) 0)
	{
		printf ("Parsing the argument of '-M'\n");

		ptr = mapsize;

		if (*ptr == '-' || *ptr == '+')
		{
			ptr ++;
			if (! ScanDigit ((ConstVP)& ptr, & map_inc_height))
			{
				fprintf (stderr, "%s%s\n",
					"Illegal map format, ",
					"usage -M [+-]width x [+-]height");
				Usage ();
			}
		}
		else
		{
			(void) ScanDigit ((ConstVP)& ptr, & map_inc_height);
			map_inc_height -= MAP_HEIGHT;
		}

		if (MAP_HEIGHT + map_inc_height < MAP_HEIGHT)
		{
			fprintf (stderr, "%s%d high.\n",
				"MapWindow too small, should be at least ",
				CENSUS_HEIGHT);
			exit (1);
		}

		if (*(ptr ++) != 'x')
		{
			fprintf (stderr, "Illegal map format, %s\n",
				"usage -M [+-]width x [+-]height");
			Usage ();
		}

		if (*ptr == '-' || *ptr == '+')
		{
			ptr ++;
			(void) ScanDigit ((ConstVP)& ptr, & map_inc_width);
		}
		else
		{
			(void) ScanDigit ((ConstVP)& ptr, & map_inc_width);
			map_inc_width -= MAP_WIDTH;
		}

		/* don't allow map window to exceed world size!! */
		if ( map_inc_width + MAP_WIDTH > MAX_X )
			map_inc_width = MAX_X + 4 - MAP_WIDTH;
		if ( map_inc_height + MAP_HEIGHT > MAX_Y )
			map_inc_height = MAX_Y +4 - MAP_HEIGHT;
	}

		/*
		 *	Parse the argument of -E
		 */

	if (empsize != (char *) 0)
	{
		/* printf ("Parsing the argument of '-E'\n"); */

		ptr = empsize;

		if (*ptr == '-' || *ptr == '+') 
		{
			ptr ++;
			(void) ScanDigit ((ConstVP)& ptr, & emp_inc_height);
		}
		else
		{
			(void) ScanDigit ((ConstVP)& ptr, & emp_inc_height);
			emp_inc_height -= EMPIRE_HEIGHT;
		}
	}

	world = MallocWorld ();
	cursct = World (0, 0, S_DESIG);

#ifdef  X_VERSION
	if ((host == NULL) && (getenv("EMPIREHOST"))) {
		host = getenv("EMPIREHOST");
	} else {
		if (host == NULL)
			host = EMPIREHOST; 
	}
	sprintf(windowname,"xemp %s@%s",cname,host);
#endif

	if (! bin_dump_only)
	{

		/* dump 0,0 to see if you are deity or not */
		/* besides, cursct is set to 0,0 you want info on it
		 * any way (except it might be dump twice now
		 */

		(void) FScanDump ("0,0", DONT_PRINT);
	}

	SetSignalsOn ();

		/* erase, kill & interrupt char */

	GetSpecialChars ();

	if (! util_mode)
	{
#ifdef X_VERSION
		/* 
		 *	initialize the X-server with the fonts (normal & bold)
		 */

		InitX (font, bfont);
#else
		InitTermc (hs1, he1, hs2, he2);
#endif

		root_win = OpenBaseWindow (xrc. startup_x,
					   xrc. startup_y,
					   ROOT_WIDTH + map_inc_width,
					   ROOT_HEIGHT + map_inc_height +
					   emp_inc_height);


		InitEmpire (map_inc_height, map_inc_width,
						emp_inc_height, savelines);
		InitMap (map_inc_width, map_inc_height);
		SetDefaultCursor (root_win, CR_HJV);

		InitMessage (map_inc_width);
		InitCensus ();
		ShowVersion ();
		WaitRefresh (False);
		CheckRefreshEvents ();
	}

	if (! bin_dump_only)
	{
		FeedEmpire ("", DONT_PRINT);
		(void) WaitForPrompt (PRINT);
	}

	InitNation ();

		/*
		 *	As god, you can use the offset (-C) option
		 *	to start with your coordinates as a certain country.
		 */

	if (offset_country != (char *) 0)
	{
		if (! SetOffset (offset_country))
			offset_country = (char *) 0;
	}

	if (offset_country == (char *) 0)
	{

		/*
		 *	Try to retrieve the data. When there's no data-file,
		 *	the country could be still in sanctury. Check that
		 *	first, after that, initialize.
		 */

		retrieved = RetrieveData (bin_dump_only);
	} else
		retrieved = False;

	if (! retrieved && bin_dump_only)
	{
		fprintf (stderr, "No/Bad savefile, for -N\n");
		leave ();
	}

	BinRestAll ();

	if (BufferdCommands ())
	{
		cont = True;

		do {
			interrupt = False;

			ans = InputAtMessage (
			  "You still have buffered commands, keep them [yns]: ",
			  1, "yns");

			if (ans == (char *) 0 || interrupt || * ans == '\0')
				Bell ();
			else if (* ans == 's')
				ShowBufCommands (10, 10);
			else
				cont = False;
		} while (cont);

		if (* ans == 'n')
			DeleteBufCommands ();
	}

	if (! bin_dump_only)
	{
		FeedBufCommands ();

		if (! retrieved || ver_max_x == 0)
		{
			FeedEmpire ("", DONT_PRINT);
			(void) WaitForPrompt (PRINT);
			FScanBuildBridge ();
		}

		if (ver_max_x != MAX_X || ver_max_y != MAX_Y) {
			fprintf (stderr, "%s %dx%d instead of %dx%d\n",
				"Version reports worldsize of",
				ver_max_x, ver_max_y, MAX_X, MAX_Y);

			fprintf (stderr, "Restart : %s -W %dx%d\n", progname,
				 ver_max_x, ver_max_y);
			leave ();
		}

		if (my_cnum == UNKNOWN_CNUM)
		{
			if (deity_mode)
				my_cnum = 0;
			else
				FindMyCnum ();
		}

		if (offset_country != (char *) 0) {
			dumppart = Fmt ("%s ?own=%d", mappart,
						CountryId (offset_country));
			dumppart = Str (dumppart);
			allships = Fmt ("* ?own=%d",
						CountryId (offset_country));
			allships = Str (allships);
			allplanes = Str (Fmt ("* ?own=%d",
						CountryId (offset_country)));
			if(land_units) {
				alllands = Fmt ("* ?own=%d",
						CountryId (offset_country));
				alllands = Str (alllands);
			}
		} else if (deity) {
			dumppart = Fmt ("%s ?des#.", mappart);
			dumppart = Str (dumppart);
		} else
			dumppart = Str (mappart);

		FScanMap (mappart, PRINT);

		(void) FScanDump (dumppart, PRINT);

	}

	if (! util_mode)
		EndVersion ();

	if (s_des (cursct) == 's' && ! deity)
	{
		if (util_mode || bin_dump_only)
		{
			fprintf (stderr, "Break sanctury first !\n");
			leave ();
		}

		DrawMap ();

		ptr = InputAtMessage ("Break sanctury ? ", 3, "yn");
		if (*ptr != 'y')
		{
			Message ("Break sanctury first");
			leave ();
		}

		FeedEmpire ("break sanctury", PRINT);
		(void) WaitForPrompt (PRINT);

		FeedEmpire ("realm 0 -20:20,-8:8", PRINT);
		(void) WaitForPrompt (PRINT);
		NationSetRealm (0, "-20:20,-8:8");

		(void) FScanDump (dumppart, PRINT);
	}

	if (! bin_dump_only)
	{
		if (! retrieved || xrc. rescan_show)
		{
			if (! nodump)
			{
				FScanShowShipBuild ();
				FScanShowShipCap (); 

				if (land_units) {
					FScanShowLandBuild();
					FScanShowLandStats();
					FScanShowLandCap();
				}

				FScanShowPlaneBuild ();
				FScanShowPlaneCap ();
				FScanNukeShowBuild ();
				FScanNukeShowCap ();
			}
			if (! retrieved)
			{
				InitHighlight ();
				InitPlanOptions ();
			}
		}
		
		CheckDump ();

		(void) DumpShips (allships, PRINT);

		FeedEmpire ("", DONT_PRINT);
		(void) WaitForPrompt (PRINT);

		(void) DumpPlanes (allplanes, PRINT);

		if (land_units) {
			(void) DumpLand (alllands, PRINT);
			FeedEmpire ("", DONT_PRINT);
			(void) WaitForPrompt (PRINT);
		}

		(void) FScanNukes ("*", DONT_PRINT);

		if (! nodump)
		{
			MarkShips (dumppart);
			if (xrc. rescan_lookout)
				FScanLookout (allships);
				if (land_units)
					FScanLLookout ("*");
			if (xrc. rescan_coastwatch)
				FScanCoastWatch (dumppart);
			if (xrc. rescan_satellite)
				FeedSatellite ();
			if (xrc. rescan_land_radar)
				FScanRadar (dumppart);
			if (xrc. rescan_ship_radar)
				FeedRadarShips ();
			if (xrc. rescan_sonar)
			{
				FeedEmpire (Fmt ("sonar %s", dumppart), PRINT);
				ScanLookout ();
			}
			DeleteMarkedEnemyShips (); 
			UnmarkAllShips();

			if (util == (char *) 0) {
				FeedEmpire ("", DONT_PRINT);
				(void) WaitForPrompt (PRINT);
				FScanReadTels ();
				if(EMPOption(WIRE)) {
					FeedEmpire ("", DONT_PRINT);
					(void) WaitForPrompt (PRINT);
					FScanReadWirs ();
				}
			}
		}
/* read stats from latest production mta Sat Mar 16 16:25:00 EET 1991 */
		ReadProduction("-"); 

		FeedEmpire ("", DONT_PRINT);
		(void) WaitForPrompt (PRINT);
		FScanNation ();
		PrintSaved ();

		FeedEmpire ("", DONT_PRINT);
		(void) WaitForPrompt (PRINT);
	}


	if (offset_country == (char *) 0)
		save_data = True;

	inc_mar (cursct);	/* can't use SetCurrent */

	command_state = tobe_state;

	if (! util_mode)
	{
		Census ();

		DrawMap ();

		ResetConTimeout ();
		MainLoop ();
	}
	else
	{
			/*
			 *	Don't buffer commands when running a 
			 *	utility
			 */

		command_state = NORMAL_STATE;

		if (strncmp (util, "ferry", 5) == 0)
		{
			DoFerryUtil (util + 5);
		}
		else if (strncmp (util, "check", 5) == 0)
		{
			Check ();
		}
		else if (strncmp (util, "ve", 2) == 0)
		{
			VeUtil ((char *) 0);
		}
		else if (strncmp (util, "prog:", 5) == 0)
		{
			UtilRunProg (util + 5);
		}
		else if (strncmp (util, "plan", 4) == 0)
		{
			UtilPlan (util + 4);
		}
		else
		{
			fprintf (stderr, "Illegal utility\n");
			fprintf (stderr, "\tferry [all|#]\n");
			fprintf (stderr, "\tcheckn");
			fprintf (stderr, "\tprog:file[:realm]\n");
			fprintf (stderr, "\tplan[:sector]\n");
		}
	}

	leave ();
}

void AbortClient (flag)
int flag;
{
	extern bool disconnecting;

	if (EmpireStatus () == E_DEAD)
	{
		if (disconnecting)
			return;
		else
			leave0 ();
	}

	while (EmpireStatus () != E_COMMAND)
	{
		FeedEmpire ("aborted", flag);
		(void) WaitForPrompt (flag);
	}
		
	FeedEmpire ("quit", flag);
	(void) WaitForPrompt (flag);
}

void leave ()
{
	NoConTimeout ();
	AbortClient (PRINT);
	leave0 ();
	/* NOT REACHED */
}

void leave0 ()
{
	extern bool dump_core;

	NoConTimeout ();
	SetSignalsOff ();
	CloseConnection ();
	if (save_data)
		StoreData ();
#ifdef TERMC_VERSION
	QuitTermc ();
#else /* TERMC_VERSION */
	QuitX ();
#endif /* TERMC_VERSION */
	if (dump_core)
		abort ();
	else
		exit (0);
}

static char *newsbuf[50];

void SaveTillPrompt ()
{
	extern WinInfo empire_win;
	char *ptr;
	int nlines = 0;
	static bool first_time = True;

	nlines = 0;
	for (;;)
	{
		ptr = ReadEmpire (DONT_PRINT);
		if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		{
			newsbuf [nlines] = (char *) 0;
			first_time = False;
			return;
		}

		if (ptr == (char *) 0) continue;
		if (! first_time && IsEmpireMessage (ptr))
			PrintAtEmpire (ptr);
		newsbuf [nlines] = Str (ptr);
		nlines++;
	}
}

void PrintSaved ()
{
	int nr = 0;
	bool noprint = False;

	for (nr = 0; newsbuf [nr] != (char *) 0; nr++)
	{
		if (connecting)
			fprintf (stderr, "%s\n", newsbuf [nr]);
		else
		{
			if (! noprint)
				PrintAtEmpire (newsbuf [nr]);

			if (! noprint &&
				nr % (EMPIRE_HEIGHT - 2) == (EMPIRE_HEIGHT - 1))
			{
				if (!EmpireMore ())
					noprint = True;
			}

		}
		free (newsbuf[nr]);
	}
}
