/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/highl.c,v 5.2 1995/09/08 07:27:57 jpo Exp $
    $Date: 1995/09/08 07:27:57 $
    $Author: jpo $
    $Id: highl.c,v 5.2 1995/09/08 07:27:57 jpo Exp $
    $Locker:  $
    $Log: highl.c,v $
    Revision 5.2  1995/09/08 07:27:57  jpo
    added new temporary highlight command
    redone the default ones so they make sense

 * Revision 5.1  93/03/14  16:49:19  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "func.h"
#include "var.h"
#include "ship.h"
#include "parser.h"

#define NR_HIGHLSTR	10

static const char *highl_str [NR_HIGHLSTR];

static Stack cur_highl;

void InitHighlight ()
{
	highl_str [0] = Str ("threshold(food) == 0 && des=w");
	highl_str [1] = Str ("t(food) == 0");
	highl_str [2] = Str ("iron > 1");
	highl_str [3] = Str ("food < 25");
	highl_str [4] = Str ("r(oil) > 20");
	highl_str [5] = Str ("lcm > 1");
	highl_str [6] = Str ("hcm > 1");
	highl_str [7] = Str ("resource(dust) > 20");
	highl_str [8] = Str ("r(iron) > 80");
	highl_str [9] = Str ("r(ura) > 20  ; Nuke 'em all to death!");

	cur_highl = (Stack) 0;
}

void ReadHighlight (fp)
FILE *fp;
{
	char buffer [BUFSIZ];
	int i;

	for (i = 0; ; i++)
		if (fgets (buffer, BUFSIZ, fp) != (char *) 0)
		{
			if (strncmp (buffer, "END OF HIGHLIGHT LIST", 21) == 0)
				break;

			buffer [strlen (buffer) - 1] = '\0';	/* no newline */

			if (i < NR_HIGHLSTR) {
				if (highl_str [i] != (char *) 0)
					free (highl_str [i]);
				highl_str [i] = Str (buffer);
			}
		}
		else
			break;
	
	while (i < NR_HIGHLSTR)
		if (highl_str [i] == (char *) 0)
			highl_str[i++] = Str ("");

	cur_highl = (Stack) 0;
}

void SaveHighlight (fp)
FILE *fp;
{
	int i;

	for (i = 0; i < NR_HIGHLSTR; i++)
		fprintf (fp, "%s\n", highl_str [i]);

	fprintf (fp, "END OF HIGHLIGHT LIST\n");
}

bool HighlightSector (sct)
Sector sct;
{
	if (cur_highl == (Stack) 0)
		return False;
	
	return EvaluateExpression (sct, cur_highl) != 0.0;
}

#ifdef TERMC_VERSION

#define		HL_MAX_X	70

#else	/* X_VERSION */

#define		HL_MAX_X	80

#endif 	/* VERSION */
void SetHighlight ()
{
	Strings strings;
	Pager pager;

	int i;
	Stack tmp;
	int func;
	char *new;
	extern WinInfo empire_win;

	strings = InitStrings ();
	AddStringsID (strings, (ConstVP)highl_str, NR_HIGHLSTR, 0);
	pager = InitPager (strings, Fmt ("%-*.*s", HL_MAX_X - 4, HL_MAX_X - 4,
				"New highlight ?"));

	AddPagerFunc (pager, "No highlight", NONEFUNC);
	AddPagerFunc (pager, "Write", WRITEFUNC);
	SetPagerButtons (pager, "Select", "Cancel", "Change");
	SetPagerButtonIDs (pager, DEFAULTFUNC, DONEFUNC, NEWFUNC);

#ifdef TERMC_VERSION

	MapPagerFromTop (pager, census_win, 3, screen_rows - 4);

#else /* X_VERSION */

	MapPagerFromTop (pager, empire_win, 0, 0);

#endif /* VERSION */

	for (;;)
	{
		i = PagerMenuFunc (pager, & func, (int *) 0);

		if (i < 0 || func == NONEFUNC ||
				func == DONEFUNC || func == CANCEL)
			break;

		if (func == NEWFUNC)	 /* change highlight */
		{
			do {
				new = InputPagerLine (pager, i);
				if (interrupt)
				{
					interrupt = False;
					FreePager (pager);
					FreeStrings (strings);
					return;
				}

				if (new == (char *) 0 || *new == '\0') 
					break;

				tmp = ParseExpression (new);

			} while (tmp == (Stack) 0);

			if (new == (char *) 0 || *new == '\0') 
			{
				ShowPagerLine (pager, i);
				continue;
			}
			else
			{
				free (highl_str [i]);
				highl_str [i] = Str (new);
			}
		}

		break;
	}

	FreePager (pager);
	FreeStrings (strings);

	if (func == NONEFUNC)
		DestroyExpression (& cur_highl);
	else if (i >= 0 && func != DONEFUNC && func != CANCEL)
	{
		tmp = ParseExpression (highl_str [i]);

		if (tmp != (Stack) 0)
		{
			DestroyExpression (& cur_highl);
			cur_highl = tmp;
		}
	}

	DrawMap ();
}

void ExprHighlight (expr)
Stack expr;
{
	if (expr != (Stack) 0)
	{
		DestroyExpression (& cur_highl);
		cur_highl = expr;
	}
}
