/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/land/RCS/army.c,v 5.2 1995/09/08 07:18:06 jpo Exp $
    $Date: 1995/09/08 07:18:06 $
    $Author: jpo $
    $Id: army.c,v 5.2 1995/09/08 07:18:06 jpo Exp $
    $Locker:  $
    $Log: army.c,v $
    Revision 5.2  1995/09/08 07:18:06  jpo
    better land cycle

 * Revision 5.1  93/03/14  16:47:08  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "census.h"
#include "var.h"
#include "land.h"
#include "sector.h"


	/*
	 *	# maximum # of lands thta fits at the census screen
	 */

#define MAX_CEN_LANDS	50


char curarmy = '\0';

char GiveNextArmyInSct (sct, army)
Sector sct;
char army;
{
	char next;
	Land land;

	next = 0177;

	for (land = s_fland (sct); land != (Land) 0; land = ld_nxtsct (land))
		if (ld_army (land) < next && ld_army (land) > army)
			next = ld_army (land);

	if (next < 0177)
		return next;
	
	return '\0';
}

int ArmyMinMob (army)
char army;
{
	Land ptr;
	int min_mob;

	min_mob = MAX_LANDMOB;

	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army && ptr-> mob < min_mob)
			min_mob = ptr-> mob;
	
	return min_mob;
}

bool ArmyEmpty (army)
char army;
{
	Land ptr;

	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army)
			return False;

	return True;
}

bool ArmyColocated (army)
char army;
{
	bool found;
	int x, y;
	Land ptr;

	found = False;

	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army)
			if (! found)
			{
				x = ptr-> x;
				y = ptr-> y;
				found = True;
			}
			else
			{
				if (x != ptr-> x || y != ptr-> y)
					return False;
			}

	return True;
}

long LandNrAbils (landnr)
int landnr;
{
	Land land;

	land = NrToLand (landnr);

	if (land == (Land) 0)
		return 0L;
	else
		return landtypes [land-> type]. flags;
}

long ArmyAbils (army)
char army;
{
	long abils;
	Land ptr;

	abils = 0L;


	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army)
			abils |= landtypes [ptr-> type]. flags;
	
	return abils;
}

Sector ArmySector (army)
char army;
{
	Land ptr;

	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army)
			return World (ptr-> x, ptr-> y, S_DESIG);
	
	return (Sector) 0;
}

void MoveArmy (army, sct)
char army;
Sector sct;
{
	Land ptr;

	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army)
			MoveLand (ptr, sct);
}

char FirstArmyInSct (sct)
Sector sct;
{
	if (s_fland (sct) == (Land) 0)
		return '\0';
	else
		return ld_army (s_fland (sct));
}

char * ArmyId ()
{
	bool first;
	static char buffer [1024];
	Land ptr;

	if (! ArmyColocated (curarmy))
	{
		buffer [0] = '\0';
		first = True;

		for (ptr = s_fland (cursct); ptr != (Land) 0;
							ptr = ld_nxtsct (ptr))
			if (ld_army (ptr) == curarmy)
			{
				if (first)
					first = False;
				else
					strcat (buffer, "/");
				
				strcat (buffer, Fmt ("%d", ld_nr (ptr)));
			}
		
		return buffer;
	}
	else
		return Fmt ("%c", curarmy);
}

static void CalcFreeArmys (upper, lower)
bool upper [], lower [];
{
	Land ptr;
	register i;

	for (i = 0; i < 26; i ++)
		upper [i] = lower [i] = True;
	

	for ALL_LANDS (ptr)
		if (isupper (ld_army (ptr)))	
			upper [ld_army (ptr) - 'A'] = False;
		else if (islower (ld_army (ptr)))
			lower [ld_army (ptr) - 'a'] = False;
	
}

void ShowFreeArmys ()
{
	char * ptr;
	bool upper [26], lower [26];

	CalcFreeArmys (upper, lower);
	ptr = MakeFreeString (upper, lower);

	if (strlen (ptr) == 0)
		Message ("No free armys");
	else
		Message (Fmt ("Free armys: %s", ptr));
}

char FirstFreeArmy ()
{
	int i;
	bool upper [26], lower [26];

	for (i = 0; i < 26; i ++)
		if (lower [i])
			return 'a' + i;

	for (i = 0; i < 26; i ++)
		if (upper [i])
			return 'A' + i;

	return '\0';
}
