/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/data/RCS/dump.c,v 5.2 1995/09/08 07:15:42 jpo Exp $
    $Date: 1995/09/08 07:15:42 $
    $Author: jpo $
    $Id: dump.c,v 5.2 1995/09/08 07:15:42 jpo Exp $
    $Locker:  $
    $Log: dump.c,v $
    Revision 5.2  1995/09/08 07:15:42  jpo
    dump lands

 * Revision 5.1  93/03/14  16:46:45  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:34  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:35:48  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "xrc.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "nation.h"

static void BinDumpSects (fp)
FILE * fp;
{
	int x, y;
	Sector sct;
	struct s_sector1 nil_sect;
	int size;

	size = sizeof (struct s_sector1);
	fwrite ((char *) & size, sizeof (size), 1, fp);
	size = sizeof (struct s_sector2);
	fwrite ((char *) & size, sizeof (size), 1, fp);
	size = sizeof (struct s_sector3);
	fwrite ((char *) & size, sizeof (size), 1, fp);

	for (x = 0; x < MAX_X; x ++) 
	for (y = 0; y < MAX_Y; y++)
	{
		sct = World (x, y, S_EXIST);

		if (sct == (Sector) 0 || NO_INFO (sct))
			continue;

		fwrite ((char *) sct, sizeof (struct s_sector1), 1, fp);

		if (! KNOW_ALL (sct) &&
		    ! KNOW_SPY (sct) &&
		    ! KNOW_LOO (sct) &&
		    ! KNOW_RES (sct))
		    	continue;

		fwrite ((char *) sct-> sct2, sizeof (struct s_sector2), 1, fp);

		if (! KNOW_ALL (sct))
			continue;
		
		fwrite ((char *) sct-> sct2-> sct3, sizeof (struct s_sector3),
								1, fp);
		if (s_pat (sct) != (char *) 0)
			fwrite (s_pat (sct), 1, strlen (s_pat (sct)) + 1, fp);
		
		if (s_plan (sct) != (PlanEntry) 0)
			SavePlanInfo (sct, fp);
	}

	nil_sect. inf = 0;

	fwrite ((char *) & nil_sect, sizeof (struct s_sector1), 1, fp);
}

static bool BinRestSects (fp)
FILE *fp;
{
	struct s_sector1 dummy;
	int x, y;
	Sector sct;
	char buffer [BUFSIZ];
	char * ptri;
	struct s_sector2 * ptr2;
	struct s_sector3 * ptr3;
	int size;

	fread ((char *) & size, sizeof (size), 1, fp);
	if (size != sizeof (struct s_sector1))
		return False;
	fread ((char *) & size, sizeof (size), 1, fp);
	if (size != sizeof (struct s_sector2))
		return False;
	fread ((char *) & size, sizeof (size), 1, fp);
	if (size != sizeof (struct s_sector3))
		return False;

	while (fread (& dummy, sizeof (struct s_sector1), 1, fp) > 0)
	{
		if (dummy. inf == 0)
		{
			/* end of sector list */

			return True;
		}

		x = dummy. xcd;
		y = dummy. ycd;

		if (KNOW_ALL (& dummy))
			sct = World (x, y, S_OWNED);
		if (KNOW_RES (& dummy) ||
		    KNOW_LOO (& dummy) ||
		    KNOW_SPY (& dummy))
			sct = World (x, y, S_RESOU);
		else
			sct = World (x, y, S_DESIG);
		
		ptr2 = sct-> sct2;
		bcopy ((char *) & dummy, (char *) sct,
						sizeof (struct s_sector1));
		sct-> sct2 = ptr2;
		sct-> fship = (Ship) 0;
		if (land_units)
			sct-> fland = (Land) 0;
		sct-> fplane = (Plane) 0;
		sct-> stock = (Stockp) 0;
		set_shi (sct, 0);
		if (land_units)
			set_land (sct, 0);
		set_pla (sct, 0);
		set_nuk (sct, 0);
		set_mar (sct, 0);

		if (ptr2 != (struct s_sector2 *) 0)
		{
			ptr3 = sct-> sct2-> sct3;
			(void) fread ((char *) sct-> sct2,
					sizeof (struct s_sector2), 1, fp);

			sct-> sct2-> sct3 = ptr3;

			if (ptr3 != (struct s_sector3 *) 0)
			{
				(void) fread ((char *) sct-> sct2-> sct3,
					sizeof (struct s_sector3), 1, fp);
				sct-> sct2-> sct3-> fnuke = (Nuke) 0;
				if (s_pat (sct) != (char *) 0)
				{
					ptri = buffer;

					for (;;)
					{
						fread (ptri, 1, 1, fp);
						if (* ptri == '\0')
							break;
						ptri ++;
					}

					s_pat (sct) = Str (buffer);
				}

				if (s_plan (sct) != (PlanEntry) 0)
					LoadPlanInfo (sct, fp);
			}
		}
	}

	return False;
}

static void BinDumpShips (fp)
FILE * fp;
{
	struct s_ship dummy;
	Ship ship;
	int size;

	size = sizeof (struct s_ship);
	fwrite ((char *) & size, sizeof (size), 1, fp);

	for (ship = shiplist; ship != (Ship) 0; ship = sh_next (ship))
		(void) fwrite ((char *) ship, size, 1, fp);
	
	dummy. nr = -1;

	(void) fwrite ((char *) & dummy, sizeof (struct s_ship), 1, fp);
}

static bool BinRestShips (fp)
FILE * fp;
{
	Ship dummy;
	Sector sct;
	int size;

	fread ((char *) & size, sizeof (size), 1, fp);
	if (size != sizeof (struct s_ship))
		return False;

	for (;;)
	{
		dummy = (Ship) doalloc ((unsigned) sizeof (struct s_ship));

		fread ((char *) dummy, size, 1, fp);

		if (sh_nr (dummy) == -1)
		{
			free ((char *) dummy);
			return True;
		}

			/* add ship to sector */
		
		sct = World (sh_xcd (dummy), sh_ycd (dummy), S_DESIG);
		inc_shi (sct);
		sh_nxtsct (dummy) = s_fship (sct);
		s_fship (sct) = dummy;
		sh_next (dummy) = shiplist;
		shiplist = dummy;
	}
}

static void BinDumpNation (fp)
FILE * fp;
{
	int size;

	size = sizeof (struct s_nation);
	fwrite ((char *) & size, sizeof (size), 1,  fp);

	(void) fwrite ((char *) nation, sizeof (struct s_nation), 1, fp);
}

static bool BinRestNation (fp)
FILE * fp;
{
	int size;

	fread ((char *) & size, sizeof (size), 1, fp);
	if (size != sizeof (struct s_nation))
		return False;
			
	(void) fread ((char *) nation, sizeof (struct s_nation), 1, fp);
	return True;
}

extern char *MakeDataFile ();

void BinDumpAll ()
{
	FILE * fp;
	char * file;

	if (command_state == FASTQUIT_STATE)
		return;

	Message ("Saving binary data");

	file = MakeDataFile(".dump");
	fp = fopen (file, "w");
	if (fp == (FILE *) 0)
	{
		fprintf (stderr, "can't open %s for binary dump\n", file);
		perror ("fopen");
		return;
	}

	BinDumpSects (fp);
	BinDumpShips (fp);
	BinDumpLands (fp);
	BinDumpPlanes (fp);
	BinDumpNation (fp);
	BinDumpNukes (fp);
	fclose (fp);

	if (xrc. compress)
		system (Fmt ("%s %s > /dev/null 2>& 1", COMP_BIN, file));
}

void BinRestAll ()
{
	FILE * fp;
	char * file;

	Message ("Restoring binary data");

	file = MakeDataFile (".dump");

	if (xrc. compress)
		system (Fmt ("%s %s.Z > /dev/null 2>& 1", UNCOMP_BIN, file));

	fp = fopen (file, "r");
	if (fp == (FILE *) 0)
	{
		if (util_mode)
		{
			fprintf (stderr,
				"can't open %s for reading binary dump\n",
				file);
			perror ("fopen");
		}
		else
		{
			PrintAtEmpire (Fmt ("No binary datafile %s", file));
			PrintAtEmpire ("");
			Bell ();
			(void) EmpireMore ();
		}

		return;
	}

	if (! BinRestSects (fp)  || ! BinRestShips (fp) || !BinRestLands(fp) ||
	    ! BinRestPlanes (fp) || ! BinRestNation (fp) ||
	    ! BinRestoreNukes (fp))
	{
		if (xstarted)
		{
			Message (
		 "bin dump file corrupted, please remove & start again");
			Bell ();
			Pause ();
		}
		else
			fprintf (stderr,
		 "bin dump file corrupted, please remove & start again");

		save_data = False;
		leave ();
	}

	fclose (fp);
	Message ("ready");
}
