/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/census/RCS/plane.c,v 5.2 1995/09/08 06:59:03 jpo Exp $
    $Date: 1995/09/08 06:59:03 $
    $Author: jpo $
    $Id: plane.c,v 5.2 1995/09/08 06:59:03 jpo Exp $
    $Locker:  $
    $Log: plane.c,v $
    Revision 5.2  1995/09/08 06:59:03  jpo
    Added missions.

 * Revision 5.1  93/03/14  16:41:57  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "census.h"
#include "sector.h"
#include "plane.h"
#include "nuke.h"
#include "version.h"

static bool plane_censenable [PCM_MAX];

#ifdef X_VERSION

struct s_funcbutton plane_functions [] =
{
	{ PCM_BOMB,	"Bomb",		2,  PL_SY_FUNCBUT,	6 },
	{ PCM_TRANSPORT,"Transp", 	10, PL_SY_FUNCBUT,	7 },
	{ PCM_RECON,	"Recon",	19, PL_SY_FUNCBUT,	5 },
	{ PCM_FLY,	"Fly",		2,  PL_SY_FUNCBUT + 1,	6 },
	{ PCM_LAUNCH,	"Launch",	10, PL_SY_FUNCBUT + 1,	7 },
	{ PCM_SCRAP,	"Scrap",	19, PL_SY_FUNCBUT + 1,	5 },
	{ PCM_DROP,	"Drop",		2,  PL_SY_FUNCBUT + 2,	6 },
	{ PCM_HARDEN,	"Harden",	10, PL_SY_FUNCBUT + 2,	7 },
	{ PCM_PARADROP,	"Parad",	19, PL_SY_FUNCBUT + 2,	5 },
	{ PCM_ARM,	"Arm",		2,  PL_SY_FUNCBUT + 3,	6 },
	{ PCM_SET,	"Set",		10, PL_SY_FUNCBUT + 3,	7 },
	{ PCM_BUILD,	"Build",	19, PL_SY_FUNCBUT + 3,	5 }
};

#else

struct s_funcbutton plane_functions [] =
{
	{ PCM_BOMB,	"Bomb",		3,  PL_SY_FUNCBUT,	4 },
	{ PCM_TRANSPORT,"Transp", 	10, PL_SY_FUNCBUT,	6 },
	{ PCM_RECON,	"Recon",	18, PL_SY_FUNCBUT,	5 },
	{ PCM_FLY,	"Fly",		3,  PL_SY_FUNCBUT + 1,	4 },
	{ PCM_LAUNCH,	"Launch",	10, PL_SY_FUNCBUT + 1,	6 },
	{ PCM_SCRAP,	"Scrap",	18, PL_SY_FUNCBUT + 1,	5 },
	{ PCM_DROP,	"Drop",		3,  PL_SY_FUNCBUT + 2,	4 },
	{ PCM_HARDEN,	"Harden",	10, PL_SY_FUNCBUT + 2,	6 },
	{ PCM_PARADROP,	"Parad",	18, PL_SY_FUNCBUT + 2,	5 },
	{ PCM_ARM,	"Arm",		3,  PL_SY_FUNCBUT + 3,	4 },
	{ PCM_SET,	"Set",		10, PL_SY_FUNCBUT + 3,	6 },
	{ PCM_BUILD,	"Build",	18, PL_SY_FUNCBUT + 3,	5 }
};

#endif

static void HandleCensusButtonForPlane (button, plane)
int button;
Plane plane;
{
	if (! plane_censenable [button])
		return;

	UnmarkAllPlanes ();

	switch (button)
	{

	case PCM_BOMB:
		DoBomb (10, 10, cursct, Fmt ("%d", pl_nr (plane)),
			(char *) 0, (char *) 0, (char *) 0, False);
		break;

	case PCM_TRANSPORT:
		Transport (10, 10, Fmt ("%d", pl_nr (plane)));
		break;

	case PCM_PARADROP:
		Paradrop (10, 10, Fmt ("%d", pl_nr (plane)));
		break;
	
	case PCM_DROP:
		DoDropOff (10, 10, Fmt ("%d", pl_nr (plane)),
			(char *) 0, (char *) 0, (char *) 0);
		break;

	case PCM_FLY:
		DoFly (10, 10, Fmt ("%d", pl_nr (plane)),
			(char *) 0, (char *) 0, (char *) 0);
		break;

	case PCM_SET:
		SetPlane (plane, (int *) 0);
		break;

	case PCM_SCRAP:
		ScrapPlane (Fmt ("%d", pl_nr (plane)));
		break;

	case PCM_HARDEN:
		Harden (Fmt ("%d", pl_nr (plane)));
		break;

	case PCM_RECON:
		Recon (10, 10, Fmt ("%d", pl_nr (plane)));
		break;

	case PCM_LAUNCH:
		DoLaunch (plane);
		break;

	case PCM_ARM:
		Arm (10, 10, Fmt ("%d", pl_nr (plane)));
		break;

	case PCM_BUILD:
		BuildPlane (10, 10);
		break;
	}
}

static void CensusChangeWing (plane)
Plane plane;
{
	char * ans;

	CenClr (PL_SY_WING);
	CenPuts (0, PL_SY_WING, "Add to wing: ");
	ShowFreeWings ();
	ans = GetString (census_win, 13, PL_SY_WING, 1, "a-zA-Z~");
	if (ans == (char *) 0 || interrupt || * ans == '\0')
		interrupt = False;
	else
	{
		FeedCommand (Fmt ("wingadd %c %d", * ans,
				pl_nr (plane)), PRINT);
		set_pl_wing (plane, * ans);
	}

	PlaneCensus (plane);
}

void CensusLayPlane ()
{
	CenLine (PL_SY_NAME - 1);
	CenPuts (0, PL_SY_POS, "Pos:");
	CenPuts (0, PL_SY_WING, "Wing:");
	if (deity)
		CenPuts (0, PL_SY_NUMBER, "Nr/Country: ");
	else
		CenPuts (0, PL_SY_NUMBER, "Number: ");

	CenLine (PL_SY_STATS - 1);
	CenPuts (0, PL_SY_STATS,     "Eff      Mob      Sh#");
	CenPuts (0, PL_SY_STATS + 1, "Tec      Ran      Loa");
	CenPuts (0, PL_SY_STATS + 2, "Att      Def      Har");
	CenPuts (0, PL_SY_STATS + 3, "Nuk");
	if (land_units)
		CenPuts (9, PL_SY_STATS + 3, "Mis      Ret");
	CenLine (PL_SY_STATS + 4);


	CenButton (PL_SX_SECTOR, PL_SY_BUT, "Sector", 6, False);
	CenButton (PL_SX_WING,   PL_SY_BUT, "Wing",   4, False);
	CenButton (PL_SX_NEXT,   PL_SY_BUT, "Next",   4, False);
	CenLine (PL_SY_BUT + 1);
}

void PlaneCensus (plane)
Plane plane;
{
	int maxl;
	int i;

	curplane = plane;
	CenClr (PL_SY_NAME);
	CenPutVal (0, PL_SY_NAME, PlaneName (plane));
	CenPutVal (5, PL_SY_POS, Fmt ("%d,%d       ",
					pl_xcd (plane), pl_ycd (plane)));
	if (deity)
		CenPutVal (12, PL_SY_NUMBER, Fmt ("%d/%s",
				pl_nr (plane), CountryName (pl_owner (plane))));
	else
		CenPutShort (8, PL_SY_NUMBER, pl_nr (plane));

	CenClr (PL_SY_WING);
	CenPuts (0, PL_SY_WING, "Wing: ");
	CenPutVal (6, PL_SY_WING, Fmt ("%c", pl_wing (plane)));
	if (pl_wing (plane) != '~' && ! WingColocated (pl_wing (plane)))
		CenPutVal (8, PL_SY_WING, "(Not colocated)");

	CenPutVal (4, PL_SY_STATS, Fmt ("%-3d%%", pl_eff (plane)));
	CenPutShort (13, PL_SY_STATS, pl_mob (plane));
	if (PortablePlane (plane))
	{
		if (pl_shipnr (plane) >= 0)
			CenPutShort (22, PL_SY_STATS, pl_shipnr (plane));
		else
			CenPuts (22, PL_SY_STATS, "    ");
	}
	else
		CenPutVal (22, PL_SY_STATS, "---");
	
	CenPutShort (4,  PL_SY_STATS + 1, pl_tech (plane));
	CenPutShort (13, PL_SY_STATS + 1, pl_range (plane));
	CenPutPos   (22, PL_SY_STATS + 1, planetypes [pl_type (plane)]. load);
	CenPutShort (4,  PL_SY_STATS + 2, pl_att (plane));
	CenPutShort (13, PL_SY_STATS + 2, pl_def (plane));
	CenPutShort (22, PL_SY_STATS + 2, pl_hard (plane));

	if (pl_launc (plane))
		CenPutVal (9, PL_SY_STATS + 3, "Launched");
	else if(land_units)
		CenPutVal (13, PL_SY_STATS + 3,
			   Fmt (pl_mission(plane) == '\0' ? "None" :
				"%c", pl_mission(plane)));
	else
		CenPuts   (9, PL_SY_STATS + 3, "         ");

	if (pl_sell (plane))
		CenPutVal (18, PL_SY_STATS + 3, "Set");
	else
		CenPuts   (18, PL_SY_STATS + 3, "   ");

	if (pl_nukeamt (plane))
	{
		CenPutShort (4, PL_SY_STATS + 3, pl_nukeamt(plane));
		CenPutVal (9, PL_SY_STATS + 3, nt_name(pl_nuketype(plane)));
	}
	else
	{
		CenPuts   (4, PL_SY_STATS + 3, "   ");
	}

	for (i = 0; i < PCM_MAX; i ++)
		plane_censenable [i] = False;

	plane_censenable [PCM_SET] = market;
	plane_censenable [PCM_TRANSPORT] = True;

	if (s_des (cursct) == '*' && (deity || s_eff (cursct) >= 60))
		plane_censenable [PCM_BUILD] = True;

	/* can launch missile from any sector */
	if ((PlaneHas (plane, P_M) && !PlaneHas (plane, P_F)) ||
 	    PlaneHas (plane, P_O))
		plane_censenable [PCM_LAUNCH] = True;
	
	if (! PlaneHas (plane, P_V) && s_des (cursct) != '.' &&
		(s_des (cursct) != '*' || s_eff (cursct) < 60))
	{
		DrawCensusButtons (plane_functions, PCM_MAX, plane_censenable);
		return;
	}

	if (pl_mob (plane) > 0)
	{
		if (! PlaneHas (plane, P_M) && ! PlaneHas (plane, P_O))
			plane_censenable [PCM_FLY] = True;

		if (PlaneHas (plane, P_B) || PlaneHas (plane, P_T))
			plane_censenable [PCM_BOMB] = True;
		
	/* You can Recon with any plane, spy planes just give more info
		if (PlaneHas (plane, P_S))
	*/
		if (! PlaneHas (plane, P_M) && ! PlaneHas (plane, P_O))
			plane_censenable [PCM_RECON] = True;

		if (PlaneHas (plane, P_C))
			plane_censenable [PCM_DROP] =
			plane_censenable [PCM_PARADROP] = True;
	}

	if (s_des (cursct) == '*' && s_eff (cursct) >= 60)
	{
		plane_censenable [PCM_SCRAP] = True;
		plane_censenable [PCM_HARDEN] = PlaneHas (plane, P_M) &
						!PlaneHas (plane, P_F);
	}

	if (s_nuk (cursct) != 0)
		plane_censenable [PCM_ARM] = True;

	DrawCensusButtons (plane_functions, PCM_MAX, plane_censenable);
}

static void RangeEdit (plane)
Plane plane;
{
	int new_range;
	char * ans, * ptr;

	CenPuts (13, PL_SY_STATS + 1, "   ");
	ans = GetString (census_win, 13, PL_SY_STATS + 1, 3, GS_PNUMBER);

	if (ans == (char *) 0 || interrupt || * ans == 0)
	{
		Message ("Range edit cancelled");
		return;
	}

	FeedEmpire (Fmt ("range %d %s", pl_nr (plane), ans), PRINT);
	ptr = ReadEmpire (PRINT);
	if (sscanf (ptr, "Plane %*d range changed to %d", & new_range) != 1)
	{
		(void) WaitForPrompt (PRINT);
		Message ("Range edit failed");
		return;
	}

	(void) WaitForPrompt (PRINT);
	Message (Fmt ("Range of plane #%d set to %d",
				pl_nr (plane), new_range));
	set_pl_range (plane, new_range);
}

void PlaneCensusBut (x, y)
int x, y;
{
	Plane next;
	int i;

	if (y == PL_SY_WING)
	{
		CensusChangeWing (curplane);
		FlushWindow (census_win);
		Refresh ();
		return;
	}

	if (y == PL_SY_STATS + 1 && x >= 10 && x <= 16)
	{
		if (! KSUOption (RANGEEDIT))
		{
			KSUNotDefined (RANGEEDIT);
			return;
		}

		RangeEdit (curplane);
		CensusPlane (curplane);
		return;
	}
	if (land_units && y == PL_SY_STATS + 3 && x >= 10 && x <= 16) {
		PMission (curplane);
		CensusPlane (curplane);
		return;
	}
	if (y == PL_SY_BUT)
	{
		if (ButtonPressed (x, y, PL_SX_SECTOR, y, 6))
			CensusSct (PlaneSector (curplane));
		else if (ButtonPressed (x, y, PL_SX_WING, y, 4))
			CensusWing (pl_wing (curplane));
		else if (ButtonPressed (x, y, PL_SX_NEXT, y, 4))
		{
			next = pl_nxtsct (curplane);
			if (next == (Plane) 0)
				next = s_fplane (PlaneSector (curplane));

			curplane = next;
			CensusPlane (curplane);
		}

		return;
	}

	i = WhichCensusButton (plane_functions, PCM_MAX, x, y);
	if (i >= 0)
	{
		HandleCensusButtonForPlane (i, curplane);
		return;
	}
}
