.Sh PARSER Highlight
.Np HIGHLIGHT
You can highlight sectors satisfying a certain condition. For the correct
syntax, see "info: parse/syntax". Some examples will be given
how to use the highlight function.
.Np INVOKE
The best way to get the highlight menu is to bind a certain key
to it. The other way is via the global menu, display, and the
choice "change highlight".
.Np EXAMPLES
starvation
.Sr
Highlight those sectors where people will starve.
.Sl
.s1
etus_per_update * civ * cbrate + civ > 990
.Sr
Highlight those sectors that will be overpopulated.
.Sl
.s1
ship (name = "cargo ship")
.Sr
Highlight those sectors with at least one cargo ship in it.
.Sl
.s1
ship (name ~ "cargo" and mob > 0) == 2
.Sr
Highlight those sectors that have exactly two "cargo*" ships with positive
mobility.
.Sl
.s1
plague_stage != healty
.Sr
Highlight those sectors which are infected.
.Sl
.s1
ship (plane (type ~ "fighter"))
.Sr
Highlight those sectors with a ship in it that carries at least one 
fighter.
.Sl
.s1
r (iron) > 80 or r (gold dust) > 80
.Sr
Highlight those sectors which have some mining or gold resources.
.Sl
.s1
ship (plane (nuke (name = "10 kt fission")))
.Sr
Highlight those sectors that have a ship that carries a plane that
is loaded with a 10 kt fission nuke warhead.
.Sl
.s1
occupied and (mil < (civ / 20))
.Sr
Highlight occupied sectors which don't have enough militairs.
.Sl
.s1
coast and mil < 10
.Sr
Highlight coast sectors that don't have enough militairs.
.Sl
.s1
not owned and des = capital
.Sr
Pleppen!
.Sl
.s1
mines > 0
.Sr
Highlight water which should be avoided.
.Sl
