NAME
  pei - Perl Empire Interface

SYNOPSIS
  pei [ -n ] [country] [representative] [host] [port]
    -or-
  pei [ -n ] [gamename]

DESCRIPTION
  pei is a powerful, fully extendible smart client for playing Empire.
  Features include:
    - Tools for managing and feeding civs, auto-exploring, setting dist-paths,
      calculating the new efficiency of ships/planes/units, reading/sending
      telegrams and announcements, keeping track of enemy sectors and units,
      and managing production deltas.
    - Full perl integration.  You can type perl commands at the empire prompt.
    - File redirection, piping, exec (read commands from a file), and
      runfeed (pipe the output of a program to pei).
    - Aliases.  You can define your own aliases with arguments.
    - !!, !abc, and ^a^b history substitution
    - Multiple games.  You may be connected to more than one game at a time,
      and switch between them.
    - Function mapping.  You can call your own perl functions from within
      the client by defining your own function maps.
    - Output parsing.  Server output is automatically parsed and stored in
      an internal database.  There is a separate database for each game
      connected to.
    - Readline.  If pei finds readline.pl and can load it, then it will use it.
      But pei does not require readline.
    - Interrupt handling.  ^C should be handled properly in most cases.

  If the option -n is specified, then pei will be loaded without any tools.
  This is useful if you just want to log on quickly and check your mail.

  An instance of pei begins by executing commands from the file .peirc in
  the home directory of the invoker.  If a game has not been specified, then
  the user is presented with a 'Local%' prompt at which they can choose
  any game that was specifed by an 'addgame' line in .peirc.

  Once a game has been specified, pei tries to connect to the game.  If it
  was unable to connect, it will exit with a message explaining what went
  wrong.

  Once connected, pei begins executing commands from the file start.exec
  in the current directory.  Note that 'addgame' lines in .peirc can
  associate to each game its own directory.
    
  Then pei repeatedly performs the following actions:  Lines are read from
  the server and parsed until a prompt is encountered, then terminal input
  is parsed until an Empire command is encountered at which point pei sends
  the command to the server.

Lexical Structure
  An input line can come from one of three places:
    (1) You typed it in.
    (2) It was read in from a file (e.g. "start.exec").
    (3) It was the value of an alias.

  In case (1), if the input line is of one of the following forms, it will
  undergo history substitution:
    !!			    - Repeat the last command.
    ![text]                 - Repeat the last command starting with [text].
                              e.g. !cen
    ^[text]^[replace]       - Replace [text] with [replace] in last command.
                              e.g. ^jjh^jnh
      
  Input lines beginning with # are comments and are ignored.

  Each input line consists of sequence of command lines separated by semicolons
  (note that semicolons inside single or double quotes don't count):
    commandline1; commandline2; commandline3; ...

  Each commandline has the following syntax:
    ?[scommand]             - If we are at a sub-prompt, send [scommand] to it,
                              otherwise, ignore.
                              e.g. attack 3,3; ?10; ?2
    [ecommand]              - Send the empire command [ecommand] to the
                              server.  If we were expecting ?[scommand],
                              abort the previous command before sending.
                              e.g. cen 0,0
                              e.g. move; cen 2,0 (aborts move before doing cen)
    :[syscmd]               - Send [syscmd] to your operating system.
                              e.g. :ls
    [command] > [filename]  - Write the output of [command] to [filename]
                              only if the file does not exist.
                              e.g. cen #1 > cenfile
    [command] >! [filename] - Write the output of [command] to [filename]
                              (if the file exists, overwrite it).
                              e.g. cen #1 >! cenfile
    [command] >> [filename] - Append the output of [command] to [filename].
                              e.g. spy 3,3 >> spyfile
    [command] | [syscmd]    - Pipe the output of [command] to the system
                              command [syscmd].
                              e.g. news | more

  Any commandline beginning with "$", "&", "@", "%", "{", "print ", "undef ",
  or "eval " will be evaluated as a perl expression.

Commands
  These commands are local commands which may be typed at the local prompt
  or at the pei prompt:
    help [subject]          - Print help on [subject].
    addgame [game] [country] [password] [host] [port] [directory]
                            - Add [game] to pei where [directory] is a unix
			      directory that pei cd's to before connecting
                              to the game.
    games                   - List games.
    [game]                  - Connect to [game].
    try [game]              - Connect to [game] as a different country.
    kill [game]             - Kill process [game] on host.
    trykill [game]          - Kill process [game] on host with a different
                              country.
    echo [text]             - Print [text] to the terminal.
    alias [name] [stuff]    - Define [name] to mean [stuff] (see "Aliases"
                              below).
    unalias [name]          - Remove alias definition for [name].
    terse                   - Toggle terse mode.  If terse is on, then tools
                              run quietly (useful for modems with low BAUD).
    quiet                   - Toggle quiet mode.  If quiet is on, then commands
                              read from exec files are not printed.
    firewall [proxyname] [proxyport] ["proxyprompt"]
                            - Use the proxy server to connect to the empire
                              server. [proxyprompt] is the prompt from the
                              server telling pei its ready to accept an address.
                              proxyprompt should be in double quotes.
    exit                    - Exit pei.
    bye                     - Exit pei.

  These commands are "function maps", and may be typed at the pei prompt when
  you are connected to a game:
    quit                    - Log out of the current game.
    exec [filename]         - Read input lines from [filename].  If you don't
                              want the commands printed to the terminal, then
                              before the exec, you should have "$quiet = 1".
                              e.g. exec pei_commands
    runfeed [syscmd]        - Run the program [syscmd] and pipe the output
                              to pei.
                              e.g. runfeed mycivmover
    reconnect               - Disconnect and reconnect to the server.
    history                 - Print the last $maxhistorysize input lines.
  Note that any [filename] or [syscmd] may use ~ to refer to the home
  directory of the user.

These commands are "tool commands" and may be typed at the pei prompt when
you are conencted to a game.  Note that if <SECTS>, <SHIPS>, or <UNITS> are
not specified in any of the tools, then '*' is used.  Default <REALM> is '#'.
Note also that ?switches may always be used in <SECTS> specifications.
  These tools change your country:
    nova <REALM> - Auto-explore all adjacent wilderness sectors in <REALM>.
                    If <REALM> is not specified, #0 is used.
                    e.g. nova #1
    cmvr <SECTS> <THRESH>
                  - Move civs in <SECTS> to try to get <THRESH> in each
                    sector.  If <THRESH> is not specified, then the value of 
                    "max safe civs" from the nation report is used.
                    e.g. cmvr
                    e.g. cmvr #3
                    e.g. cmvr #12 ?newd=g 300
    umvr <SECTS> <THRESH> - Move uws (just like cmvr).
    imvr <SECTS>, dmvr <SECTS>, lmvr <SECTS>, smvr <SECTS>, ...
                  - Move iron, dust... in <SECTS> according to dist thresholds.
    NOTE: The above tools will never lower the mobility of a sector below the
    value specified in the $minmob array.  If you don't like the default values
    for $minmob, then edit $minmob in the xmvr_init function of tools.pl.
    setfood <SECTS>
                  - Set food thresholds for maximum civ growth.  (setfood will
                    not reduce any existing thresholds.)  After calling
                    "setfood", you can call "fmvr" to move food into the
                    sectors that need it.  Won't set thresholds in warehouses.
    jack <SECTS>  - Set iron thresholds in your "j" and "k" sectors to the
                    value of "max1" in your production report.  After calling
                    "jack", you can call "imvr" to move iron into the sectors
                    that nead it.
    fus <SHIPS>   - Fuel ships in harbours and generate an error message if
                    the harbour needs more fuel.  If the ship is at sea, and
                    it is not completely fueled, then the number of sectors
                    it will be able to sail before needing to refuel is shown.
    router <SECTS> 
                  - Dist all sectors to the nearest warehouse.  If there isn't
                    a warehouse within 10 sectors, make a useless sector into
                    a warehouse and dist to it.
    foreach <SECTS> [ecommand]
                  - Perform the Empire command [ecommand] on <SECTS>
                    where instances of the variables $sect, $civ,
                    $mil, $uw, $food, $iron, $lcm, $hcm, $iron, $dust,
                    $bar, $oil, $rad, $pet, $shell, and $gun in
                    [ecommand] will be replaced by their values for
                    each sector.
                    e.g. foreach #1 ?mil<5 move m 0,0 5-$mil $sect
                    (Make sure that each sector in #1 has at least 5 mil
                    in it--if it doesn't, move the necessary amount of mil
                    from 0,0 into the sector.)
  These tools tell you information about your country:
    civs <SECTS>  - Produces a report showing which sectors have too many
                    civs, and which sectors have too few (based on how
                    many commodities are in the sector and what the neweff
                    will be).
    rebel <SECTS> - Tells you how many more mil conquered sectors need
                    to keep them from rebelling.
    crew <SHIPS>  - This command specifies exactly how many civs or mil your
                    ships will need so that they won't decay when they are out
		    at sea.
    reach         - Tells you the range of your forts, radar stations, and 
                    coastwatch.
    sreach <SHIPS>
                  - Tells you the fire range of your ships, and how many
                    sectors they can nav this update and next update.
    lreach <UNITS>
                  - Tells you the fire range of your land units, and how many
                    100% (non-road non-mountain) sectors they can march this
                    update and next update.
    sneweff <SECTS>
    pneweff <SECTS>
    lneweff <SECTS>
                  - Calculates the new efficiency that ships, planes,
                    or land units will have after the next update.  If
                    the sector doesn't have enough commodities to
                    build all the units, then the extra commodities
                    needed will show up in brackets in the
                    commodities' column.  The avail column will show
                    the ammount of avail that this ship, plane, or
                    unit will use.  If the value in the avail column
                    is in brackets it indicates the ammount of avail
                    that this ship, plane, or unit needs for maximum
                    production.  Lastly, if a ship needs more mil on
                    board to prevent efficiency decay, that will
                    appear in brackets in the "Crew" column.  The "total"
                    at the bottom sums the total commodities consumed in the
                    sector for building.  Any extra commodities in the sector
                    (i.e. not being used for building) will be preceded by a +.
                    e.g. sneweff #1
                    e.g. pneweff 11,11
    delta <SECTS>
    fdelta <SECTS>
    wdelta <SECTS>
                  - These three commands calculate production deltas in 
                    different ways.  The <SECTS> argument refers to
                    distribution centres.  So only sectors which distribute
                    into <SECTS> are included in the calculations.  So a sector
                    in <SECTS> which distributes outside <SECTS> will not
                    be included, while a sector outside <SECTS> which
                    distributes into <SECTS> will be included.
                  - "delta" adds up the total amount of commodities produced
                    and subtracts that from the total amount consumed.  The
                    "supply" column says how many updates of supply you have
                    left of that commodity.
                  - "fdelta" projects civ/uw growth versus food production
                    over the next 15 updates.
                  - "wdelta" is like "delta" except that it bases its
                    calculation on what will happen inside the warehouses.
                    i.e. how much of each commoditiy is going into storage
                    versus how much is being drawn out of storage.
    simu <SECTS>  - "simulate" an update.  Pei runs your country through a 
                    simulated update, showing how many of your commodities
                    will get distributed where at the update.  The update is
                    always simulated for *all* the sectors in your country.
                    The <SECTS> argument specifies which sectors you'd like
                    displayed.  The "mob" field specified how much mobility
                    will be left in the sector after stuff is distributed out
                    but before new mobility is added.  The "commodities" field
                    shows which commodities will end up in which sectors.  A
                    "+" after a commodity means that not all of that commodity
                    got disted out.  A "-" means that the sector didn't get all
                    that it wanted.  An "a" in the "make" field refers to how
                    much avail will be created in that sector.
    cmap <REALM>  - Like bmap, but prints a letter representing the owner of
                    sectors not owned by you, so you can see who is where.
    stat <SECTS> (?switches)
                  - Report known information on all sectors in <SECTS>
                    that statisfy ?switches (if defined).  All normal
                    sector switches apply although if you do not know
                    the information about the sector in question the
                    check will probably fail.
                    e.g. stat * ?own=27
    sstat <REALM> (?switches)
    pstat <REALM> (?switches)
    lstat <REALM> (?switches)
                  - Report known information on all land units, planes,
                    or ships within <REALM> that satisfy ?switches (if
                    definded).  Valid switches for land units are:
                    own, tech, eff, and type.  The only difference
                    between these switches and normal empire switches
                    are that type will handle a partial match.
                    e.g. lstat * ?own=27&type=inf
    mail, wmail   - mail-like interface for reading telegrams and
                    announcements.  Allows replying, forwarding, and saving
                    to a file.  To reply to an announcement as an announcement,
                    forward without a country number.  Type "?" in the mailer
                    for help.
    tele, anno    - Use the editor specified in the $EDITOR variable to compose
                    a telegram or announcement.  When you have finished editing
                    your tele or anno, pei will chop it into 1024 byte blocks
                    and send it off.

Variables
  Any pei command may contain perl variables.  These variables will be replaced
  by their values when the command is parsed.  For example:
    $a = "0,0"
    cen $a           (evaluates to "cen 0,0")
  If you want to isolate a variable name from surrounding text, then you may
  use {} brackets as in:
    $x = "ti"
    na${x}on         (evaluates to "nation")

  Here are some special pei variables which you can define:
  $AUTOGAME       - If defined in ~/.peirc, then pei will automatically connect
                    to this game when it starts up.
  $maxhistorysize - The number of input lines remembered by pei in the history
                    mechanism (default is 100).
  $EDITOR         - The editor that you would like to use for composing
                    telegrams and announcements (default is "vi" or
                    environment variable EDITOR if defined).
  $PAGER          - Program to display output one screenful at a time.
                    (default is "more" or environment variable PAGER
                    if defined).
  $mailflag       - If $mailflag = 1 or $mailflag{gamename} = 1, then when you
  %mailflag         use "mail" to read your telegrams, pei will send "n" to
                    the server so that your telegrams won't get deleted.
		    Useful for co-rulers.
  $debug          - If $debug = 1, then pei will display the login conversation
                    between pei and the server when connecting to a game.
Aliases
  You can define aliases in pei using the syntax:
    alias [name] [stuff]
  For example:
    alias d- des * ?newd=- +

  If you want to put multiple commands in an alias, then you must enclose
  [stuff] in quotes.  For example:
    alias cod "res * ?des=o&ocon<10; res * ?des=g&gold<10"

  If you put perl variables in [stuff], then they will be evaluated at
  runtime.  For example:
    alias ca cen $a
    $a = "0,0"
    ca                    (evaluates to "cen 0,0")

  The following variables are also defined:
    $0                    - The alias name
    $1, $2, $3, ...       - Arguments 1, 2, 3, ... that were used when
                            the alias was called
    $+                    - All of the arguments
  For example, if you define the alias foo as follows:
    alias foo first: $1, second: $2, all: $+, This should be foo: $0
  then:
    foo a b c d e f
  would evaluate to:
    first: a, second: b, all: a b c d e f, This should be foo: foo
  Here's a more useful example:
    alias bridge "build b $1; ?$2; expl c $1 1 ${2}h"

  Alias recursion is permitted.  For example:
   alias xp explore
   alias xx xp c 0,0 1
   xx jjh         (evaluates to "explore c 0,0 1 jjh")

Readline
  If you are using readline, you will be able to use the following keys:
    C-a     beginning of line
    C-b     cursor backward
    C-c     interrupt
    C-d     delete char
    C-e     end of line
    C-f     cursor forward
    C-g     abort
    C-h     backspace
    TAB     complete filename
    RETURN  accept line
    C-k     kill line
    C-l     clear screen
    C-n     next history
    C-p     previous history
    C-q     quoted insert
    C-r     reverse search history
    C-s     forward search history
    C-t     transpose characters
    C-y     yank
    C-z     suspend
    C-_     undo
    ESC <   beginning of history
    ESC >   end of history
    ESC B   backward word
    ESC D   kill word
    ESC F   forward word
    ESC R   revert line
    ESC T   transpose words
    ESC Y   yank pop
    ESC ?   possible completions
    ESC TAB tab insert
  
Comparison to eif
  For those of you who are used to using eif, I've included this section to
  describe how eif syntax translates into pei syntax.

  The easiest way to see how eif syntax translates into pei syntax is to see
  how pei converts your ~/.eifrc into ~/.peirc (this is automatically done
  if pei doesn't find ~/.peirc).  For your reference, here is a translation
  table of eif syntax to pei syntax:

  When converting ~/.eifrc to ~/.peirc, the following translations are made:
    addgame a b c d e f               addgame a d e b c f
    &                                 ?
    @                                 :
    setvar name "string"              $name = "string"
    ${N:+}                            ${N}
    ${N:-word}                        (tricky -- watch how pei converts it)

  These translations you'll have to make by hand:
    connect gamename                  gamename
    unsetvar name                     undef $name
    $%name                            $ENV{'name'}
    !?str?                            C-r str (in readline)

  The following eif syntax should simply be rewritten in perl:
    ${N:?word}
    ${<:%word}
    ${name:=word}    

  The eif syntax !n and !-n is currently not supported.

ENVIRONMENT VARIABLES
  PERLLIB       List of directories searched when locating PERL
                libraries.  Used to find tools.pl, parse.pl,
                and readline.pl on systems that cannot automatically
                locate these libraries.
  EMPIRECOUNTRY, EMPIREREP, EMPIREHOST, EMPIREPORT
                If specified pei will use these variables to connect
                to an empire game.
  EDITOR        Default editor for pei.
  PAGER         Default screen pager to be used in pei.

FILES
  README        Things that users of older versions of pei will need
                to know about this latest version.
  INSTALL       Installation instructions.
  BUGS          A list of known bugs.
  CHANGES       A record of what got changed with version upgrades.
  WISH_LIST     Changes that we hope to implement in the future.
  pei           The program you run.
  readline.pl   Readline package.
  parse.pl      Parses server output into internal database.
  tools.pl      Contains tools (nova, cmvr, ...).
  mail.pl       Contains mail, wmail, tele, and anno tools.
  simu.pl       Contains the "simu" tool.
  example.peirc Stuff for you to put in your ~/.peirc file (NOTE: don't
                make a ~/.peirc file until pei has had a chance to
                convert your ~/.eifrc into ~/.peirc).
  pei.man       Pei users manual--you can also get this by typing "help pei"
                from within pei.
  tools.man     Manual for pei tools--you can also get this by typing
                "help tools" from within pei.
  hacker.man    Information useful to hackers.
  $HOME/.peirc              Pei commands read when pei starts up.
  $HOME/.eifrc              Converted to ~/.peirc if ~/.peirc doesn't exist.
  $gamedir/start.exec       Commands executed when you first connect to a game.
  $gamedir/$gamename.dump   Database of enemy sectors (used by "stat").
  $gamedir/$gamename.ships  Database of enemy ships (used by "sstat").
  $gamedir/$gamename.planes Database of enemy planes (used by "pstat").
  $gamedir/$gamename.units  Database of enemy land units (used by "lstat").
  $gamedir/$gamename.teles  Your mailbox of Empire telegrams (used by "mail").
  $gamedir/$gamename.wires  Announcements (used by "wmail").

AUTHORS
  Drake Diedrich (harmless@empire.net)
    Wrote the original version of this program (called hpc.pl) which included
    perl integration, file redirection, piping, function mapping,
    parse mapping, readline support, shell escape, and exec.  He also wrote
    parse.pl and user.pl.

  Ken Stevens (children@empire.net)
    Added .peirc, aliases, history substitution, runfeed, interrupt handling,
    documentation, multiple game support (addgame, kill, try), multiple
    commands separated by semicolon, sub-prompting using ?,
    and variable substitution.

  Sam Tetherow (tetherow@cse.unl.edu)
    Added the following tools: sneweff, pneweff, lneweff, tele, anno,
    mail, wmail, and foreach.  Sam also completely rewrote parse.pl,
    adding many new parse maps.

