$Header: hacker.man,v 1.8.1.1 95/05/11 03:55:57 stevens Exp $
This file contains information useful to perl coders who would like to
understand better how pei works.

Readline
  If readline isn't working with your cursor keys, then you should
  edit the following four lines in "sub init" in pei:
    &readline'rl_bind('"\\M-[A"', 'PreviousHistory'); #'
    &readline'rl_bind('"\\M-[B"', 'NextHistory'); #'
    &readline'rl_bind('"\\M-[C"', 'ForwardChar'); #'
    &readline'rl_bind('"\\M-[D"', 'BackwardChar'); #'
  The first argument to rl_bind describes what gets sent to pei when
  you hit a cursor key.  The syntax for this may be found in the
  comments before "sub rl_bind" in readline.pl.
  Note that when you hit a cursor movement key, some bytes get sent to your
  system.  Find out what these bytes are (quoted-insert in Emacs is not
  100% reliable for this task--it actually does some conversion before
  inserting your bytes.  I had to write a program to find out my cursor
  movement escape sequences.)

Function Maps
  The associative array %functionmap maps pei commands to perl functions.
  For example, when you type "exec cmdfile", then since
  $functionmap{"exec"} = '&execfile', the perl function &execfile will be
  called.  You can write your own functionmap functions.  Upon arriving
  at the functionmap function, the command which invoked it will be in
  the variable $command, and it's arguments will be in $commandarg.
  For example, you could add the following code to the file "pei":
    In the &init function of pei, add:
      $functionmap{"say"} = '&say';
    And then at the end of the pei script put:
      sub say {
	print $commandarg . "\n";
      }
  To see a list of functionmaps already defined, type:
    print sort keys %functionmap

  If your perl function makes reference to any of your country
  variables, then you will need to put it in the tools.pl file and call
  it tools_something.  For an example of how to write a tool like this,
  have a look at the "jack", "rebel", or "fus" tools in tools.pl.  They
  are all small and relatively easy to understand.

Parse Maps
  Often the server sends you information that you want to remember
  internally in pei.  Server output is parsed into pei variables using
  parse maps.  For example, when you type "cen #", you receive a lot
  of information about your sectors, and since there is a parse map for
  the command "cen", as you read the output of "cen #", perl will be
  reading it as well, and parsing it into its internal database.
  Parse maps are defined in the associative array %parsemap.  The
  key of the array is the name of the empire command, and the value
  is the name of a perl function used to parse the output of the data.
  When the perl function is called, the line to be parsed will be in $_.
  See parse.pl for examples.

  To see a list of the commands which are presently parsed, type:
    print %parsemap

Interrupt Handling
  When pei receives a ^C, it enters the interrupt handler &dokill.  &dokill
  then studies the list of subroutines it was in at the time it was interrupted
  and checks to see if the name of any of those subroutines is in the
  associative array %interruptlev.  If there was no interrupt level defined
  for any of the subroutines it was in, pei exits with an error message.
  Otherwise, it picks the subroutine that had the highest interrupt level
  (i.e. the value of $interruptlev{$subroutine}), and executes the interrupt
  handler for that subroutine.  You may add your own interrupt handlers by
  adding a key to the associative array %interruptlev in &init, and then
  adding the code for the handler in &dokill.  However, the interrupt
  handlers already in in pei should be all that you need.
