/*
 *                      T R A N S L A T I O N . C
 *
 *  Different event translation and action functions.
 *
 *  Version      : $Revision: 1.8 $
 *
 *  Created      : Wed Jun  1 03:01:52 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Sun Jul 17 12:39:05 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#if !defined(lint)
static const char *vcid = "$Id: translation.c,v 1.8 1994/07/17 22:21:48 drepper Exp $";
#endif /* lint */

#include <ctype.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Text.h>

#include "scheme.h"
#include "empire.h"

#if !defined(FILENAME_MAX)
/* e.g. sun do not have this, sigh */
#define FILENAME_MAX 1024
#endif /* FILENAME_MAX */

/*
 * global variables
 */
Scheme_Env *globalSchemeEnv;

/*
 * prototypes for local functions
 */
static void newTextInputLine(Widget widget, XEvent *event,
			     String *params, Cardinal *num_params);

/* 
 * local variables
 */
static XtActionsRec globalActions[] = {
    { "newtextinputline", newTextInputLine },
};

/* 
 * exported functions
 */
void
registerActions(void)
{
    XtAppAddActions(
	appContext,
	globalActions,
	XtNumber(globalActions));
}

void
initScheme(void)
{
    static char *fieldIdx[] = {
	[commIdxCiv]    ILSEP "civ-idx",
	[commIdxMil]    ILSEP "mil-idx",
	[commIdxUW]     ILSEP "uw-idx",
	[commIdxFood]   ILSEP "food-idx",
	[commIdxShell]  ILSEP "shell-idx",
	[commIdxGun]    ILSEP "gun-idx",
	[commIdxPetrol] ILSEP "petrol-idx",
	[commIdxIron]   ILSEP "iron-idx",
	[commIdxDust]   ILSEP "dust-idx",
	[commIdxBars]   ILSEP "bars-idx",
	[commIdxOil]    ILSEP "barrel-idx",
	[commIdxLcm]    ILSEP "lcm-idx",
	[commIdxHcm]    ILSEP "hcm-idx",
	[commIdxRad]    ILSEP "rad-idx"
    };
    static char *resourceIdx[] = {
	[resIdxMin]  ILSEP "min-idx",
	[resIdxGold] ILSEP "gold-idx",
	[resIdxOil]  ILSEP "oil-idx",
	[resIdxFert] ILSEP "fert-idx",
	[resIdxUran] ILSEP "uran-idx"
    };
    char *fname;
    char *home;
    char fpath[FILENAME_MAX+1];
    FILE *fp;
    int i;

    globalSchemeEnv = scheme_basic_env();
    GC_expand_hp (40);
    
    /* here the additional definitions and file loading */
    mapSelection = scheme_null;

    scheme_add_global(
	"rest-btu",
        scheme_make_c_integer(&restBTU),
        globalSchemeEnv);
    scheme_add_global(
	"online-min",
        scheme_make_c_integer(&restMin),
        globalSchemeEnv);
    scheme_add_global(
	"treasury",
        scheme_make_c_double(&empire.treasury),
        globalSchemeEnv);

    /* empire struct access */
    for (i=0; i<XtNumber(fieldIdx); i++) {
	if (fieldIdx[i]) {
	    scheme_add_global(
		fieldIdx[i],
	        scheme_make_integer(i),
	        globalSchemeEnv);
	}
    }
    
    for (i=0; i<XtNumber(resourceIdx); i++) {
	if (resourceIdx[i]) {
	    scheme_add_global(
		resourceIdx[i],
	        scheme_make_integer(i),
	        globalSchemeEnv);
	}
    }

    if (!(fname = getenv(SCHEMEFILEVAR))) {
	fname = DEFSCHEMEFILE;
    }
    strcpy(fpath, fname);
    if (!(fp = fopen(fpath, "r"))) {
	if ((home=getenv("HOME"))) {
	    strcpy(fpath, home);
	    strcat(fpath, "/");
	    strcat(fpath, fname);
	    if (!(fp = fopen(fpath, "r"))) {
		fp = NULL;
	    }
	} else {
	    fp = NULL;
	}
    }
    if (fp) {
	Scheme_Object *obj;
	
	while ((obj = scheme_read (fp)) != scheme_eof) {
	    scheme_eval (obj, globalSchemeEnv);
	}
	fclose(fp);
    }
    
}

/*
 * local functions
 */
static void
newTextInputLine(Widget widget, XEvent *event,
		 String *params, Cardinal *num_params)
{
    char lineBuffer[512];
    char *insertPosition = &lineBuffer[1];
    char *lineBegin;
    Widget sourceWidget = XawTextGetSource(widget);
    XawTextBlock lineBlock;
    XawTextPosition posBeg;
    XawTextPosition posEnd;
    XawTextPosition mustRead;
    XawTextPosition haveRead = 0;

    /* clear message line */
    messageStr[0] = '\0';
    showMessageLine();

    posEnd = XawTextSourceScan(
        sourceWidget,
        XawTextGetInsertionPoint(widget),
        XawstEOL,
        XawsdRight,
        1,
        False);
    XawTextSetInsertionPoint(widget, posEnd+1);

    posBeg = XawTextSourceScan(
	sourceWidget,
        posEnd,
        XawstEOL,
        XawsdLeft,
        1,
        False);

    mustRead = posEnd-posBeg;
    while ((haveRead+=XawTextSourceRead(sourceWidget,
					posBeg+haveRead,
					&lineBlock,
					mustRead-haveRead))<mustRead) {
	strcpy(insertPosition, lineBlock.ptr);
	insertPosition = lineBuffer+1+haveRead;
    }

    strcpy(insertPosition, lineBlock.ptr);
    lineBuffer[mustRead+1] = '\0';    /* +1 because of leading '(' */

    for (lineBegin=&lineBuffer[1]; isspace(*lineBegin); lineBegin++);

    if (!*lineBegin) {
	/* empty line */
	return;
    } else if (*lineBegin == '\'') {
	/* pass command direct to server */
	int len = strlen(++lineBegin);    /* ignore ' */

	lineBegin[len]   = '\n';
	lineBegin[len+1] = '\0';
	
	sendCmdStr(NULL, NULL, NULL, lineBegin);
    } else {
	Scheme_Object *obj;

	if (*lineBegin == ';') return;  /* would be only a comment */
	
	if (*lineBegin != '(') {
	    *--lineBegin = '(';
	    strcat(lineBegin, ")");
	}

	obj = scheme_read_str(&lineBegin);

	scheme_tprint(currentEditAdd, NULL, False, "\n");
	
	if (obj != scheme_eos) {
	    obj = SCHEME_CATCH_ERROR(scheme_eval(obj, globalSchemeEnv), 0);
	    if (obj) {
		scheme_tprint(currentEditAdd, obj, False, NULL);
	    }
	} else {
	    message(WARN, "syntax error in expression");
	}
    }
}
		 


/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
