/*
 *                            T I M E R . C
 *
 *  The routine is called in called by a timer.  This is because the 
 *  main loop is in the Xt lib and cannot react on input from the socket.
 *
 *  Version      : $Revision: 1.4 $
 *
 *  Created      : Sat May 28 15:58:26 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Fri Jul 15 01:13:31 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#if !defined(lint)
static const char *vcid = "$Id: timer.c,v 1.4 1994/07/15 00:39:52 drepper Exp $";
#endif /* lint */

#include <assert.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "empire.h"

/*
 * exported variables
 */
XtIntervalId timerId;
XtInputId inputId;
unsigned long timerDelay = CONNECTIONTIMEOUT;

/*
 * exported functions
 */
/* ARGSUSED */
void
inputReady(XtPointer closure, int *pfd, XtInputId *id)
{
    ServerAnswer answerCode;
    char *buf;

    if (getLine(*pfd, &answerCode, &buf) &&
	buf != NULL) {
	if (cmdQueue == NULL) {
	    message(WARN, "%s", buf);
	} else {
	    feedCommand(answerCode, buf);
	}
    }

    if (cmdQueue == NULL) {
	/* now start the timer */
	timerId = XtAppAddTimeOut(appContext, timerDelay, connectTimeOut,
				  NULL);
    }
}

/* ARGSUSED */
void
connectTimeOut(XtPointer data, XtIntervalId *_timer)
{
    assert(cmdQueue == NULL);

    XtRemoveInput(inputId);
    closeConnection();
}

/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
