#ifndef _PROTO_H
#define _PROTO_H
/*
 *                            P R O T O . H
 *
 *  Defines the empire client-server protocol.  Derived from
 *  Dave Pare's proto.h (Revision: 1.7 Date: 89/09/28 02:15:42)
 *
 *  Version      : $Id: proto.h,v 1.2 1994/07/04 13:14:47 drepper Exp $
 *
 *  Created      : Fri May 20 02:47:25 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Mon Jul  4 14:14:38 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * the protocol revision number: if new things are added, bump this 
 */
#define CLIENTPROTO  2

/* functions which can be given to the server */
typedef enum { 
    USER=0,
    COUN,
    QUIT,
    PASS,
    PLAY,
    LIST,
    CMD,
    CTLD,
    WAT,
    VERS
} ServerCommand;

struct EmpCommand {
    const char   *text;
    ServerCommand cmd;
};

/* list which combines all server commands with their text form */
extern struct EmpCommand empCommand[];

/* answers from the server */
typedef enum {
    C_CMDOK=0,
    C_DATA,
    C_INIT,
    C_EXIT,
    C_FLUSH,
    C_NOECHO,
    C_PROMPT,
    C_ABORT,
    C_REDIR,
    C_PIPE,
    C_CMDERR,
    C_BADCMD,
    C_EXECUTE
} ServerAnswer;

/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
#endif /* _PROTO_H */
