/*
 *                             M A I N . C
 *
 *  Main module for X empire client.
 *
 *  Version      : $Revision: 1.8 $
 *
 *  Created      : Thu May 19 21:14:54 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Fri Jul 15 11:40:11 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#if !defined(lint)
static const char *vcid = "$Id: main.c,v 1.8 1994/07/15 11:23:16 drepper Exp $";
#endif /* lint */

#include <getopt.h>
#include <pwd.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/file.h>
#if defined(sgi)
#include <fcntl.h>
#endif

#include "empire.h"
#include "version.h"

/*
 * exported variables
 */
EmpireLand empire;                /* this is the whole world */
int restBTU;                      /* remaining BTUs 'til next update */
int restMin;                      /* remaining minutes */

/*
 * module local variables
 */
static struct option longOpt[] = {
    { "config",  1, NULL, 'c' },
    { "file",    1, NULL, 'f' },
    { "help",    0, NULL, 'h' },
    { "server",  1, NULL, 's' },
    { "port",    1, NULL, 'p' },
    { "version", 0, NULL, 'v' },
    { NULL,      0, NULL,  0  },
};
static char *dataFile     = NULL;

/*
 * local function prototypes
 */
void usage(const char *prog) __attribute__((noreturn));

int
main(int argc, char *argv[])
{
    char *host         = getenv("EMPIREHOST") ?: "";
    char *port         = getenv("EMPIREPORT") ?: "";
    char *country      = getenv("COUNTRY");
    char *player       = getenv("PLAYER");
    char *confFile     = DEFSAVEFILE;
    struct passwd *pwd = getpwuid(getuid());

    if (pwd == NULL) message(FATAL, "You don't exist.  Go away!");

    initScheme();
    
    if (!xinit(&argc, argv)) {
	message(FATAL, "error in X initialization");
    }

    /* get command line arguments */
    while (1) {
	int optidx = 0;
	int c      = getopt_long(argc, argv, "c:f:hp:s:v", longOpt, &optidx);

	if (c == -1) break;

	switch (c) {
	case 'c':
	    confFile = optarg;
	    break;
	case 'f':
	    dataFile = optarg;
	    break;
	case 'h':
	case '?':
	    usage(argv[0]);
	    break;
	case 'p':
	    port = optarg;
	    break;
	case 's':
	    host = optarg;
	    break;
	case 'v':
	    fprintf(stderr, "myXEC, Version %s, (c) 1994 Ulrich Drepper\n",
		    VERSION);
	    exit(0);
	    break;
	default:
	    message(WARNREP, "Invalid getopt value: should not happen");
	    break;
	}
    }

    /* additional arguments: [country [player]] */
    if (optind < argc) {
	country = argv[optind++];

	if (optind < argc) {
	    player = argv[optind++];

	    while (optind < argc)
		message(WARN, "Unknown parameter: %s", argv[optind++]);
	}
    }

    /* first plausibility tests */
    if (country == NULL || country[0] == '\0') {
	message(ERROR, "no country name given");
	exit(1);
    }
    if (player == NULL || player[0] == '\0') {
	message(ERROR, "no player name given");
	exit(1);
    }

    /* deal with non-given information */
    if (!dataFile) {
	if (!(dataFile = getenv(DATAFILEVAR))) {
	    dataFile = DEFDATAFILE;
	}
    }
    
    /* set login information */
    if (!setConnectionData(host, port, pwd->pw_name, country, player)) {
	message(FATAL, "something wrong in login data");
    }

    /* we have to connect because we need information about the game */
    {
#define MAXRETRY 5
	int retry = 0;

	while (retry < MAXRETRY && !doConnect()) retry++;
	
	if (retry >= MAXRETRY) {
	    message(FATAL, "cannot connect to server");
	}
    }

    /* now we can try to get all information about the game */
    initialize(confFile, dataFile);

    /* the world size is known so we can build the map widget */
    if (!initXMap()) exit(1);

    XtAppMainLoop(appContext);

    return 0;
}


void
usage(const char *prog)
{
    fprintf(stderr, 
	    "usage: %s [-h] [-s server] [-p port] [-f datafile] "
	    "[country [player]]\n",
	    prog);
    exit(0);
}


void
saveGameData(void)
{
    int fd;

    if ((fd = creat(dataFile, 0600)) > 0) {
	write(fd, &empire, sizeof(empire));
	write(fd, empire.map,
	      empire.rowBytes*empire.yMapSize*sizeof(EmpireSector));
	close(fd);
    } else {
	perror("saveGameData");
    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
