/*
 *                    S C H E M E _ S E L E C T . C
 *
 *  
 *
 *  Version      : $Revision$
 *
 *  Created      : Fri Jul  1 22:59:37 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Tue Jul  5 00:27:03 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 */
#if !defined(lint)
static const char *vcid = "$Id$";
#endif /* lint */

#include "empire.h"
#include "scheme.h"

/*
 * prototypes for local functions
 */
static Scheme_Object *emp_select(Scheme_Object *form, Scheme_Env *env);

/*
 * local type definitions
 */
enum {
    XLOC, YLOC, OWNER, OLDOWN, DES, NEWTYPE, EFFICIENCY, WORK, MOBILITY,
    MINERALS, OCONTENT, FERTILITY, UCONTENT, CIVILIANS, MILITARY, UW,
    SHELLS, GUNS, PETROLEUM, IRON, DUST, BARS, FOOD, OIL, RAD, LCM, HCM,
    DISTPATH, S_DEL, G_DEL, P_DEL, I_DEL, D_DEL, B_DEL, F_DEL, O_DEL,
    R_DEL, L_DEL, H_DEL, U_DEL, S_DIST, G_DIST, P_DIST, I_DIST, D_DIST,
    B_DIST, F_DIST, O_DIST, R_DIST, L_DIST, H_DIST, U_DIST };

/*
 * local variables
 */
static struct {
    char *name;
    int val;
} itemStruct[] = {
    { "xloc", XLOC },             { "yloc", YLOC },
    { "owner", OWNER },           { "oldown", OLDOWN },
    { "des", DES },               { "newtype", NEWTYPE },
    { "efficiency", EFFICIENCY }, { "work", WORK },
    { "mobility", MOBILITY },     { "minerals", MINERALS },
    { "ocontent", OCONTENT },     { "pcontent", OCONTENT },
    { "fertility", FERTILITY },   { "ucontant", UCONTENT },
    { "civilians", CIVILIANS },   { "military", MILITARY },
    { "uw", UW },                 { "shells", SHELLS },
    { "guns", GUNS },             { "petroleum", PETROLEUM },
    { "iron", IRON },             { "dust", DUST },
    { "bars", BARS },             { "food", FOOD },
    { "oil", OIL },               { "rad", RAD },
    { "lcm", LCM },               { "hcm", HCM },
    { "distpath", DISTPATH },
    { "s-del", S_DEL },           { "g-del", G_DEL },
    { "p-del", P_DEL },           { "i-del", I_DEL },
    { "d-del", D_DEL },           { "b-del", B_DEL },
    { "f-del", F_DEL },           { "o-del", O_DEL },
    { "r-del", R_DEL },           { "l-del", L_DEL },
    { "h-del", H_DEL },           { "u-del", U_DEL },
#if 0
    { "s-del", S_CUT },           { "g-del", G_CUT },
    { "p-del", P_CUT },           { "i-del", I_CUT },
    { "d-del", D_CUT },           { "b-del", B_CUT },
    { "f-del", F_CUT },           { "o-del", O_CUT },
    { "r-del", R_CUT },           { "l-del", L_CUT },
    { "h-del", H_CUT },           { "u-del", U_CUT },
    { "c-dist", C_DIST },         { "m-dist", M_DIST },
#endif
    { "s-dist", S_DIST },         { "g-dist", G_DIST },
    { "p-dist", P_DIST },         { "i-dist", I_DIST },
    { "d-dist", D_DIST },         { "b-dist", B_DIST },
    { "f-dist", F_DIST },         { "o-dist", O_DIST },
    { "r-dist", R_DIST },         { "l-dist", L_DIST },
    { "h-dist", H_DIST },         { "u-dist", U_DIST } };
/*
 * exported functions
 */
void
scheme_init_select(Scheme_Env *env)
{
    int i;

    for (i=0; i<XtNumber(itemStruct); i++) {
	scheme_add_global(
	    itemStruct[i].name,
	    scheme_make_integer(itemStruct[i].val),
	    env);
    }
    
    scheme_add_global("select", scheme_make_syntax(emp_select), env);
}

/*
 * local functions
 */
static Scheme_Object *
emp_select(Scheme_Object *form, Scheme_Env *env)
{
    return scheme_true;
}

/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
