/*
     libscheme	
     Copyright (C) 1994 Brent Benson

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SCHEME_HASH_H
#define SCHEME_HASH_H

struct Scheme_Bucket
{
  char *key;
  void *val;
  struct Scheme_Bucket *next;
};
typedef struct Scheme_Bucket Scheme_Bucket;

struct Scheme_Hash_Table
{
  int size;
  Scheme_Bucket **buckets;
};
typedef struct Scheme_Hash_Table Scheme_Hash_Table;

Scheme_Hash_Table *scheme_hash_table (int size);
void scheme_add_to_table (Scheme_Hash_Table *table, char *key, void *val);
void scheme_change_in_table (Scheme_Hash_Table *table, char *key, void *new);
void *scheme_lookup_in_table (Scheme_Hash_Table *table, char *key);

#endif /* ! SCHEME_HASH_H */
