/*
 *		   S C H E M E _ C O M M A N D . C
 *
 *  Implements parts of the scheme interface like data access and
 *  simple empire commands.
 *
 *  Version      : $Revision: 1.1 $
 *
 *  Created      : Fri Jun 24 02:34:15 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Sun Jul 17 00:52:25 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#if !defined(lint)
static const char *vcid = "$Id: scheme_empcommand.c,v 1.1 1994/07/17 22:32:46 drepper Exp $"
;
#endif /* lint */
#include "empire.h"

/* locals */
static Scheme_Object *emp_all(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_map(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_resource(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_census(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_break(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_nation(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_radar(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_dump(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_add_hilit(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_clear_hilit(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_res_vec(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_cont_vec(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_path_vec(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_cutoff_vec(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_level_vec(int argc, Scheme_Object *argv[]);
static Scheme_Object *emp_donep(int argc, Scheme_Object *argv[]);

static Scheme_Object *constrIntVec(int argc, Scheme_Object *argv[],
				   const char *name, int offset,
				   int low, int high);
static Scheme_Object *constrCharVec(int argc, Scheme_Object *argv[],
				    const char *name, int offset,
				    int low, int high);

/* globals.c */

void
scheme_init_empcommand(Scheme_Env *env)
{
    scheme_add_global ("all", scheme_make_prim (emp_all), env);
    scheme_add_global ("map", scheme_make_prim (emp_map), env);
    scheme_add_global ("resource", scheme_make_prim (emp_resource), env);
    scheme_add_global ("census", scheme_make_prim (emp_census), env);
    scheme_add_global ("break", scheme_make_prim (emp_break), env);
    scheme_add_global ("nation", scheme_make_prim (emp_nation), env);
    scheme_add_global ("dump", scheme_make_prim (emp_dump), env);
    scheme_add_global ("radar", scheme_make_prim (emp_radar), env);

    scheme_add_global ("done?", scheme_make_prim (emp_donep), env);
    /* hiliting */
    scheme_add_global ("hilit", scheme_make_prim (scheme_hilit), env);
    scheme_add_global ("add-hilit", scheme_make_prim (emp_add_hilit), env);
    scheme_add_global ("clear-hilit", scheme_make_prim (emp_clear_hilit), env);

    scheme_add_global ("resource-vec", scheme_make_prim (emp_res_vec), env);
    scheme_add_global ("content-vec", scheme_make_prim (emp_cont_vec), env);
    scheme_add_global ("del-path-vec", scheme_make_prim (emp_path_vec), env);
    scheme_add_global ("del-cutoff-vec",
		       scheme_make_prim (emp_cutoff_vec), env);
    scheme_add_global ("dist-level-vec",
		       scheme_make_prim (emp_level_vec), env);
}

Scheme_Object *
scheme_hilit(int argc, Scheme_Object *argv[])
{
    Scheme_Object *iter = mapSelection;
    Bool doHilit;
    XRectangle bound;
    Bool first = True;
    int rc, cc;
    int x, y;

    SCHEME_ASSERT ((argc==1), "hilit: wrong number of args");
    SCHEME_ASSERT ((SCHEME_BOOLP(argv[0])), "hilit: argument must be boolean");

    doHilit = argv[0] == scheme_true;
    
    while (iter != scheme_null) {
	Scheme_Object *range = SCHEME_CAR(iter);
	iter = SCHEME_CDR(iter);

	for (rc=SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(range));
	     rc<=SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(range));
	     rc++) {
	    for (cc=SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(range));
		 cc<=SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(range));
		 cc++) {

		if (first) {
		    bound.x = cc;
		    bound.width = cc;
		    bound.y = rc;
		    bound.height = rc;

		    first = False;
		} else {
		    bound.x = min(bound.x,cc);
		    bound.width = max(bound.width,cc);
		    bound.y = min(bound.y,rc);
		    bound.height = max(bound.y,rc);
		}

		empire.map[MAP2ARR(cc,rc)].typePixmap = getTypePixmap(
		    MAP2ARRX(cc), MAP2ARRY(rc),
		    empire.map[MAP2ARR(cc,rc)].status, doHilit);
	    }
	}
    }

    if (!first) {
	redisplaySectors(mapWidget,
			 bound.x, bound.y, bound.width, bound.height);
    }
    
    return scheme_true;
}

/* locals */
static Scheme_Object *
emp_all(int argc, Scheme_Object *argv[])
{
    Bool res;
    
    SCHEME_ASSERT ((argc==0 || argc==1), "all: wrong number of arguments");
    SCHEME_ASSERT (argc==0 || SCHEME_RANGEP(argv[0]),
		   "all: arg must be range");
    if (argc==0) {
	res = allCommand(0, 0, empire.xMapSize-1, empire.yMapSize-1);
    } else {
	if (SCHEME_COORDP(argv[0]))
	  {
	    res = allCommand(
	        SCHEME_COORD_VAL_X(argv[0]),
	        SCHEME_COORD_VAL_Y(argv[0]),
	        SCHEME_COORD_VAL_X(argv[0]),
	        SCHEME_COORD_VAL_Y(argv[0]));
          }
        else
          {
	    res = allCommand(
	        SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0])),
	        SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0])),
	        SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0])),
	        SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0])));
          }
    }
	
    return res ? scheme_true : scheme_false;
}

static Scheme_Object *
emp_map(int argc, Scheme_Object *argv[])
{
    Bool res;
    
    SCHEME_ASSERT ((argc==1), "map: wrong number of args");
    SCHEME_ASSERT ((SCHEME_RANGEP(argv[0])), "map: arg must be range");
    if (SCHEME_COORDP(argv[0]))
      {
	res = mapCommand(
	    SCHEME_COORD_VAL_X(argv[0]),
	    SCHEME_COORD_VAL_Y(argv[0]),
	    SCHEME_COORD_VAL_X(argv[0]),
	    SCHEME_COORD_VAL_Y(argv[0]), True);
      }
    else
      {
	res = mapCommand(
	    SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0])),
	    SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0])),
	    SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0])),
	    SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0])), True);
      }
	
    return res ? scheme_true : scheme_false;
}

static Scheme_Object *
emp_dump(int argc, Scheme_Object *argv[])
{
    Bool res;
    
    SCHEME_ASSERT ((argc==1), "dump: wrong number of args");
    SCHEME_ASSERT ((SCHEME_RANGEP(argv[0])), "dump: arg must be range");
    if (SCHEME_COORDP(argv[0]))
      {
	res = dumpCommand(
	    SCHEME_COORD_VAL_X(argv[0]),
	    SCHEME_COORD_VAL_Y(argv[0]),
	    SCHEME_COORD_VAL_X(argv[0]),
	    SCHEME_COORD_VAL_Y(argv[0]),
	    True);
      }
    else
      {
	res = dumpCommand(
	    SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0])),
	    SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0])),
	    SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0])),
	    SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0])),
	    True);
      }
	
    return res ? scheme_true : scheme_false;
}

static Scheme_Object *
emp_resource(int argc, Scheme_Object *argv[])
{
    Bool res;
    
    SCHEME_ASSERT ((argc==1), "resource: wrong number of args");
    SCHEME_ASSERT ((SCHEME_RANGEP(argv[0])),
		   "resource: argument must be range");
    if (SCHEME_COORDP(argv[0]))
      {
	res = resourceCommand(
	    SCHEME_COORD_VAL_X(argv[0]),
	    SCHEME_COORD_VAL_Y(argv[0]),
	    SCHEME_COORD_VAL_X(argv[0]),
	    SCHEME_COORD_VAL_Y(argv[0]),
	    True);
      }
    else
      { 
	res = resourceCommand(
	    SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0])),
	    SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0])),
	    SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0])),
	    SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0])),
            True);
      }
    
    return res ? scheme_true : scheme_false;
}

static Scheme_Object *
emp_census(int argc, Scheme_Object *argv[])
{
    Bool res;
    
    SCHEME_ASSERT ((argc==1), "census: wrong number of args");
    SCHEME_ASSERT ((SCHEME_RANGEP(argv[0])),
		   "census: argument must be range");
    if (SCHEME_COORDP(argv[0]))
      {
	res = censusCommand(
	    SCHEME_COORD_VAL_X(argv[0]),
	    SCHEME_COORD_VAL_Y(argv[0]),
	    SCHEME_COORD_VAL_X(argv[0]),
	    SCHEME_COORD_VAL_Y(argv[0]),
	    True);
      }
    else
      {
	res = censusCommand(
	    SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0])),
	    SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0])),
	    SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0])),
	    SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0])),
            True);
      }

    return res ? scheme_true : scheme_false;
}

static Scheme_Object *
emp_break(int argc, Scheme_Object *argv[])
{
    SCHEME_ASSERT ((argc==0), "break: wrong number of args");
    return breakCommand() ? scheme_true : scheme_false;
}

static Scheme_Object *
emp_nation(int argc, Scheme_Object *argv[])
{
    SCHEME_ASSERT ((argc==0), "nation: wrong number of args");
    return nationCommand() ? scheme_true : scheme_false;
}

static Scheme_Object *
emp_radar(int argc, Scheme_Object *argv[])
{
    Bool res;
    
    SCHEME_ASSERT ((argc==0 || argc==1), "radar: wrong number of args");
    SCHEME_ASSERT ((argc==0 || SCHEME_RANGEP(argv[0])),
		   "radar: arg must be range");

    if (argc==0) {
	res = radarStationCommand(0, 0, empire.xMapSize, empire.yMapSize,
				  True);
    } else {
	if (SCHEME_COORDP(argv[0])) {
	    res = radarStationCommand(
		SCHEME_COORD_VAL_X(argv[0]),
	        SCHEME_COORD_VAL_Y(argv[0]),
	        SCHEME_COORD_VAL_X(argv[0]),
	        SCHEME_COORD_VAL_Y(argv[0]),
	        True);
	} else {
	    res = radarStationCommand(
		SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0])),
	        SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0])),
	        SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0])),
	        SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0])),
                True);
	}
    }

    return res ? scheme_true : scheme_false;
}

static Scheme_Object *
emp_add_hilit(int argc, Scheme_Object *argv[])
{
    int i;
    
    SCHEME_ASSERT((argc>0), "add-hilit: wrong number of args");

    for (i=0; i<argc; i++) {
	if (SCHEME_RANGEP(argv[i])) {
	    if (SCHEME_COORDP(argv[i])) {
		mapSelection = scheme_make_pair(
		    scheme_make_range(
			SCHEME_COORD_VAL_X(argv[i]),
		        SCHEME_COORD_VAL_Y(argv[i]),
		        SCHEME_COORD_VAL_X(argv[i]),
		        SCHEME_COORD_VAL_Y(argv[i])),
	            mapSelection);
	    } else {
		mapSelection = scheme_make_pair(
		    argv[i],
	            mapSelection);
	    }
	} else if (SCHEME_LISTP(argv[i])) {
	    while (!SCHEME_NULLP(argv[i])) {
		Scheme_Object *car = SCHEME_CAR(argv[i]);
		SCHEME_ASSERT(SCHEME_RANGEP(car),
			      "add-hilit: invalid argument %d", i);
		if (SCHEME_COORDP(car)) {
		    mapSelection = scheme_make_pair(
			scheme_make_range(
			    SCHEME_COORD_VAL_X(car),
		            SCHEME_COORD_VAL_Y(car),
		            SCHEME_COORD_VAL_X(car),
		            SCHEME_COORD_VAL_Y(car)),
                        mapSelection);
		} else {
		    mapSelection = scheme_make_pair(
		        car,
	                mapSelection);
		}
		argv[i] = SCHEME_CDR(argv[i]);
		SCHEME_ASSERT(SCHEME_LISTP(argv[i]), "add-hilit: invalid argument %d", i);
	    }
	} else {
	    scheme_signal_error("add-hilit: wrong argument type");
	}
    }
    scheme_hilit(1, &scheme_true);

    return scheme_true;
}

static Scheme_Object *
emp_clear_hilit(int argc, Scheme_Object *argv[])
{
    SCHEME_ASSERT((argc==0), "clear-hilit: wrong number of args");
    
    scheme_hilit(1, &scheme_false);
    mapSelection = scheme_null;

    return scheme_true;
}

static Scheme_Object *
emp_res_vec(int argc, Scheme_Object *argv[])
{
    int cc, rc;
    int cl, ch, rl, rh;
    int idx;
    Scheme_Object *list = scheme_null;
    SCHEME_ASSERT ((argc==1 || argc==2), "resource-vec: wrong number of args");
    SCHEME_ASSERT ((SCHEME_RANGEP(argv[0])),
		   "resource-vec: first arg must be range");
    SCHEME_ASSERT ((argc==1 || SCHEME_INTP(argv[1])),
		   "resource-vec: second arg must be integer");
    SCHEME_ASSERT (SCHEME_INT_VAL(argv[1])>=resIdxMin &&
		   SCHEME_INT_VAL(argv[1])<=resIdxUran,
		   "resource-vec: second arg out of range");

    if (SCHEME_COORDP(argv[0])) {
	cl = ch = SCHEME_COORD_VAL_X(argv[0]);
	rl = rh = SCHEME_COORD_VAL_Y(argv[0]);
    } else {
	cl = SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0]));
	ch = SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0]));
	rl = SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0]));
	rh = SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0]));
    }

    for (rc=rl; rc<=rh; rc++) {
	for (cc=cl; cc<=ch; cc++) {
	    Scheme_Object *elem;

	    if ((even(rc) && odd(cc)) || (odd(rc) && even(cc))) continue;
	    
	    elem = scheme_make_pair(
		scheme_make_coord(cc, rc),
	        scheme_null);
	    
	    idx = MAP2ARR(cc,rc);
	    
	    if (argc==1) {
		int i;

		SCHEME_CDR(elem) =
		    scheme_make_vector(commIdxLast, scheme_null);

		for (i=0; i<=resIdxUran; i++) {
		    SCHEME_VEC_ELS(SCHEME_CDR(elem))[i] = scheme_make_integer(
			empire.map[idx].resource[i]);
		}
	    } else {
		SCHEME_CDR(elem) = scheme_make_integer(
		    empire.map[idx].resource[SCHEME_INT_VAL(argv[1])]);
	    }
	    list = scheme_make_pair(elem, list);
	}
    }

    return list;
}

static Scheme_Object *
emp_cont_vec(int argc, Scheme_Object *argv[])
{
    return constrIntVec(argc, argv, "content-vec",
			XtOffsetOf(EmpireSector, product),
			commIdxCiv, commIdxRad);
}

static Scheme_Object *
emp_path_vec(int argc, Scheme_Object *argv[])
{
    return constrCharVec(argc, argv, "del-path-vec",
			XtOffsetOf(EmpireSector, path),
			commIdxUW, commIdxRad);
}

static Scheme_Object *
emp_cutoff_vec(int argc, Scheme_Object *argv[])
{
    return constrIntVec(argc, argv, "del-cutoff-vec",
			XtOffsetOf(EmpireSector, cutoff),
			commIdxUW, commIdxRad);
}

static Scheme_Object *
emp_level_vec(int argc, Scheme_Object *argv[])
{
    return constrIntVec(argc, argv, "dist-level-vec",
			XtOffsetOf(EmpireSector, level),
			commIdxCiv, commIdxRad);
}

static Scheme_Object *
emp_donep(int argc, Scheme_Object *argv[])
{
    SCHEME_ASSERT((argc==1), "done?: wrong number of args");
    SCHEME_ASSERT((SCHEME_INTP(argv[0])), "done?: arg must be int");

    return lastSerial >= SCHEME_INT_VAL(argv[0]) ? scheme_true : scheme_false;
}

/*
 * without public interface
 */
static Scheme_Object *
constrIntVec(int argc, Scheme_Object *argv[], const char *name, int offset,
	     int low, int high)
{
    int cc, rc;
    int cl, ch, rl, rh;
    int idx;
    Scheme_Object *list = scheme_null;
    SCHEME_ASSERT ((argc==1 || argc==2), "%s: wrong number of args", name);
    SCHEME_ASSERT ((SCHEME_RANGEP(argv[0])), "%s: arg must be range", name);
    SCHEME_ASSERT ((argc==1 || SCHEME_INTP(argv[1])),
		   "%s: second arg must be integer", name);
    SCHEME_ASSERT ((argc==1 || (SCHEME_INT_VAL(argv[1])>=low &&
		                SCHEME_INT_VAL(argv[1])<=high)),
		   "%s: second arg out of range", name);

    if (SCHEME_COORDP(argv[0])) {
	cl = ch = SCHEME_COORD_VAL_X(argv[0]);
	rl = rh = SCHEME_COORD_VAL_Y(argv[0]);
    } else {
	cl = SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0]));
	ch = SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0]));
	rl = SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0]));
	rh = SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0]));
    }

    for (rc=rl; rc<=rh; rc++) {
	for (cc=cl; cc<=ch; cc++) {
	    Scheme_Object *elem;

	    if ((even(rc) && odd(cc)) || (odd(rc) && even(cc))) continue;

	    elem = scheme_make_pair(
		scheme_make_coord(cc, rc),
	        scheme_null);
	    
	    idx = MAP2ARR(cc,rc);
	    
	    if (argc==1) {
		int i;

		SCHEME_CDR(elem) =
		    scheme_make_vector(commIdxLast, scheme_null);

		for (i=low; i<=high; i++) {
		    SCHEME_VEC_ELS(SCHEME_CDR(elem))[i] =
			scheme_make_integer(
			    ((int*)((char*)&empire.map[idx]+offset))[i]);
		}
	    } else {
		SCHEME_CDR(elem) =
		    scheme_make_integer(
			((int*)((char*)&empire.map[idx]+offset))
		            [SCHEME_INT_VAL(argv[1])]);
	    }

	    list = scheme_make_pair(elem, list);
	}
    }

    return list;
}

static Scheme_Object *
constrCharVec(int argc, Scheme_Object *argv[], const char *name, int offset,
	     int low, int high)
{
    int cc, rc;
    int cl, ch, rl, rh;
    int idx;
    Scheme_Object *list = scheme_null;
    SCHEME_ASSERT ((argc==1 || argc==2), "%s: wrong number of args", name);
    SCHEME_ASSERT ((SCHEME_RANGEP(argv[0])), "%s: arg must be range", name);
    SCHEME_ASSERT ((argc==1 || SCHEME_INTP(argv[1])),
		   "%s: second arg must be integer", name);
    SCHEME_ASSERT ((argc==1 || (SCHEME_INT_VAL(argv[1])>=low &&
		                SCHEME_INT_VAL(argv[1])<=high)),
		   "%s: second arg out of range", name);

    if (SCHEME_COORDP(argv[0])) {
	cl = ch = SCHEME_COORD_VAL_X(argv[0]);
	rl = rh = SCHEME_COORD_VAL_Y(argv[0]);
    } else {
	cl = SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_LU(argv[0]));
	ch = SCHEME_COORD_VAL_X(SCHEME_RANGE_VAL_RL(argv[0]));
	rl = SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_LU(argv[0]));
	rh = SCHEME_COORD_VAL_Y(SCHEME_RANGE_VAL_RL(argv[0]));
    }

    for (rc=rl; rc<=rh; rc++) {
	for (cc=cl; cc<=ch; cc++) {
	    Scheme_Object *elem;

	    if ((even(rc) && odd(cc)) || (odd(rc) && even(cc))) continue;

	    elem = scheme_make_pair(
		scheme_make_coord(cc, rc),
	        scheme_null);
	    
	    idx = MAP2ARR(cc,rc);
	    
	    if (argc==1) {
		int i;

		SCHEME_CDR(elem) =
		    scheme_make_vector(commIdxLast, scheme_null);

		for (i=low; i<=high; i++) {
		    SCHEME_VEC_ELS(SCHEME_CDR(elem))[i] =
			scheme_make_char(
			    ((char*)&empire.map[idx]+offset)[i]);
		}
	    } else {
		SCHEME_CDR(elem) =
		    scheme_make_char(
			((char*)&empire.map[idx]+offset)
		            [SCHEME_INT_VAL(argv[1])]);
	    }

	    list = scheme_make_pair(elem, list);
	}
    }

    return list;
}

