/*
     libscheme	
     Copyright (C) 1994 Brent Benson

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "scheme.h"
#include <string.h>

#ifdef NO_GC
#define MALLOC malloc
#else
#define MALLOC GC_malloc
#endif

Scheme_Object *
scheme_alloc_object (void)
{
  Scheme_Object *object;

  object = (Scheme_Object *) scheme_malloc (sizeof (Scheme_Object));
  return (object);
}

void *
scheme_malloc (size_t size)
{
  void *space;

  space = MALLOC (size);
  SCHEME_ASSERT ((space != 0), "memory allocation failure");
  return (space);
}

void *
scheme_calloc (size_t num, size_t size)
{
  void *space;
  
  space = MALLOC (num*size);
#ifdef NO_GC
  memset (space, 0, (num*size));
#endif
  SCHEME_ASSERT ((space != 0), "memory allocation failure");
  return (space);
}

char *
scheme_strdup (char *str)
{
  char *new;

  new = scheme_malloc ((strlen (str) + 1) * sizeof (char));
  strcpy (new, str);
  return (new);
}
