/*
     libscheme	
     Copyright (C) 1994 Brent Benson

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "scheme.h"

main()
{
  Scheme_Env *global_env;
  Scheme_Object *obj;

  global_env = scheme_basic_env ();
  GC_expand_hp (40);
  do
    {
      printf ("> ");
      obj = scheme_read (stdin);
      if (obj == scheme_eof)
	{
	  printf ("\n; done\n");
	  exit (0);
	}
      obj = SCHEME_CATCH_ERROR(scheme_eval (obj, global_env),0);
      if (obj)
	{
	  scheme_write (stdout, obj);
	  printf ("\n");
	}
    }
  while ( 1 );
}
