/*
 *                             I N I T . C
 *
 *  Handles all initialization of global game data.  The data can be
 *  stored local in an init file or read from the server.  On Program exit
 *  an init file with actual data is created.
 *
 *  Version      : $Revision: 1.8 $
 *
 *  Created      : Sat May 21 01:18:04 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Fri Jul 15 21:40:52 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#if !defined(lint)
static const char *vcid = "$Id: init.c,v 1.8 1994/07/15 21:48:37 drepper Exp $";
#endif /* lint */

#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/file.h>

#include "empire.h"

/*
 * Prototypes for local functions 
 */
static Bool readInitfile(FILE *fp);

/*
 * exported functions
 */
void
initialize(const char *initfile, const char *dataFile)
{
    FILE *ifp;
    int fd;
    Bool ret = False;
    int i;

    if (initfile != NULL && initfile[0] != '\0' &&
	(ifp = fopen(initfile, "r")) != NULL) {
	readInitfile(ifp);
	fclose(ifp);
    }

    if (dataFile != NULL && dataFile[0] != '\0' &&
	(fd = open(dataFile, O_RDONLY)) > 0) {
	if (read(fd, &empire, sizeof(empire)) == sizeof(empire)) {
	
	    empire.map = (EmpireSector*)calloc(empire.rowBytes*empire.yMapSize,
					       sizeof(EmpireSector));
	    if (!empire.map) {
		message(FATAL, "out of memory\ninitialization failed");
		/* NOTREACHED */
	    }

	    if (read(fd, empire.map,
		     empire.rowBytes*empire.yMapSize*sizeof(EmpireSector)) ==
		empire.rowBytes*empire.yMapSize*sizeof(EmpireSector)) {
		/* empire.map[i].typePixmap will initialized later */
		
		ret = True;
		/* we are able to draw the map */
		gotMap = True;
	    }
	}
	close(fd);
    }

    if (!ret) {
	if (!scanVersion()) {
	    message(FATALREP, "initialization failed");
	    /* NOTREACHED */
	}

	/* create the map data structure */
	/* the world size is known */
	empire.rowBytes = empire.xMapSize/2;

	empire.map = (EmpireSector*)calloc(empire.rowBytes*empire.yMapSize,
					   sizeof(EmpireSector));
	if (!empire.map) {
	    message(FATAL, "out of memory\ninitialization failed");
	    /* NOTREACHED */
	}

	empire.isBroken = False;
	for (i=0; i<empire.yMapSize*empire.rowBytes; i++) {
	    empire.map[i].status = NobodiesSector;
	    empire.map[i].typeChar = ' ';
	    empire.map[i].status = NobodiesSector;
	    empire.map[i].typePixmap = XtUnspecifiedPixmap;
	    memset(empire.map[i].path, '.', commIdxLast);
	}

	if (!allCommand(0, 0, empire.xMapSize-1, empire.yMapSize-1)) {
	    message(ERROR, "cannot get initial data");
	}
    }
}

/*
 * local functions
 */
static Bool
readInitfile(FILE *fp)
{
    return True;
}

/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
