/*
 *                              A L L . C
 *
 *  Sends all commands for refreshing all internal data.
 *
 *  Version      : $Revision: 1.6 $
 *
 *  Created      : Sun Jul  3 11:18:08 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Thu Jul 14 15:55:12 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#if !defined(lint)
static const char *vcid = "$Id: all.c,v 1.6 1994/07/14 14:55:30 drepper Exp $";
#endif /* lint */

#include <assert.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>

#include "empire.h"

/*
 * prototypes of local functions
 */
static void commandInitAll(void);
static void allEditAdd(Bool active, XawTextBlock *textBlock, Bool aysnc);
static void callbackAll(Widget widget, XtPointer closure,
                        XtPointer callData);
static void allNotify(Widget w, XEvent *event, String *params,
                      Cardinal *numParams);

/*
 * local variables
 */
static Widget allPopup;
static Widget form;
static Widget sectorText;
static Widget okButton;
static void (*oldEditAdd)(Bool, XawTextBlock *, Bool);

/*
 * exported functions
 */
void
queryCommandAll(void)
{
    static Bool firstCall = True;
    Position fx, fy;
    Position x, y;

    if (firstCall) {
        commandInitAll();
        firstCall = False;
    }

    XtVaGetValues(
        commandForm,
        XtNx, &fx,
        XtNy, &fy,
        NULL);

    XtVaGetValues(
        horizPane,
        XtNx, &x,
        XtNy, &y,
        NULL);

    XtTranslateCoords(
        topLevel,
        x+fx, y+fy,
        &x, &y);

    XtVaSetValues(
        allPopup,
        XtNx, x,
        XtNy, y,
        NULL);

    /* prepare edit widget communication */
    oldEditAdd = currentEditAdd;
    oldEditAdd(False, NULL, False);

    currentEditAdd = allEditAdd;
    currentEditAdd(True, NULL, False);
    
    XawTextSetInsertionPoint(sectorText, 0);
    XtVaSetValues(
        sectorText,
        XtNstring, "",
        NULL);

    XtPopup(allPopup, XtGrabNonexclusive);
    XtAddGrab(showViewport, False, False);
}

Bool
allCommand(int xl, int yu, int xr, int yl)
{
    return
	dumpCommand(xl, yu, xr, yl, False) &&
	censusCommand(xl, yu, xr, yl, False) &&
	produceCommand(xl, yu, xr, yl, False) &&
	mapCommand(xl, yu, xr, yl, False) &&
	radarStationCommand(xl, yu, xr, yl, False) &&
	nationCommand();  /* should be the last */
}

/*
 * local functions
 */
static void
commandInitAll(void)
{
    static String textTranslations = 
        "#override\n"
        "<Key>Return: allNotify()\n"
        "<Key>Linefeed: allNotify()\n"
        "Ctrl<Key>M: allNotify()\n"
        "Ctrl<Key>J: allNotify()\n";
    static XtActionsRec defaultAction[1] = {
        { "allNotify", allNotify },
    };
    XtTranslations textTrans;
    Widget tmp;

    XtAppAddActions(appContext, defaultAction, 1);
    textTrans = XtParseTranslationTable(textTranslations);

    allPopup =  XtVaCreatePopupShell(
        "allpopupshell",
        topLevelShellWidgetClass,
        topLevel,
        NULL);
    form = XtVaCreateManagedWidget(
        "form",
        formWidgetClass,
        allPopup,
        NULL);
    tmp = XtVaCreateManagedWidget(
        "all",
        labelWidgetClass,
        form,
        NULL);
    tmp = XtVaCreateManagedWidget(
        "sectorlabel",
        labelWidgetClass,
        form,
        NULL);
    sectorText = XtVaCreateManagedWidget(
        "sectortext",
        asciiTextWidgetClass,
        form,
        XtNeditType, XawtextEdit,
        XtNtranslations, textTrans,
        NULL);

    okButton = XtVaCreateManagedWidget(
        "OK",
        commandWidgetClass,
        form,
        NULL);
    XtAddCallback(
        okButton,
        XtNcallback, callbackAll,
        (XtPointer)True);
    tmp = XtVaCreateManagedWidget(
        "Cancel",
        commandWidgetClass,
        form,
        NULL);
    XtAddCallback(
        tmp,
        XtNcallback, callbackAll,
        (XtPointer)False);

    XtRealizeWidget(allPopup);
}

/* ARGSUSED */
static void
allEditAdd(Bool active, XawTextBlock *textBlock, Bool async)
{
    assert(async==False);
    if (textBlock) {
        XtVaSetValues(
            sectorText,
            XtNstring, textBlock->ptr,
            NULL);
        XawTextSetInsertionPoint(sectorText, strlen(textBlock->ptr));
    } else {
        XawTextDisplayCaret(sectorText, active);
        if (active) {
            XtSetKeyboardFocus(form, sectorText);
            XtSetKeyboardFocus(vertPane, sectorText);
        }
    }
}

static void
callbackAll(Widget widget, XtPointer closure, XtPointer callData)
{
    XtPopdown(allPopup);

    currentEditAdd(False, NULL, False);
    currentEditAdd = oldEditAdd;
    oldEditAdd(True, NULL, False);
    
    if ((Bool)closure) {
        char *sector;
        int x1, y1, x2, y2;

        XtVaGetValues(
            sectorText,
            XtNstring, &sector,
            NULL);

        if (strToRange(&sector, &x1, &y1, &x2, &y2)) {
            allCommand(x1, y1, x2, y2);
        }
    }
}

/* ARGSUSED */
static void
allNotify(Widget w, XEvent *event, String *params, Cardinal *numParams)
{
    XtCallActionProc(okButton, "set", NULL, NULL, 0);
    XtCallActionProc(okButton, "notify", NULL, NULL, 0);
    XtCallActionProc(okButton, "unset", NULL, NULL, 0);
}

/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
