#ifndef _ContentP_h
#define _ContentP_h
/*
 *                         C O N T E N T P . H
 *
 *  Widget to display empire informations.
 *
 *  Version      : $Id: ContentP.h,v 1.4 1994/07/11 01:45:45 drepper Exp $
 *
 *  Created      : Thu Jun 23 15:10:55 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Mon Jul 11 02:30:19 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Copyright (C) 1994 Ulrich Drepper
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "Content.h"
#include <X11/Xaw/SimpleP.h>
#include "empire.h"

/* New fields for the Content widget class record */

typedef struct {int foo;} ContentClassPart;

/* Full class record declaration */
typedef struct _ContentClassRec {
    CoreClassPart       core_class;
    SimpleClassPart     simple_class;
    ContentClassPart    content_class;
} ContentClassRec;

extern ContentClassRec contentClassRec;

/* New fields for the Content widget record */
typedef struct {
    /* resources */
    Pixel       foreground;
    Pixel       shade_color;
    Pixel       hilit_foreground;
    Pixel       hilit_background;
    XFontStruct *font;
    XFontSet    fontset;
    Dimension   internal_width;
    Dimension   internal_height;
    Boolean     resize;
    unsigned char encoding;
    EmpireSector *sector;
    EmpireLand  *world;
    
    /* private state */
    GC          normalGC;
    GC          stippleGC;
    GC          hilitGC;
    Pixmap      stipple;
    int         xHexa;
    int         yHexa;
    int         yStop;
    int         ySectMiscHeader;
    int         ySectMisc;
    int         xSectMisc[6];
    int         yResourceHeader;
    int         yResource;
    int         xResource[5];
    int         xDistSectHeader;
    int         xDistSect;
    int         yLine1;
    int         yCommHeader;
    int         yFirstComm;
    int         xCommCol;
    int         xContCol;
    int         xDelCol;
    int         xDistCol;
    int         xUseCol;
    int         xMaxCol;
    int         xSector;
    int         ySector;
    int         yLine2 ;
    int         yGameHeader;
    int         yGameData;
    int         xGameVal;
    int         xGameFact;
    int         xTreaCol;
    int         xMRes;
    int         xCommCol2;
    int         xDataCol2;
} ContentPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _ContentRec {
    CorePart    core;
    SimplePart  simple;
    ContentPart   content;
} ContentRec;


/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
#endif /* ContentP_h */
