#ifndef _Content_h
#define _Content_h
/*
 *                          C O N T E N T . H
 *
 *  Widget to display empire informations.
 *
 *  Version      : $Id: Content.h,v 1.4 1994/07/11 01:46:04 drepper Exp $
 *
 *  Created      : Thu Jun 23 15:06:01 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Mon Jul 11 02:30:17 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Copyright (C) 1994 Ulrich Drepper
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <X11/Xaw/Simple.h>

/* Resources:

 Name                Class              RepType         Default Value
 ----                -----              -------         -------------
 background          Background         Pixel           XtDefaultBackground
 border              BorderColor        Pixel           XtDefaultForeground
 borderWidth         BorderWidth        Dimension       1
 cursor              Cursor             Cursor          None
 cursorName          Cursor             String          NULL
 destroyCallback     Callback           XtCallbackList  NULL
 encoding            Encoding           unsigned char   XawTextEncoding8bit
 font                Font               XFontStruct*    XtDefaultFont
 foreground          Foreground         Pixel           XtDefaultForeground
 height              Height             Dimension       text height
 hilitBackground     HilitBG            Pixel           XtDefaultBackground
 hilitForeground     HilitFG            Pixel           XtDefaultForeground
 insensitiveBorder   Insensitive        Pixmap          Gray
 internalHeight      Height             Dimension       2
 internalWidth       Width              Dimension       4
 mappedWhenManaged   MappedWhenManaged  Boolean         True
 pointerColor        Foreground         Pixel           XtDefaultForeground
 pointerColorBackground Background      Pixel           XtDefaultBackground
 sensitive           Sensitive          Boolean         True
 shadeColor          ShadeColor         Pixel           XtDefaultBackground
 width               Width              Dimension       text width
 x                   Position           Position        0
 y                   Position           Position        0

 */

#define XawTextEncoding8bit     0
#define XawTextEncodingChar2b   1

#define XtNencoding "encoding"
#define XtCEncoding "Encoding"

#define XtNhilitBackground "hilitBackground"
#define XtNhilitForeground "hilitForeground"
#define XtNsector "sector"
#define XtNshadeColor "shadeColor"
#define XtNworld "world"
#define XtCHilitBG "HilitBG"
#define XtCHilitFG "HilitFG"
#define XtCEmpireSector "EmpireSector"
#define XtCShadeColor "ShadeColor"
#define XtCEmpireWorld "EmpireWorld"

#ifndef XtNfontSet
#define XtNfontSet "fontSet"
#endif

#ifndef XtCFontSet
#define XtCFontSet "FontSet"
#endif

#ifndef _XtStringDefs_h_
#define XtNforeground "foreground"
#define XtNfont "font"
#define XtNinternalWidth "internalWidth"
#define XtNinternalHeight "internalHeight"
#endif

/* Class record constants */

extern WidgetClass contentWidgetClass;

typedef struct _ContentClassRec *ContentWidgetClass;
typedef struct _ContentRec      *ContentWidget;


/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
#endif /* _Content_h */
