/*
 *                          C O N T E N T . C
 *
 *  Widget to display empire information.
 *
 *  Version      : $Revision: 1.7 $
 *
 *  Created      : Thu Jun 23 15:15:48 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Last modified: Sat Jul 16 21:46:22 1994
 *  Author       : Ulrich Drepper <drepper@mydec>
 *
 *  Copyright (C) 1994 Ulrich Drepper
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#if !defined(lint)
static const char *vcid = "$Id: Content.c,v 1.7 1994/07/17 22:26:09 drepper Exp $";
#endif /* lint */

#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xos.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>

#include "ContentP.h"

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

#define offset(field) XtOffsetOf(ContentRec, field)
static XtResource resources[] = {
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
        offset(content.foreground), XtRString, XtDefaultForeground},
    {XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
        offset(content.font),XtRString, XtDefaultFont},
    {XtNfontSet,  XtCFontSet, XtRFontSet, sizeof(XFontSet ),
        offset(content.fontset),XtRString, XtDefaultFontSet},
    {XtNencoding, XtCEncoding, XtRUnsignedChar, sizeof(unsigned char),
        offset(content.encoding), XtRImmediate, (XtPointer)XawTextEncoding8bit},
    {XtNinternalWidth, XtCWidth, XtRDimension,  sizeof(Dimension),
        offset(content.internal_width), XtRImmediate, (XtPointer)4},
    {XtNinternalHeight, XtCHeight, XtRDimension, sizeof(Dimension),
        offset(content.internal_height), XtRImmediate, (XtPointer)2},
    {XtNsector, XtCEmpireSector, XtRString, sizeof(EmpireSector *),
        offset(content.sector), XtRImmediate, NULL},
    {XtNworld, XtCEmpireWorld, XtRString, sizeof(EmpireLand *),
        offset(content.world), XtRImmediate, NULL},
    {XtNshadeColor, XtCShadeColor, XtRPixel, sizeof(Pixel),
        offset(content.shade_color), XtRString, XtDefaultBackground},
    {XtNhilitForeground, XtCHilitFG, XtRPixel, sizeof(Pixel),
        offset(content.hilit_foreground), XtRString, XtDefaultForeground},
    {XtNhilitBackground, XtCHilitBG, XtRPixel, sizeof(Pixel),
        offset(content.hilit_background), XtRString, XtDefaultBackground},
};
#undef offset

static void Initialize(Widget request, Widget new, ArgList args,
		       Cardinal *num_args);
static void Redisplay(Widget gw, XEvent *event, Region region);

ContentClassRec contentClassRec = {
  {
/* core_class fields */
    /* superclass               */      (WidgetClass) &simpleClassRec,
    /* class_name               */      "Content",
    /* widget_size              */      sizeof(ContentRec),
    /* class_initialize         */      NULL,
    /* class_part_initialize    */      NULL,
    /* class_inited             */      FALSE,
    /* initialize               */      Initialize,
    /* initialize_hook          */      NULL,
    /* realize                  */      XtInheritRealize,
    /* actions                  */      NULL,
    /* num_actions              */      0,
    /* resources                */      resources,
    /* num_resources            */      XtNumber(resources),
    /* xrm_class                */      NULLQUARK,
    /* compress_motion          */      TRUE,
    /* compress_exposure        */      TRUE,
    /* compress_enterleave      */      TRUE,
    /* visible_interest         */      FALSE,
    /* destroy                  */      NULL,
    /* resize                   */      NULL,
    /* expose                   */      Redisplay,
    /* set_values               */      NULL,
    /* set_values_hook          */      NULL,
    /* set_values_almost        */      XtInheritSetValuesAlmost,
    /* get_values_hook          */      NULL,
    /* accept_focus             */      NULL,
    /* version                  */      XtVersion,
    /* callback_private         */      NULL,
    /* tm_table                 */      NULL,
    /* query_geometry           */      NULL,
    /* display_accelerator      */      XtInheritDisplayAccelerator,
    /* extension                */      NULL
  },
/* Simple class fields initialization */
  {
    /* change_sensitive         */      XtInheritChangeSensitive
  },
/* Content class fields initialization */
  {
    /* ignore                   */      0
  }
};
WidgetClass contentWidgetClass = (WidgetClass)&contentClassRec;
/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/
static void
getNormalGc(ContentWidget cw)
{
    XGCValues values;

    values.foreground = cw->content.foreground;
    values.background = cw->core.background_pixel;
    values.font       = cw->content.font->fid;
    values.function   = GXcopy;

#if XtSpecificationRelease >= 6
    if (cw->simple.international == True)
	/* Since Xmb/wcDrawString eats the font, I must use XtAllocateGC. */
	cw->content.normalGC = XtAllocateGC(
	    (Widget)cw, 0,
            (unsigned) GCForeground|GCBackground|GCFunction,
	    &values, GCFont, 0 );
    else
#endif
        cw->content.normalGC = XtGetGC(
	    (Widget)cw,
	    (unsigned) GCForeground|GCBackground|GCFunction|GCFont,
            &values);

    values.foreground = cw->content.hilit_foreground;
    values.background = cw->content.hilit_background;

#if XtSpecificationRelease >= 6
    if (cw->simple.international == True)
	/* Since Xmb/wcDrawString eats the font, I must use XtAllocateGC. */
	cw->content.hilitGC = XtAllocateGC(
	    (Widget)cw, 0,
            (unsigned) GCForeground|GCBackground|GCFunction,
	    &values, GCFont, 0 );
    else
#endif
        cw->content.hilitGC = XtGetGC(
	    (Widget)cw,
	    (unsigned) GCForeground|GCBackground|GCFunction|GCFont,
            &values);
}

static void
getStippleGc(ContentWidget cw)
{
#include "X11/bitmaps/gray3"
    XGCValues values;

    cw->content.stipple = XCreateBitmapFromData(
	XtDisplay(cw),
        RootWindowOfScreen(XtScreen(cw)),
        gray3_bits,
        gray3_width, gray3_height);

    values.foreground = isMonoApp ? cw->content.foreground
	                          : cw->content.shade_color;
    values.background = cw->core.background_pixel;
    values.font       = cw->content.font->fid;
    values.stipple    = cw->content.stipple;
    values.fill_style = isMonoApp ? FillStippled : FillSolid;;

#if XtSpecificationRelease >= 6
    if (cw->simple.international == True)
	/* Since Xmb/wcDrawString eats the font, I must use XtAllocateGC. */
        cw->content.stippleGC = XtAllocateGC(
	    (Widget)cw, 0,
            (unsigned) GCForeground|GCBackground|GCStipple|GCFillStyle,
	    &values, GCFont, 0 );
    else
#endif
        cw->content.stippleGC = XtGetGC(
	    (Widget)cw,
	    (unsigned) GCForeground|GCBackground|GCFont|GCStipple|GCFillStyle,
            &values);
}

/* ARGSUSED */
static void
Initialize(Widget request, Widget new, ArgList args,
	   Cardinal *num_args)
{
    ContentWidget cw = (ContentWidget)new;
    int charWidth;
    int charHeight;

    getNormalGc(cw);
    getStippleGc(cw);
    
    charWidth = cw->content.font->max_bounds.rbearing;
    charHeight= cw->content.font->ascent+cw->content.font->descent;
    
    cw->content.xHexa = cw->content.internal_width;
    cw->content.yHexa = cw->content.internal_height;

    cw->content.xSector = cw->content.xHexa + HEXAPIXMAPWIDTH+1 +
	cw->content.internal_width;
    cw->content.ySector = cw->content.yHexa + cw->content.font->ascent;

    cw->content.yStop = cw->content.ySector + charHeight +
	cw->content.internal_height;

    cw->content.ySectMiscHeader = cw->content.yHexa + HEXAPIXMAPHEIGHT+1 +
	cw->content.internal_height + charHeight;
    cw->content.ySectMisc = cw->content.ySectMiscHeader + charHeight;
    
    cw->content.xSectMisc[0] = cw->content.internal_width + 4*charWidth;
    cw->content.xSectMisc[1] = cw->content.xSectMisc[0] + 4*charWidth;
    cw->content.xSectMisc[2] = cw->content.xSectMisc[1] + 5*charWidth;
    cw->content.xSectMisc[3] = cw->content.xSectMisc[2] + 6*charWidth;
    cw->content.xSectMisc[4] = cw->content.xSectMisc[3] + 8*charWidth;
    cw->content.xSectMisc[5] = cw->content.xSectMisc[4] + 5*charWidth;
    
    cw->content.yResourceHeader = cw->content.ySectMisc + charHeight;
    cw->content.yResource = cw->content.yResourceHeader + charHeight;
    cw->content.xResource[0] = cw->content.internal_width + 3*charWidth;
    cw->content.xResource[1] = cw->content.xResource[0] + 5*charWidth;
    cw->content.xResource[2] = cw->content.xResource[1] + 4*charWidth;
    cw->content.xResource[3] = cw->content.xResource[2] + 5*charWidth;
    cw->content.xResource[4] = cw->content.xResource[3] + 5*charWidth;
    cw->content.xDistSectHeader = cw->content.xResource[4] + 10*charWidth;
    cw->content.xDistSect = cw->content.xResource[4] + 10*charWidth;
    
    cw->content.yLine1 = cw->content.yResource + cw->content.internal_height;

    cw->core.width = max(cw->core.width,
			 cw->content.xDistSect+2*charWidth);

    cw->content.yCommHeader = cw->content.yLine1+cw->content.font->ascent+
	cw->content.internal_height;

    cw->content.yFirstComm = cw->content.yCommHeader+charHeight+
	cw->content.internal_height;

    cw->content.xCommCol = cw->content.internal_width+4*charWidth;
    cw->content.xContCol = cw->content.xCommCol+5*charWidth;
    cw->content.xDelCol  = cw->content.xContCol+7*charWidth;
    cw->content.xDistCol = cw->content.xDelCol+5*charWidth;
    cw->content.xUseCol  = cw->content.xDistCol+5*charWidth;
    cw->content.xMaxCol  = cw->content.xUseCol+6*charWidth;

    cw->content.yLine2 =  cw->content.yFirstComm+charHeight*13 +
	cw->content.internal_height;
    
    cw->content.yGameHeader = cw->content.yLine2 +
	cw->content.internal_height + charHeight;
    cw->content.yGameData   = cw->content.yGameHeader + charHeight;
    
    cw->content.xGameVal = cw->content.xCommCol + 7*charWidth;
    cw->content.xGameFact = cw->content.xGameVal + 8*charWidth;
    cw->content.xTreaCol = cw->content.xCommCol + 12*charWidth;
    cw->content.xMRes = cw->content.xCommCol + 9*charWidth;
    cw->content.xCommCol2 = cw->content.xTreaCol + 8*charWidth;
    cw->content.xDataCol2 = cw->content.xCommCol2 +8*charWidth;
    
    if (cw->core.height == 0)
	cw->core.height = cw->content.yGameData+charHeight*5+
	    cw->content.internal_height;

}

static void
TextOut(ContentWidget cw, int x, int y, Bool atLeft, char *fmt, ...)
{
    va_list ap;
    char buffer[100];
    int disp = 0;
    int len;
    
    va_start(ap, fmt);
    
    vsprintf(buffer, fmt, ap);
    len = strlen(buffer);

    if (atLeft) {
	disp = XTextWidth(cw->content.font, buffer, len);
    }
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        x-disp, y,
        buffer, len);
    
    va_end(ap);
}

static void
Redisplay(Widget gw, XEvent *event, Region region)
{
    static struct {
	char *name;
	int len;
    } comm[] = { { "civ", 3 }, { "mil", 3 }, { "uw", 2 }, { "food", 4 },
		 { "shel", 4 }, { "gun", 3 }, { "pet", 3 }, { "iron", 4 },
		 { "dust", 4 }, { "bars", 4 }, { "oil", 3 }, { "lcm", 3 },
		 { "hcm", 3 }, { "rad", 3 }};
    static struct {
	char *name;
	int len;
    } gameData[] = { { "tech", 4 }, { "edu", 3 }, { "res", 3 }, { "hap", 3 },
                     { "trea", 4 }, { "mRes", 4 }};
    ContentWidget cw = (ContentWidget)gw;
    int charHeight = cw->content.font->ascent+cw->content.font->descent;
    int charWidth = cw->content.font->max_bounds.rbearing;
    int disp;
    int i;
    int idx;
    Bool force;

    disp =  XTextWidth(cw->content.font, "eff", 3);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xSectMisc[0]-disp, cw->content.ySectMiscHeader,
        "eff", 3);

    disp =  XTextWidth(cw->content.font, "mob", 3);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xSectMisc[1]-disp, cw->content.ySectMiscHeader,
        "mob", 3);

    disp =  XTextWidth(cw->content.font, "work", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xSectMisc[2]-disp, cw->content.ySectMiscHeader,
        "work", 4);

    disp =  XTextWidth(cw->content.font, "avail", 5);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xSectMisc[3]-disp, cw->content.ySectMiscHeader,
        "avail", 5);

    disp =  XTextWidth(cw->content.font, "cost", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xSectMisc[4]-disp, cw->content.ySectMiscHeader,
        "cost", 4);

    disp =  XTextWidth(cw->content.font, "p.e.", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xSectMisc[5]-disp, cw->content.ySectMiscHeader,
        "p.e.", 4);

    disp =  XTextWidth(cw->content.font, "min", 3);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xResource[0]-disp, cw->content.yResourceHeader,
        "min", 3);

    disp =  XTextWidth(cw->content.font, "gold", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xResource[1]-disp, cw->content.yResourceHeader,
        "gold", 4);
    
    disp =  XTextWidth(cw->content.font, "oil", 3);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xResource[2]-disp, cw->content.yResourceHeader,
        "oil", 3);
    
    disp =  XTextWidth(cw->content.font, "fert", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xResource[3]-disp, cw->content.yResourceHeader,
        "fert", 4);
    
    disp =  XTextWidth(cw->content.font, "uran", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xResource[4]-disp, cw->content.yResourceHeader,
        "uran", 4);

    disp =  XTextWidth(cw->content.font, "dist x,y", 8);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xDistSectHeader-disp, cw->content.yResourceHeader,
        "dist x,y", 8);

    XDrawLine(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        0, cw->content.yLine1,
        cw->core.width, cw->content.yLine1);
    
    disp = XTextWidth(cw->content.font, "cont", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xContCol-disp, cw->content.yCommHeader,
        "cont", 4);

    disp = XTextWidth(cw->content.font, "del", 3);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xDelCol-disp, cw->content.yCommHeader,
        "del", 3);
    
    disp = XTextWidth(cw->content.font, "dist", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xDistCol-disp, cw->content.yCommHeader,
        "dist", 4);

    disp = XTextWidth(cw->content.font, "use", 3);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xUseCol-disp, cw->content.yCommHeader,
        "use", 3);

    disp = XTextWidth(cw->content.font, "max", 3);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xMaxCol-disp, cw->content.yCommHeader,
        "max", 3);

    for (i=0; i<XtNumber(comm); i++) {
	if (even(i)) {
	    XFillRectangle(
		XtDisplay(cw),
	        XtWindow(cw),
	        cw->content.stippleGC,
	        0, cw->content.yFirstComm+(i-1)*charHeight+2,
	        cw->core.width, charHeight);
	}
	disp = XTextWidth(cw->content.font, comm[i].name, comm[i].len);
	XDrawString(
	    XtDisplay(cw),
            XtWindow(cw),
            cw->content.normalGC,
            cw->content.xCommCol-disp,
	    cw->content.yFirstComm+i*charHeight,
            comm[i].name, comm[i].len);
    }
    
    XDrawLine(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        0, cw->content.yLine2,
        cw->core.width, cw->content.yLine2);
    
    disp = XTextWidth(cw->content.font, "value", 5);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xGameVal-disp, cw->content.yGameHeader,
        "value", 5);

    disp = XTextWidth(cw->content.font, "factor", 6);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xGameFact-disp, cw->content.yGameHeader,
        "factor", 6);

    disp = XTextWidth(cw->content.font, "will", 4);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xUseCol-disp, cw->content.yGameHeader,
        "will", 4);

    disp = XTextWidth(cw->content.font, "max", 3);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xMaxCol-disp, cw->content.yGameHeader,
        "max", 3);
    
    for (i=0; i<XtNumber(gameData); i++) {
	if (even(i)) {
	    XFillRectangle(
		XtDisplay(cw),
	        XtWindow(cw),
	        cw->content.stippleGC,
	        0, cw->content.yGameData+(i-1)*charHeight+2,
	        cw->core.width, charHeight);
	}
	disp = XTextWidth(cw->content.font, gameData[i].name, gameData[i].len);
	XDrawString(
	    XtDisplay(cw),
            XtWindow(cw),
            cw->content.normalGC,
            cw->content.xCommCol-disp,
	    cw->content.yGameData+i*charHeight,
            gameData[i].name, gameData[i].len);
    }
    
    disp = XTextWidth(cw->content.font, "savePop", 7);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xCommCol2-disp, cw->content.yGameData+4*charHeight,
        "savePop", 7);
    
    disp = XTextWidth(cw->content.font, "maxPop", 6);
    XDrawString(
	XtDisplay(cw),
        XtWindow(cw),
        cw->content.normalGC,
        cw->content.xCommCol2-disp, cw->content.yGameData+5*charHeight,
        "maxPop", 6);
    
    if (cw->content.world) {
	TextOut(cw,
		cw->content.xGameVal, cw->content.yGameData,
		True, "%3.2f", cw->content.world->technology);
	TextOut(cw,
		cw->content.xGameVal, cw->content.yGameData+charHeight,
		True, "%3.2f", cw->content.world->education);
	TextOut(cw,
		cw->content.xGameVal, cw->content.yGameData+2*charHeight,
		True, "%3.2f", cw->content.world->research);
	TextOut(cw,
		cw->content.xGameVal, cw->content.yGameData+3*charHeight,
		True, "%3.2f", cw->content.world->happiness);

	TextOut(cw,
		cw->content.xGameFact, cw->content.yGameData,
		True, "%2.2f%%", cw->content.world->techFactor);
	TextOut(cw,
		cw->content.xGameFact, cw->content.yGameData+2*charHeight,
		True, "%2.2f%%", cw->content.world->plagueFactor);
	TextOut(cw,
		cw->content.xGameFact, cw->content.yGameData+3*charHeight,
		True, "%2.3f", cw->content.world->needHappy);

	TextOut(cw,
		cw->content.xTreaCol, cw->content.yGameData+4*charHeight,
		True, "$%7.2f", cw->content.world->treasury);
	TextOut(cw,
		cw->content.xMRes, cw->content.yGameData+5*charHeight,
		True, "%d", cw->content.world->milReserve);
	TextOut(cw,
		cw->content.xMaxCol, cw->content.yGameData+4*charHeight,
		True, "%d/%d", cw->content.world->savePopNom,
		cw->content.world->savePopDenom);
	TextOut(cw,
		cw->content.xMaxCol, cw->content.yGameData+5*charHeight,
		True, "%d", cw->content.world->maxPop);
	
	if (cw->content.sector) {
	    int idx = cw->content.sector-cw->content.world->map;
	    int column = idx%cw->content.world->rowBytes;
	    int row = idx/cw->content.world->rowBytes;
	    int x = ARR2MAPX(column, row);
	    int y = ARR2MAPY(column, row);
	    int i;

	    TextOut(cw,
		    cw->content.xSectMisc[0], cw->content.ySectMisc,
		    True, "%d%%", cw->content.sector->eff);
	    TextOut(cw,
		    cw->content.xSectMisc[1], cw->content.ySectMisc,
		    True, "%d", cw->content.sector->mobility);
	    TextOut(cw,
		    cw->content.xSectMisc[2], cw->content.ySectMisc,
		    True, "%d%%", cw->content.sector->work);
	    TextOut(cw,
		    cw->content.xSectMisc[3], cw->content.ySectMisc,
		    True, "%d", cw->content.sector->avail);
	    TextOut(cw,
		    cw->content.xSectMisc[4], cw->content.ySectMisc,
		    True, "$%d", cw->content.sector->cost);
	    TextOut(cw,
		    cw->content.xSectMisc[5], cw->content.ySectMisc,
		    True, "%d%%", cw->content.sector->prodEff);
	    
	    for (i=resIdxMin; i<=resIdxUran; i++) {
		TextOut(cw,
			cw->content.xResource[i], cw->content.yResource,
	                True, "%d", cw->content.sector->resource[i]);
	    }
	    TextOut(cw,
		    cw->content.xDistSect, cw->content.yResource,
		    True, "%d,%-4d", cw->content.sector->dist_x,
		    cw->content.sector->dist_y);
	    
	    XCopyArea(
		XtDisplay(cw),
                cw->content.sector->typePixmap,
                XtWindow(cw),
                cw->content.normalGC,
                0, 0,
                HEXAPIXMAPWIDTH+1, HEXAPIXMAPHEIGHT+1,
                cw->content.xHexa, cw->content.yHexa);

	    if (x >= cw->content.world->xMapSize/2) {
		x -= cw->content.world->xMapSize;
	    }
	    if (y >= cw->content.world->yMapSize/2) {
		y -= cw->content.world->yMapSize;
	    }
	    TextOut(cw,
		    cw->content.xSector, cw->content.ySector, False,
		    "%d,%d %s",
		    x, y, charToSectorName(cw->content.sector->typeChar));

	    if (cw->content.sector->stopped) {
		XDrawString(
		    XtDisplay(cw),
	            XtWindow(cw),
	            cw->content.hilitGC,
                    cw->content.xSector, cw->content.yStop,
                    " stopped ", 9);
	    }
	    
	    for (i=commIdxCiv; i<=commIdxRad; i++) {
		char commChar = commIdxToChar(i);
		if (cw->content.sector->prodComm[idx=0] == commChar ||
		    cw->content.sector->prodComm[idx=1] == commChar ||
		    cw->content.sector->prodComm[idx=2] == commChar ||
		    cw->content.sector->prodComm[idx=3] == commChar) {
		    TextOut(cw,
			    cw->content.xUseCol,
			    cw->content.yFirstComm+i*charHeight,
			    True,
			    idx==3 ? ">%d" : "%d",
			    cw->content.sector->useProd[idx]);
		    TextOut(cw,
			    cw->content.xMaxCol+ (idx==3 ? charWidth : 0),
			    cw->content.yFirstComm+i*charHeight,
			    True,
			    idx==3 ? "%d<" : "%d",
			    cw->content.sector->maxProd[idx]);
		    force = True;
		} else {
		    force = False;
		}
		if (cw->content.sector->path[i] &&
		    cw->content.sector->path[i]!='h' &&
		    cw->content.sector->path[i]!='.') {
		    TextOut(cw,
			    cw->content.xDelCol,
			    cw->content.yFirstComm+i*charHeight,
			    True, "%d/%c", cw->content.sector->cutoff[i],
			    cw->content.sector->path[i] ? : '.');
		    force = True;
		}
		if (cw->content.sector->level[i]) {
		    TextOut(cw,
			    cw->content.xDistCol,
			    cw->content.yFirstComm+i*charHeight,
			    True, "%d", cw->content.sector->level[i]);
		    force = True;
		}
		if (force || cw->content.sector->product[i]) {
		    TextOut(cw,
			    cw->content.xContCol,
			    cw->content.yFirstComm+i*charHeight,
			    True, "%d", cw->content.sector->product[i]);
		}
	    }

	    /* technology data */
	    if (cw->content.sector->prodComm[3] == 't') {
		/* only tech plant */
		TextOut(cw,
			cw->content.xUseCol,
			cw->content.yGameData,
			True, ">%1.2f", cw->content.sector->useProd[3]/100.0);
		TextOut(cw,
			cw->content.xMaxCol+charWidth,
			cw->content.yGameData,
			True, "%1.2f<", cw->content.sector->maxProd[3]/100.0);
		force = True;
	    }

	    /* education data */
	    if (cw->content.sector->prodComm[3] == 'e') {
		/* only library */
		TextOut(cw,
			cw->content.xUseCol,
			cw->content.yGameData+charHeight,
			True, ">%d", cw->content.sector->useProd[3]);
		TextOut(cw,
			cw->content.xMaxCol+charWidth,
			cw->content.yGameData+charHeight,
			True, "%d<", cw->content.sector->maxProd[3]);
		force = True;
	    }

	    /* research data */
	    if (cw->content.sector->prodComm[3] == 'z') {
		/* only research lab */
		TextOut(cw,
			cw->content.xUseCol,
			cw->content.yGameData+2*charHeight,
			True, ">%1.2f", cw->content.sector->useProd[3]/100.0);
		TextOut(cw,
			cw->content.xMaxCol+charWidth,
			cw->content.yGameData+2*charHeight,
			True, "%1.2f<", cw->content.sector->maxProd[3]/100.0);
		force = True;
	    }

	    /* happyness data */
	    if (cw->content.sector->prodComm[3] == 'y') {
		/* only park */
		TextOut(cw,
			cw->content.xUseCol,
			cw->content.yGameData+3*charHeight,
			True, ">%d", cw->content.sector->useProd[3]);
		TextOut(cw,
			cw->content.xMaxCol+charWidth,
			cw->content.yGameData+3*charHeight,
			True, "%d<", cw->content.sector->maxProd[3]);
		force = True;
	    }
	}
    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-indent-level:4
 *  c-continued-statement-offset:4
 *  c-continued-brace-offset:0
 *  c-brace-offset:0
 *  c-imaginary-offset:0
 *  c-argdecl-indent:4
 *  c-label-offset:-2
 * End:
 */
