;;; empire.el --- GNU Emacs' Nifty Interface to Empire

;; Copyright (C) 1994 Markus Armbruster

;; Author: Markus Armbruster <armbru@pond.sub.org>
;; Version: $Id: empire.el,v 1.4 1994/10/19 11:10:00 armbru Exp $
;; Keywords: games

;; This file is part of GENIE, the GNU Emacs's Nifty Interface to Empire

;; GENIE is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GENIE is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GENIE; see the file COPYING.  If not, write to the Free
;; Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; GENIE is a set of tools for Empclient, the simple, extensible, self
;; contained empire client.  It currently features a map display (see
;; empmap.el) and extends Empclient by a variable and function
;; substitution mechanism (see empsubst.el).  Other neat stuff is
;; under development and may even be finished some day ;->

;; From the Oxford Dictionary: ge-nie (in Arabic stories) spirit or
;; goblin with strange powers.

;; This is an ALPHA TEST RELEASE.  You were warned.


;;; Installation

;; See empclient.el for Empclient's instalation instructions.
;; You need these file somewhere in your load-path:
;; ...
;; You may byte compile them for speed.
;; To just give it a try, use
;;   M-x load-library empire
;;   M-x empire
;; To install it, add the following line to ~/.emacs
;;   (autoload 'empire "empire" "Crank up empire-client and various tools." t)


;;; How to get

;; anonymous ftp
;;   i44ftp.info.uni-karlsruhe.de:/pub/misc/empire/emacs/...
;; or (not yet) from the Empire archive,
;;   ftp.cis.ksu.edu:/pub/Games/Empire/...


;;; Call for Contribution

;; In the true spirit of Emacs, GENIE is (intended to be) easily
;; extensible.  You are invited to add you own tools.  If you want to
;; contribute code to GENIE itself, contact me.

;; Of course, comments, criticism, or bug reports are welcome.


;;; Restrictions

;; Currently, you can't have multiple empires per Emacs.


;;; To do

;; Snoop
;;   Snoop more commands
;; Displays
;;   Units, ships, planes
;;   Production, starve, budget, nation
;; Tools
;;   Commodity mover
;;   Auto feeder
;;   Production checker
;;   Dist & threshold fixer
;;   Mail & news reader
;;   Defense checker



;;; Code:

(require 'empclient)
(require 'empmap)
(require 'empsnoop)
(require 'empsubst)


;;; User options

(defvar empire-use-whole-frame t
  "*If non-nil empire uses the whole frame.")


;;; Commands

(defun empire ()
  "Crank up empire-client and various tools."
  (interactive)
  (or (string= empclient-version "1.4")
      (error "Requires Empclient version 1.4, found %s" empclient-version))
  (if empire-use-whole-frame
      (delete-other-windows))
  (let ((client-buffer (empire-client)))
    (empire-wait-until-non-busy)
    (run-hooks 'empire-login-hook)
    (empire-map)
    (empire-pop-to-client))
  (message "This is an ALPHA TEST RELEASE.  You were warned."))

;;; empire.el ends here
