#!/usr/local/bin/perl

$HOME = $ENV{'HOME'};
$PEIRC = "$HOME/.peirc";
$ESH = "$HOME/.esh";
$MACROS = "$ESH/macros";
$HOSTS = "$ESH/hosts";

&init;
&process;
&cleanup;
exit 0;

sub init {
  die "Unable to open $PEIRC for input\n" unless open(PEI, "<$PEIRC");
  if (!(-e $ESH)) {
    print "Creating directory $ESH\n";
    mkdir($ESH, 00755) unless -e $ESH;
  }
  `mv -f $MACROS $MACROS.bak` if -e $MACROS;
  die "Unable to open $MACROS for output\n" unless open(MAC, ">$MACROS");
  `mv -f $HOSTS $HOSTS.bak` if -e $HOSTS;
  die "Unable to open $HOSTS for output\n" unless open(HOS, ">$HOSTS");
}

sub dequote {
  $_ = $value;
  $quoted = 1;
  while ($quoted) {
    s/^\s+//;
    s/\s+$//;
    if (/^"(.+)"$/) {
      $_ = $1;
      next;
    }
    if (/^'(.+)'$/) {
      $_ = $1;
      next;
    }
    $quoted = 0;
  }
  $value = $_;
}

sub process_addgame {
  return unless /^addgame\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\d+)\s+(\S+)/;
  ($game, $coun, $pass, $host, $port, $dir) =
    /^addgame\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\d+)\s+(\S+)/;
  $dir =~ s/\~/$HOME/;
  $hosts .= "$comments$game,$host,$ENV{'USER'},$coun,$pass,$dir,$port,,,,\n";
  if (!(-d $dir) || !open(LS, "ls $dir|")) {
    print "Warning: Directory of game '$game' is '$dir' which doesn't exist!\n";
  } else {
    while (<LS>) {
      if (/^(\w+).teles$/ && !(-e "$dir/tele.$1")) {
	`ln -s $dir/$1.teles $dir/tele.$1`;
      } elsif (/^(\w+).wires$/ && !(-e "$dir/anno.$1")) {
	`ln -s $dir/$1.wires $dir/anno.$1`;
      }
    }
    close LS;
  }
  $comments = "";
  ++$numhosts;
}

sub process_alias {
  return unless /^alias\s+(\S+)\s+(\S.+)$/;
  print MAC $comments;
  $comments = "";
  print MAC "macro $1\n";
  $value = $2;
  &dequote;
  split(';', $value);
  for (@_) {
    s/^\s+//;
    s/\$\+/\$\*/g;
    s/\$\{([^\}]+)\}/\$\($1\)/g;
    $_ = "$_ \$*" unless /\$/;
    print MAC "\t$_\n";
  }
  print MAC "end\n\n";
}

sub process {
  while (<PEI>) {
    s/^\s+//;
    $comments .= $_ if /^#/;
    if (/^addgame/) {
      &process_addgame;
      next;
    }
    if (/^alias/) {
      &process_alias;
      next;
    }
  }
}

sub cleanup {
  print HOS "Esh hostfile version: 0\n";
  print HOS "Number of entries: $numhosts\n";
  print HOS "$hosts";
  close HOS;
  close MAC;
  close PEI;
}

