/* Serverio.c */
/* Ken Stevens 1995 */

#include "proto.h"
#include "Sys.h"
#include "Util.h"
#include "RCmd.h"
#include "Recent.h"
#include "Serverio.h"
#include "Main.h"

#include <ctype.h>
#include <setjmp.h>
#include <stdio.h>
#include <sys/types.h>
#if defined (FD_SET)
#include <sys/time.h>
#endif  /* FD_SET */

int gRemoteMsgs = kAllRmtMsgs;
int gAtPrompt = kAtEshPrompt;
int gServerCode;
char gServerLine[kServerLineSize];
str16 gTelegrams;

extern FILE *gControlIn;
extern RemoteSiteInfo gRmtInfo;
extern FILE *gControlOut;
extern int gAttemptingConnection;
extern int gDoneApplication;
extern jmp_buf gCmdLoopJmp;
extern int gDebug, gConnected, gTrace;
extern int gVerbosity;
extern int gStdout, gRealStdout;

void
InitServerLine()
{
	gServerCode = -1;
	*gServerLine = '\0';
} /* InitServerLine */

/* Returns code of the serverline, or C_EXIT if an error occurs. */
int
ReadServerLine(int eofOkay)
{
	string str;
	int eofError;

	eofError = GetTelnetString(str, sizeof(str), gControlIn, gControlOut);
	if (eofError < 0) {
		/* Most of the time, we don't want EOFs from the other side. */
eof:
		if (*str)
			strncpy(gServerLine, str, kServerLineSize);
eofMsg:
		if (eofOkay == 0)
			Error(kDontPerror, "Remote host has closed the connection.\n");
		if (gAttemptingConnection == 0) {
			HangupOnServer();
			if (!gDoneApplication)
				longjmp(gCmdLoopJmp, 1);
		} else if (eofOkay == 0) {
			/* Give up and return to Open(). */
			DoClose(0);
		}	/* else rp->eofOkay, which meant we already closed. */
		return (C_EXIT);
	}
	if (isalpha(*str)) {
		*str = 10 + (*str - 'a');
	} else {
		*str = *str - '0';
	}
	*(str + 1) = '\0';
	gServerCode = *str;
	strncpy(gServerLine, str + 2, kServerLineSize);
	if (gServerCode == C_EXIT) {
		goto eofMsg;
	}
	return gServerCode;
} /* ReadServerLine */

void
TraceServerLine()
{
	TraceMsg("%3d: %s\n", gServerCode, gServerLine);
} /* TraceServerLine */

void
PrintServerLine()
{
	longstring buf;

	MakeStringPrintable(buf, (unsigned char *) gServerLine, sizeof(buf));
	PrintF("%s\n", buf);
} /* PrintServerLine */

/* This determines if a serverline should be printed to the screen, given
 * the current verbosity level, the serverline code level, or the parameters
 * in the serverline struct.
 */
void
ParseServerLine()
{
	int printIt = 0;
	int btu, nmin;
	string prompt;

	if ((gDebug == kDebuggingOn) || (gVerbosity == kVerbose)) {
		/* Always print if debugging or in verbose mode. */
		printIt = 1;
	} else if (gVerbosity == kErrorsOnly) {
		/* Most of the time we want to print error responses. */
		if (gServerCode == C_EXIT)
			printIt = 1;
	} else if (gVerbosity == kTerse) {
		switch (gServerCode) {
		case C_DATA:
			printIt = 1;
			break;
		case C_PROMPT:
			if (sscanf(gServerLine, "%d %d", &btu, &nmin) != 2) {
				Error(kDontPerror, "bad server prompt %s", gServerLine);
			}
			sprintf(prompt, "%s [%d:%d] ",
				gRmtInfo.nickName,
				btu,
				nmin);
			SetPrompt(prompt);
			gAtPrompt = kAtMainPrompt;
			break;
		case C_FLUSH:
			SetPrompt(gServerLine);
			gAtPrompt = kAtSubPrompt;
			break;
		case C_INFORM:
			if (*gServerLine) {
				sprintf(gTelegrams, "%s ", gServerLine);
				if (gStdout == gRealStdout)
					Beep(1);
				BuildFullPrompt(1);
			} else {
				*gTelegrams = '\0';
			}
			break;
		default:
			printIt = 1;
		}
	}
	
	if (printIt)
		PrintServerLine();
	else if (gTrace == kTracingOn)
		TraceServerLine();
}	/* ParseServerLine */

void
Slurp(int eofOkay)
{
	do {
		InitServerLine();
		if (ReadServerLine(eofOkay) == C_EXIT)
			break;
		ParseServerLine();
	} while (gServerCode != C_PROMPT && gServerCode != C_FLUSH);
} /* Slurp */

QuietSlurp()
{
	do {
		InitServerLine();
		if (ReadServerLine(0) == C_EXIT)
			break;
		if (gServerCode != C_DATA)
			ParseServerLine();
	} while (gServerCode != C_PROMPT);
} /* QuietSlurp */

void
CheckForServerOutput()
{
#if defined (FD_SET)
	fd_set readfds;
	struct timeval timer;
	int server_fd;

	if (!gConnected)
		return;
	server_fd = fileno(gControlIn);
	do {
		FD_ZERO (&readfds);
		FD_SET (server_fd, &readfds);
		timer.tv_sec = 0;
		timer.tv_usec = 1;
		if (select(fileno (gControlIn)+1, &readfds, (fd_set *)NULL, (fd_set *)NULL, &timer)) {
			InitServerLine();
			if (ReadServerLine(0) == C_EXIT)
				break;
			ParseServerLine();
		}
	} while (FD_ISSET(server_fd, &readfds) && gConnected);
#endif  /* FD_SET */
} /* CheckForServerOutput */

void
AbortCommand()
{
	EPrintF("*Aborting command*\n");
	SendServer("aborted");
	Slurp(0);
}
