/* Recent.h */

#ifndef _recent_h_
#define _recent_h_ 1

#include "Open.h"

typedef struct RemoteSiteInfo *RemoteSiteInfoPtr;
typedef struct RemoteSiteInfo {
	RemoteSiteInfoPtr	prev;
	RemoteSiteInfoPtr	next;
	int					index;
	
	char				nickName[16];
	char				name[64];
	char				user[64];	/* Leave room for user@host.name */
	char				coun[32];
	char				pass[32];
	char				dir[128];
	unsigned int		port;
	time_t				lastCall;
	char				lastIP[32];
	char				comment[128];
	int					nCalls;
} RemoteSiteInfo;

typedef RemoteSiteInfoPtr *RemoteSiteInfoPtrList;

#define kRecentVersion			0
#define kRecentMinVersion		0
#define kRecentFileName			"hosts"
#define kRecentBupFileName		"hosts.old"

#define kNoRecentLimit 0

void SortNickNames(void);
void UpdateRemoteSiteInfoPtr(RemoteSiteInfoPtr, RemoteSiteInfoPtr);
RemoteSiteInfoPtr AddRemoteSiteInfoPtr(RemoteSiteInfoPtr);
RemoteSiteInfoPtr RemoveRemoteSiteInfoPtr(RemoteSiteInfoPtr);
void MakeNickNameUnique(char *, size_t);
void MakeUpANickName(RemoteSiteInfoPtr, char *, size_t);
void SetRemoteInfoDefaults(RemoteSiteInfoPtr);
int SetNewRemoteInfoDefaults(OpenOptionsPtr, RemoteSiteInfoPtr);
RemoteSiteInfoPtr FindRemoteInfo(OpenOptionsPtr);
int GetRemoteInfo(OpenOptionsPtr);
int ParseHostLine(char *, RemoteSiteInfoPtr);
void ReadRemoteInfoFile(void);
RemoteSiteInfoPtr DuplicateRemoteInfo(RemoteSiteInfoPtr);
void DeleteRemoteInfo(RemoteSiteInfoPtr);
void SaveRemoteInfo(char *);
void WriteRemoteInfoFile(void);
void PrintRemoteSiteInfo(RemoteSiteInfoPtr, int);

#endif /* _recent_h_ */
/* eof */
