/*************************************************************
 *  $Id: eif.c,v 1.9 91/06/06 13:35:11 dhay Exp $
 *
 *  eif.c
 *
 *  This is where things actually get done after runtime
 *  commandline parsing.
 *
 */
/*******************************************************
 *  Copyright (C) Doug Hay, 1991.
 *  Permission to use and abuse this code, as long
 *  as this copyright notice stays intact and with the
 *  code.  No warranty implied.  This code supplied as is.
 *******************************************************/

#include <stdio.h>
#include <signal.h>
#include "cntl.h"
#include "data.h"

/* In print.c */
void prt(), eprt(), notstdio_prt();
FILE *output_curout();

/* In getcom.c */
void cmd_exec();
int get_main_input(), get_input();

/* In compick.c */
int direct_command();

/* In connect/sock.c */
void writesock();
int readsock();

/* In empcon.c */
void game_died();

/* GNU readline stuff */
int rl_unbind_key(), stifle_history();

static void eif_sigdebug();
static void eif_interrupt();
static void eif_pipe();
static void commandloop();
static void send_command();

static char cmdbuf[300];

/*************************************
 * eif_away
 *
 * The main routine.
 */
    void
eif_away()
{

    /* Stuff for the readline. */
    rl_unbind_key(17);
    rl_unbind_key(19);

    /* initialize signal handling */
    (void) signal(SIGQUIT, eif_sigdebug);  /*Debugging*/

    (void) signal(SIGALRM, SIG_IGN);
    (void) signal(SIGPIPE, eif_pipe);

    (void) signal(SIGINT, eif_interrupt);

    /* We want ^C to abort system calls. */
    /* (void) siginterrupt(SIGINT, 1); */

    prt("\nWelcome to EIF\n");
    prt("Empire interface Version 1.0.2\n\n");

    /* The problem with this is that the file is not actually
     * executed here.  It is executed in the commandloop().
     * This just sets it up for input as an exec file.
     */
    if (cntl.st.readstartup) {
	cmd_exec(cntl.st.startupf, 2);
    }

    /* Only allow up to 100 commands in history */
    stifle_history(100);

    while (1)
	commandloop();
}

    static void
eif_sigdebug()
{
    eprt("Intr\n");
}

    static void
eif_pipe()
{
    Pipe_Interrupt++;
}
    static void
eif_interrupt()
{
    eprt("Intr\n");
    Interrupt++;
}

/*******************************************
 * commandloop
 */
    static void
commandloop()
{
    char prompt[20];
    int echoed;

    while (1) {
	/* Design a prompt */
	if (-1 == game_socket) {
	    (void) strcpy(prompt, "Local% ");
	} else
	    (void) sprintf(prompt, "\n%s [%d,%d]%% ",
			game_name, game_time, game_btus);

	/* Get the next command. */
	echoed = get_main_input(cmdbuf, sizeof(cmdbuf), prompt);

	/* Is it a local command. */
	if (!direct_command(cmdbuf)) {
	    /* Are we connected to a game? */
	    if (-1 != game_socket) {
		/* redirected emp_player commands get the commandline as
		 * their first line.  Various tools depend on this.
		 */
		if (!echoed)
		    notstdio_prt("%s\n", cmdbuf);
		send_command(cmdbuf);
	    } else {
		if (cmdbuf[0]) {
		    /* Well, should say something. */
		    eprt("Not a local command, and not connected to a game.\n");
		}
	    }
	}
    }
}

/*******************************************
 * send_command
 */
    static void
send_command(cmd)
    char *cmd;
{
    int t;
    char prompt[200];

    /* Are we connected to a game? */
    if (-1 == game_socket)
	return;

    /* Send command to game */
    writesock(game_socket, cmd);

    /* Read from game until a prompt returns. */
    while ((t=readsock(game_socket, output_curout(), game_wait,
			prompt, sizeof(prompt))) == 2) {
	if (get_input(cmdbuf, sizeof(cmdbuf), prompt)) {
	    writesock(game_socket, cmdbuf);
	} else
	    writesock(game_socket, "\naborted");
    }
    /* Damn, connection bit it. */
    if (-1 == t)
	game_died();
}
