#!/bin/awk -f

#
#	Convert a deity census into a Portable Greymap of fallout levels
#

function abs(x) {
  if (x>0) return x;
  return -x;
}

/own +sect .* fallout/ {
  getline;
  while (NF>2) {
    own[$2]=$1;
    des[$2]=substr($3,0,1);
    if ($1>max) max=$1;
    fallout[$2]=$NF;
    getline;
  }
}


/^World size is [0-9]+ by [0-9]+./ {
  width = $4;
  height= $6 + 0;
  left=-width/2;
  right=width/2-1;
  top= -height/2;
  bottom = height/2-1;
}

END {

  printf("P2\n%d %d\n999\n",right-left+2,bottom-top+1);
  for (y=top;y<=bottom;y++) {
    printf("\n");
    if (y%2) {
      printf("%s\n",fallout[right "," y]);
    }
    for (x=left + abs(y%2);x<=right;x+=2) {
      i = x "," y;
      printf("%s %s\n",fallout[i],fallout[i]);
    }
    if (!(y%2)) {
      printf("%s\n",fallout[left "," y]);
    }
  }
}

