#!/bin/awk -f
#
#	godview.awk dump-file
#
#	Given a deity dump file, prints out total by country for several
#	commodities and resources that power does not generally list.
#
#		-harmless


function num(str) {
  return substr(str,1,length(str)-1);
}


#
#	Turns a letter into a name.  Tries the first letter, if that
#	isn't a commodity, tries the last letter (useful for ship, unit,
#	and prod outputs)
#
function commstr(str) {
  char=substr(str,1,1);
  if (char == "c") return "civ";
  if (char == "m") return "mil";
  if (char == "u") return "uw";
  if (char == "f") return "food";
  if (char == "s") return "shell";
  if (char == "g") return "gun";
  if (char == "p") return "pet";
  if (char == "i") return "iron";
  if (char == "d") return "dust";
  if (char == "b") return "bar";
  if (char == "o") return "oil";
  if (char == "l") return "lcm";
  if (char == "h") return "hcm";
  if (char == "r") return "rad";

  char=substr(str,length(str),1);
  if (char == "c") return "civ";
  if (char == "m") return "mil";
  if (char == "u") return "uw";
  if (char == "f") return "food";
  if (char == "s") return "shell";
  if (char == "g") return "gun";
  if (char == "p") return "pet";
  if (char == "i") return "iron";
  if (char == "d") return "dust";
  if (char == "b") return "bar";
  if (char == "o") return "oil";
  if (char == "l") return "lcm";
  if (char == "h") return "hcm";
  if (char == "r") return "rad";


  return "";
}




BEGIN {
  SUBSEP=",";

  mode="";
  stat=0;


  weight["civ"]=1;	packing["civ"]=1;
  weight["mil"]=1;	packing["mil"]=1;
  weight["uw"]=2;	packing["uw"]=1;
  weight["food"]=1;	packing["food"]=1;
  weight["shell"]=1;	packing["shell"]=1;
  weight["gun"]=1;	packing["gun"]=1;
  weight["pet"]=1;	packing["pet"]=1;
  weight["iron"]=1;	packing["iron"]=1;
  weight["dust"]=1;	packing["dust"]=1;
  weight["bar"]=1;	packing["bar"]=1;
  weight["oil"]=1;	packing["oil"]=1;
  weight["lcm"]=1;	packing["lcm"]=1;
  weight["hcm"]=1;	packing["hcm"]=1;
  weight["rad"]=1;	packing["rad"]=1;
}






#
#	Headers for various multi-line read modes
#
/ *DUMP SECTOR/ { mode="dump"; stat=1; next; }



#
#	Parse continuation lines of multi-line modes
#
{

  if (mode=="dump") {
    if (stat==1) {
      for (i=1;i<=NF;i++) header[i]=$i;
      nheader=NF;
      stat=2;
      dsects=0;
      for (i in order) delete order[i];
      next;
    } else if (NF != nheader) {
      stat=0;
      mode="";
    } else if (stat==2) {
      for (i=1;i<=nheader;i++) temp[header[i]] = $i;
      sect = temp["x"] "," temp["y"];
      if (temp["own"]=="") temp["own"]=myno;
      for (i=1;i<=nheader;i++) val[sect,header[i]] = $i;
      sects[sect]="1";
      order[dsects++] = sect;
      next;
    }
    mode="";
  }
}






#
#	What to do at the end
#

END {
  gold=0;
  uran=0;
  ocon=0;
  min=0;
  fert=0;
  scts=0;
  for (sect in sects) {
    gold += val[sect,"gold"];
    ocon += val[sect,"ocontent"];
    uran += val[sect,"uran"];
    min  += val[sect,"min"];
    fert += val[sect,"fert"];
    uws += val[sect,"uw"];
    bars += val[sect,"bar"];
    scts++;
    gld[val[sect,"own"]] += val[sect,"gold"];
    ocn[val[sect,"own"]] += val[sect,"ocontent"];
    ura[val[sect,"own"]] += val[sect,"uran"];
    mn[val[sect,"own"]] += val[sect,"min"];
    frt[val[sect,"own"]] += val[sect,"fert"];
    uw[val[sect,"own"]] += val[sect,"uw"];
    bar[val[sect,"own"]] += val[sect,"bar"];
    sct[val[sect,"own"]]++;
  }

  printf("sects    min   gmin   ocon   fert   uran     uw    bar\n");
  printf("%-5d %6d %6d %6d %6d %6d\n",scts,min,gold,ocon,fert,uran,uws,bars);
  for (own in sct) {
    printf("%-5d %6d %6d %6d %6d %6d %6d %6d {%d}\n",
	   sct[own],mn[own],gld[own],ocn[own],frt[own],ura[own],
	   uw[own],bar[own],own);
  }
}
