#ifndef lint
static char *RCSid = "$Header: file.c,v 1.19 90/03/19 11:23:14 mr-frog Exp $";
#endif /* not lint */

/*
 * file.c
 *
 * operations on files
 *
 * Dave Pare, 1989
 */

/*	New define if the computer has an mmap() and related functions */

#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include "misc.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "match.h"
#include "struct.h"



static	int fillcache();

int
ef_open(type, mode, how)
	int	type;
	int	mode;
	int	how;
{
	register struct empfile *ep;
	static	int block;
	int	size;

#if defined(MMAP) && !defined(DEBUG)
	mode |= O_RDWR;		/* let's everyone write into shared memory */
#endif

	if (type < 0 || type >= EF_MAX) {
		logerror("ef_open: bad EF_type %d\n", type);
		return 0;
	}
	ep = &empfile[type];

	if (ep->fd>=0) {
		logerror("%s: already opened", ep->file);
		return 0;
	}


	if ((ep->fd = open(ep->file, mode, 0660)) < 0) {
		logerror("%s: open failed", ep->file);
		return 0;
	}

	if (block == 0)
		block = blksize(ep->fd);
	ep->baseid = 0;
	ep->cids = 0;
	ep->mode = mode;
	ep->flags |= how;
#ifdef MMAP

	if (type!=EF_FILE) {
	  if (!empfile[EF_FILE].cache)
	    ef_open(EF_FILE, O_RDWR | (mode&O_TRUNC),0);
	  if (mode&O_TRUNC)
	    ((struct filestr *)empfile[EF_FILE].cache)[type].fids=ep->fids;
	  ep->fids = ef_nelem(type);
	} else {
	  ep->fids = EF_MAX+1;
	}
	ep->csize = size = ep->fids * ep->size;

	if (ep->fids > 100000) {
	  logerror("error opening %s.  %d ids predicted",ep->file,ep->fids);
	  return 0;
	}

	if ((mode&O_TRUNC)==O_TRUNC) {		/* initialize semaphores */
	  if (size) {
	    if (ftruncate(ep->fd,size)) {
	      logerror("ef_open: ftruncate(%s,%d) failed\n",ep->file,size);
	      return 0;
	    }
	  }

	if (size>0) 
	  ep->cache = mmap(0,size,
			   (PROT_READ | ((mode&O_RDWR)?PROT_WRITE:0)),
			   MAP_SHARED,ep->fd,0);
	else ep->cache=0;
	if (ep->cache == ((char *)-1)) {
		ep->csize = 0;
		ep->cache=0;
		logerror("ef_open: %s mmap() failed\n", ep->file);
		return 0;
	}
#ifdef MSEM
	  for (i=0;i<ep->fids;i++) {
	    if (!msem_init(ep->cache + i * ep->size,MSEM_UNLOCKED)) {
	      logerror("ef_open: %s msem_init() failed\n", ep->file);
	      return 0;
	    }
	  }
#endif
	}
#else
	ep->fids = fsize(ep->fd) / ep->size;
	if (ep->flags & EFF_MEM)
		ep->csize = ep->fids;
	else
		ep->csize = block / ep->size;
	size = ep->csize * ep->size;
	ep->cache = malloc(size);
	if ((ep->cache == 0) && (size !=0)) {
		logerror("ef_open: %s malloc(%d) failed\n", ep->file, size);
		return 0;
	}
	if (ep->flags & EFF_MEM) {
		if (read(ep->fd, ep->cache, size) != size) {
			logerror("ef_open: read(%s) failed\n", ep->file);
			return 0;
		}
	}
#endif

	return 1;
}

int
ef_close(type)
	int	type;
{
	register struct empfile *ep;
	int	size;

	if (type < 0 || type >= EF_MAX) {
		logerror("ef_close: bad EF_type %d\n", type);
		return 0;
	}
	ep = &empfile[type];

	if (ep->cache == 0) {
		/* no cache implies never opened */
		return 0;
	}
#ifdef MMAP
	if (ep->csize && ep->cache>0) {
	  if (munmap(ep->cache,ep->csize)) {
	    logerror("ef_close; %s munmap (%x,%d) failed", 
		     ep->file, ep->cache, ep->csize, ep->file);
	    return 0;
	  }
	}
#else
	size = ep->csize * ep->size;
	if (ep->mode > 0 && ep->flags & EFF_MEM) {
		if (lseek(ep->fd, 0L, 0) < 0) {
			logerror("ef_close; lseek (%s) failed", ep->file);
			return 0;
		}
		if (write(ep->fd, ep->cache, size) != size) {
			logerror("ef_close; write: (%s, %d bytes) failed",
				ep->file, size);
			return 0;
		}
	}
	ep->flags &= ~EFF_MEM;
	free(ep->cache);
#endif
	ep->cache = 0;
	ep->csize = 0;
	if (close(ep->fd) < 0)
		logerror("ef_close; close (%s) failed", ep->file);
	ep->fd = -1;
	return 1;
}

s_char *
ef_ptr(type, id)
	int	type;
	int	id;
{
	register struct empfile *ep;

	if (type < 0 || type >= EF_MAX) {
		logerror("ef_ptr: bad EF_type %d", type);
		return 0;
	}
	ep = &empfile[type];
	if (id<0 || id>=ef_nelem(type)) {
		return 0;
	} 
#ifdef MMAP
	if (id>=ep->cids) {
	  if (ep->cache && ep->csize>0) {
	    if (munmap(ep->cache,ep->csize)) {
	      logerror("ef_ptr: (%s) munmap failed", ep->file);
	      return 0;
	    }
	  }
	  ep->csize = ef_nelem(type) * ep->size;
	  ep->cache = mmap(ep->cache,ep->csize,
			   PROT_READ|((ep->mode)&O_RDWR?PROT_WRITE:0),
			   MAP_SHARED,ep->fd,0);
	  if (ep->cache == ((char *)-1)) {
	    logerror("ef_ptr: mmap(%s,%d) failed", ep->file,ep->csize);
	    ep->cache = 0;
	    return 0;
	  }
	  ep->cids = ep->csize/ep->size;
	}
#else
	if ((ep->flags & EFF_MEM) == 0) {
		logerror("ef_ptr: (%s) only valid for EFF_MEM entries",
			ep->file);
		return 0;
	}
#endif
	return (s_char *) (ep->cache + ep->size * id);
}

/*
 * buffered read.  Tries to read a large number of items.
 * This system won't work is item size is > sizeof buffer area.
 */
int
ef_read(type, id, ptr)
	int	type;
	int	id;
	caddr_t	ptr;
{
	register struct empfile *ep;
	caddr_t	from;

	if (type < 0 || type >= EF_MAX) {
		logerror("ef_read: bad EF_type %d\n", type);
		return 0;
	}
	ep = &empfile[type];
	if (id<0 || id>=ef_nelem(type)) {
		return 0;
	}
#ifdef MMAP
	if (id >= ep->cids) {
	  if (ep->csize && munmap(ep->cache,ep->csize)) {
	    logerror("ef_ptr: (%s) munmap failed", ep->file);
	    return 0;
	  }
	  ep->csize = ef_nelem(type) * ep->size;
	  ep->cache = mmap(ep->cache,ep->csize,
			   PROT_READ|((ep->mode&O_RDWR)?PROT_WRITE:0),
			   MAP_SHARED,ep->fd,0);
	  if (ep->cache == ((char *)-1)) {
	    logerror("ef_ptr: (%s) mmap failed", ep->file);
	    ep->cache = 0;
	    return 0;
	  }
	  ep->cids = ep->csize/ep->size;
	}
	from = ep->cache + (id * ep->size);
#else
	if (ep->flags & EFF_MEM) {
		from = ep->cache + (id * ep->size);
	} else {
		if (id >= ep->fids) {
			ep->fids = fsize(ep->fd) / ep->size;
			if (id >= ep->fids)
				return 0;
		}
		if (ep->baseid + ep->cids <= id || ep->baseid > id)
			fillcache(ep, id);
		from = ep->cache + (id - ep->baseid) * ep->size;
	}
#endif
	bcopy(from, ptr, ep->size);
	if (ep->postread)
		ep->postread(id, ptr);
	return 1;
}

static
fillcache(ep, start)
	struct	empfile *ep;
	int	start;
{
	int	n;

#ifndef MMAP
	ep->baseid = start;
	lseek(ep->fd, start * ep->size, 0);
	n = read(ep->fd, ep->cache, ep->csize * ep->size);
	ep->cids = n / ep->size;
#endif
}

/*
 * no-buffered read
 * zaps read cache
 */
int
ef_nbread(type, id, ptr)
	int	type;
	int	id;
	caddr_t	ptr;
{
#ifndef MMAP
	register struct empfile *ep;

	if (type < 0 || type >= EF_MAX) {
		logerror("ef_nbread: bad EF_type %d\n", type);
		return 0;
	}
	ep = &empfile[type];
	if (id < 0)
		return 0;
	if (id >= ep->fids) {
		ep->fids = fsize(ep->fd) / ep->size;
		if (id >= ep->fids)
			return 0;
	}
	if (lseek(ep->fd, id * ep->size, 0) < 0) {
		logerror("ef_nbread: lseek id %d failed\n", id);
		return 0;
	}
	if (read(ep->fd, ptr, ep->size) != ep->size) {
		logerror("ef_nbread: read id %d failed\n", id);
		return 0;
	}
	ef_zapcache(type);
	if (ep->postread)
		ep->postread(id, ptr);
	return 1;
#else
	return ef_read(type, id, ptr);
#endif
}

/*
 * no-buffered write
 * zaps read cache
 */
int
ef_nbwrite(type, id, ptr)
	int	type;
	int	id;
	caddr_t	ptr;
{
	register int r;
	register struct empfile *ep;

	if (type < 0 || type >= EF_MAX || id < 0) {
	  logerror("ef_nbwrite; bad type(%d) or id(%d)",type,id);
	  return 0;
	}
	ep = &empfile[type];
#ifdef MMAP
	if (id >= ef_nelem(type)) {
	  struct flock fl;

	  if (ep->cache && ep->csize>0) {
	    if (munmap(ep->cache,ep->csize)) {
	      logerror("ef_nbwrite; (%s) munmap(%x,%d) failed",
		       ep->file,ep->cache,ep->csize);
	      return 0;
	    }
	  }

#ifndef sun
	  fl.l_type = F_WRLCK;
	  fl.l_whence = SEEK_SET;
	  fl.l_start = id * ep->size;
	  fl.l_len = 0;
	  if (fcntl(ep->fd,F_SETLKW,&fl)) {
	    logerror("ef_nbwrite; (%s) lock failed",ep->file);
	    return 0;
	  }
#endif

	  if (lseek(ep->fd, id * ep->size, 0) < 0) {
	    logerror("ef_nbwrite: (lseek) id %d, type %d", id, type);
	    return 0;
	  }

	  /* write expanded file */
	  if (ep->prewrite)
	    ep->prewrite(id, ptr);
	  if ((r=write(ep->fd, ptr, ep->size)) != ep->size) {
	    logerror("ef_nbwrite: (%s) write failed", ep->file);
	    return 0;
	  }

	  ((struct filestr *)empfile[EF_FILE].cache)[type].fids = id+1;

#ifdef MSEM
	  if (!msem_init(ep->cache + ep->size*id, MSEM_UNLOCKED)) {
	    logerror("ef_nbwrite: %s msem_init(%d) failed\n",ep->file,id);
	    return 0;
	  }
#endif

#ifdef sun
	  fl.l_type = F_UNLCK;
	  fl.l_whence = SEEK_SET;
	  fl.l_start = id * ep->size;
	  fl.l_len = 0;
	  if (fcntl(ep->fd,F_SETLKW,&fl)) {
	    logerror("ef_nbwrite; (%s) unlock failed",ep->file);
	    return 0;
	  }
#endif

	  ep->cids = id+1;
	  ep->csize = ep->cids * ep->size;
	  ep->cache = mmap(ep->cache,ep->csize,
			   PROT_READ | ((ep->mode&O_RDWR)?PROT_WRITE:0),
			   MAP_SHARED, ep->fd, 0);
	  if ((ep->cache == ((char *)-1))) {
	    ep->cache=0;
	    logerror("ef_nbwrite: %s mmap() failed\n", ep->file);
	    return 0;
	  }
	  return 1;

	} else if (id >= ep->cids) {
	  if (ep->cache && ep->csize>0) {
	    if (munmap(ep->cache,ep->csize)) {
	      logerror("ef_nbwrite; %s munmap failed", ep->file);
	      return 0;
	    }
	  }
	  ep->cids = ef_nelem(type);
	  ep->cache = mmap(ep->cache, ep->cids * ep->size,
			   PROT_WRITE | PROT_READ, MAP_SHARED, ep->fd, 0);
	  if (ep->cache == ((char *)-1)) {
	    ep->cache=0;
	    logerror("ef_nbwrite: %s mmap() failed\n", ep->file);
	    return 0;
	  }
	  
	}
#ifdef MSEM	  
	bcopy(ptr+sizeof(msemaphore),
	      ep->cache + (id * ep->size) + sizeof(msemaphore),
	      ep->size-sizeof(msemaphore));
#else
	bcopy(ptr,ep->cache+(id*ep->size),ep->size);
#endif

#else
	if (id > 65536) {
		/* largest unit id; this may bite us in large games */
		logerror("ef_nbwrite: type %d id %d is too large!\n", type, id);
		return 0;
	}
	if (lseek(ep->fd, id * ep->size, 0) < 0) {
		logerror("ef_nbwrite: (lseek) id %d, type %d", id, type);
		return 0;
	}
	if (ep->prewrite)
		ep->prewrite(id, ptr);
	if ((r=write(ep->fd, ptr, ep->size)) != ep->size) {
		logerror("ef_nbwrite: (write) id %d, type %d %d!=%d", id, type,r,ep->size);
		logerror("	ef_nbwrite: (write) fd %d, ptr %d", ep->fd, ptr);
		return 0;
	}
	if ((ep->flags & EFF_MEM) == 0)
		ef_zapcache(type);
	if (id >= ep->fids) {
		/* write expanded file; ep->fids = last id + 1 */
		ep->fids = id + 1;
	}
#endif
	return 1;
}

ef_zapcache(type)
	int	type;
{
#ifndef MMAP
	empfile[type].cids = 0;
	empfile[type].baseid = -1;
#endif
}

struct castr *
ef_cadef(type)
	int	type;
{
	return empfile[type].cadef;
}

int
ef_nelem(type)
     int	type;
{
#ifdef MMAP
	return ((struct filestr *)empfile[EF_FILE].cache)[type].fids;
#else
	return empfile[type].fids;
#endif
}

int
ef_flags(type)
	int	type;
{
	return empfile[type].flags;
}


int
ef_lock(type)
	int	type;
{
	return file_lock(empfile[type].fd);
}

int
ef_unlock(type)
	int	type;
{
	return file_unlock(empfile[type].fd);
}

time_t
ef_mtime(type)
	int	type;
{
	extern	time_t fdate();

	if (empfile[type].fd <= 0)
		return 0;
	return fdate(empfile[type].fd);
}

int
ef_vars(type, sp, nvp, vp, ap)
	int	type;
	register s_char *sp;
	u_char	**nvp;
	u_char	**vp;
	u_short	**ap;
{
	register struct empfile *ef;

	if (type < 0 || type >= EF_MAX) {
		logerror("ef_vars: bad EF_type %d\n", type);
		return -1;
	}
	ef = &empfile[type];
	if ((ef->flags & EFF_COM) == 0)
		return -1;
	*nvp = (u_char *) (sp + ef->varoffs[0]);
	*vp = (u_char *) (sp + ef->varoffs[1]);
	*ap = (u_short *) (sp + ef->varoffs[2]);
	return ef->maxvars;
}

int
ef_byname(name)
	s_char	*name;
{
	register struct empfile *ef;
	register int i;
	int	len;

	len = strlen(name);
	for (i=0; i<EF_MAX; i++) {
		ef = &empfile[i];
		if (strncmp(ef->name, name, len) == 0)
			return i;
	}
	return -1;
}

s_char *
ef_nameof(type)
	int	type;
{
	if (type < 0 || type >= EF_MAX)
		return "bad item type";
	return empfile[type].name;
}


#ifdef MSEM
int
ef_itemlock(type,id)
     int type,id;
{
  msemaphore *sem;

  sem = empfile[type].cache + empfile[type].size * id;
  return msem_lock(sem,0);
}

int
ef_itemunlock(type,id)
     int type,id;
{
  msemaphore *sem;

  sem = empfile[type].cache + empfile[type].size * id;
  return msem_unlock(sem,0);
}

#endif 
