.TH Introduction "Empire Overview"
.NA Overview "A general overview of the game"
.s1
\*(bFA BRIEF HISTORY\*(nF
.br
The game "Empire" is the most recent in a series of territorial
conquest, political/economic simulation  games initially inspired by
a board game of the same name played at Reed College (Portland, Oregon).
Earlier versions were written at Reed by Peter Langston and
at The Evergreen State College (Olympia, Washington) by Chas Douglas,
Peter Langston, Ben Norton, Mike Rainwater and others;
of particular note are the games "Galaxy" (Langston) and "Civil" (Norton).
The previous version was written partly on the HRSTS Unix system at
the Harvard Science Center, (Cambridge, Mass.),
partly on the Unix system at Commercial Union
Leasing Corporation, (New York, N.\ Y.)
and partly on the Unix system at Davis Polk & Wardwell, (New York, N.\ Y.)
by Peter Langston with invaluable goading from
Joe Stetson, Robert Bradbury, Nat Howard, Brian Redman, Adam Buchsbaum,
and a myriad of others.
Since Langston never released source code for his version, Dave Pare
and friends de-compiled it and have created this version which is
very different.
.s1
\*(bFTHE OBJECT OF THE GAME\*(nF
.br
Empire falls into the broad category of simulation games and
involves military, political, and economic factors.
Although no goal is explicitly stated, players
rapidly derive their own, ranging from the mundane desire to be the
biggest, mightiest country in the game and "conquer" all others to the
more refined goals of having the most efficient land use
possible or the lowest ratio of military to civilians while
still surviving, etcetera.
.s1
\*(bFWHY USE A COMPUTER?\*(nF
.br
The role of the computer in Empire is that of modeling the
physical/economic system.
Players interact through the computer rather than with the computer.
The game is played in a "real-time" environment;
players log on and allocate resources, attack neighbors,
send diplomatic communiques, etc. whenever it is convenient.
The program keeps track of these activities, maintaining a record
of time spent and arranging for time to accumulate when players are
not logged in to the game.
Accumulated time is expressed in "Bureaucratic Time Units" or "B.T.U.s".
.s1
\*(bFBTUs?\*(nF
.br
The purpose of the B.T.U. Concept is three-fold:
.br
I) Commands use up B.T.U.s.  This limits the number of commands
that any player can give in any particular time period.
Thus the fanatics can't overrun the players with less free time by
tenacity alone.
.br
II) The build up of B.T.U.s not being dependent on
being logged on at any particular time allows players to participate when
it is convenient rather than at some fixed time (as in the case of
monopoly, the stock market, etc).
.br
III) The B.T.U. arrangement helps compensate for the fact
that in concept, the governments of each country are always "playing"
although the player representing that country may only play periodically.
.s1
\*(bFGEOGRAPHY\*(nF
.br
The geography of the game
is embodied in a rectangular map partitioned into M\ x\ N sectors
(where M and N are typically but not necessarily powers of two,
usually 32, 64 or 128)
that is approximately
50% sea, 45% habitable land and 5% uninhabitable mountains.
This "map" is generated by a program (the "creation") that
places volcanos pseudo-randomly,
lets large meteors and small meteorites impact the surface,
strews gold deposits and oil deposits around,
covers the planet with water,
dries some of the water to form seas and land masses,
runs rivers from mountain peaks down to the seas,
allows sedimentation to create oil and fertility,
and uses simple tectonics to expose oil and ores,
etc.
.s1
\*(bFWHERE DO THE COUNTRIES COME FROM?\*(nF
.br
New countries may join the game at any time.
Upon entry into the
game a new country is given two adjacent sectors.
These sectors are initially designated "sanctuaries" and are inviolable.
(Each country uses its own coordinate system with sector 0,0 being the
current capital, a sanctuary initially.  The initial two
sectors are always numbered 0,0 and 2,0.)
The new nation may confine itself to these two sectors for any length
of time and thereby be safe from attack.
However, in order to build or expand, it is necessary to
leave the safety of the sanctuary.
The sectors of land that were sanctuaries can then be
redesignated as any of a multitude of other land-use types ranging from
weather stations to gold mines to munitions plants.
.s1
\*(bFFURTHER READING\*(nF
.br
For further information,
here are a few "info" command topics that are basic to the understanding
of the game:
.NF
bye      designate  map           spy       update
census   food       move          syntax    distribute
nation   info       Sector-types  time      {commands}
.FI
\*(bFA FINAL NOTE\*(nF
.br
It should be remembered that Empire is merely an interesting pastime;
in the vernacular, "it's just a game".
There are many amusing stories of people who took the game too seriously;
one tells of a corporate Vice President who walked into
the computer room one Saturday and flipped the main circuit breaker
in order to stop an attack on his country; another tells of the Harvard
student who refused to go to bed until everyone logged out of Empire and
the other players who took turns staying up late...
.s1
While many players take Empire very seriously an equal number of players
use it as a safe environment in which they can act out fantasies.
On occasion the fantasies involved are remarkably aggressive or hostile.
It has been my experience that the people with the most belligerent
countries are often the people with the kindest hearts;
the anti-social game play doesn't necessarily reflect the "true"
being underneath (or else I have some \fIvery\fP weird friends).
.s3
.SA "Bugs, Hints, Intro, Introduction"
