#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/repo.c,v 2.8 1995/10/18 03:25:39 empire Exp $";
#endif /* not lint */

/*
 * repo.c
 *
 * report of comparative tech levels for the various
 * nations based on current nation's tech levels
 *
 * Keith Muller, 1983
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#include <fcntl.h>
#include <ctype.h>

static	void printdiff();
static  void repo_header();
static  void repo_list();

static	int check();

struct stats {
	double res;
	double tech;
	double edu;
	double hap;
	int stat;
};

repo()
{
	struct	natstr *natp;
	struct	stats mystat;
	struct	natstr nat;
	struct	nstr_item ni;
	int	first;

	if (!snxtitem(&ni, EF_NATION, player->argp[1]))
		return RET_SYN;
	prdate();
	natp = getnatp(player->cnum);
	bzero(&mystat, sizeof(struct stats));
	mystat.stat = natp->nat_stat;
	if (mystat.stat & STAT_NORM) {
		mystat.res = natp->nat_level[NAT_RLEV];
		mystat.tech = natp->nat_level[NAT_TLEV];
		mystat.edu = natp->nat_level[NAT_ELEV];
		mystat.hap = natp->nat_level[NAT_HLEV];
	}
#ifdef	HIDDEN
	repo_header();
	first = 0;
#else
	first = 1;
#endif	/* HIDDEN */
	while (nxtitem(&ni, (s_char *) &nat)) {
		if (!(nat.nat_stat & STAT_INUSE))
			continue;
#ifdef	HIDDEN
		if (!player->god && !getcontact(getnatp(player->cnum), ni.cur)) 
			continue;
#endif	/* HIDDEN */
		if (first) {
			repo_header();
			first = 0;
		}
		repo_list(&mystat, (natid)ni.cur, &nat);
	}
	return RET_OK;
}

static void
repo_header()
{
	pr(" #    name                tech      research   education   happiness ");
	if (player->god)
		pr("cap-location\n");
	else
#ifdef	HIDDEN
		pr("\n");
#else
		pr(" status\n");
#endif	/* HIDDEN */
}

static void
repo_list(stat, cn, natp)
	struct	stats *stat;
	natid	cn;
	struct natstr *natp;
{
	struct	sctstr cap;

	if (player->god) {
		pr(" %-3d   %-14.14s ", cn, natp->nat_cnam);
		pr(" %7.2f   %7.2f     %7.2f    %7.2f  %s\n",
		       natp->nat_level[NAT_TLEV],
		       natp->nat_level[NAT_RLEV],
		       natp->nat_level[NAT_ELEV],
		       natp->nat_level[NAT_HLEV],
		       xyas(natp->nat_xcap, natp->nat_ycap, player->cnum));
		return;
	}
	switch (natp->nat_stat & (STAT_NORM|STAT_GOD|STAT_NEW|STAT_SANCT)) {
	case STAT_NORM:
	case (STAT_NORM|STAT_SANCT):
		pr(" %-3d   %-14.14s ", cn, natp->nat_cnam);
		printdiff(stat->stat, stat->tech, natp, NAT_TLEV);
		printdiff(stat->stat, stat->res, natp, NAT_RLEV);
		printdiff(stat->stat, stat->edu, natp, NAT_ELEV);
		printdiff(stat->stat, stat->hap, natp, NAT_HLEV);
		getsect(natp->nat_xcap, natp->nat_ycap, &cap);
#ifdef	HIDDEN
		pr("\n");
#else
		if (cap.sct_own != cn ||
		    (cap.sct_type != SCT_CAPIT &&
		    cap.sct_type != SCT_MOUNT))
			pr("In flux\n");
		else if (natp->nat_money <= 0)
			pr("Broke\n");
		else
			pr("Active\n");
#endif /* HIDDEN */
		break;
	case STAT_SANCT:
		break;
	case STAT_NEW:
	case 0:
		break;
	case STAT_SANCT|STAT_NORM|STAT_GOD:
	case STAT_NORM|STAT_GOD:
	case STAT_GOD:
		break;
	default:
		pr("????        ????        ????        ????\n");
		break;
	}
}

static void
printdiff(mystat, ours, natp, what)
	int	mystat;
	double   ours;
	struct	natstr *natp;
	int	what;
{
	double	theirs;
	int	shift;
	int	tolerance;
	s_char	buf[128];
	
	if (natp->nat_cnum == player->cnum) {
		pr(" %7.2f    ", ours);
		return;
	}
	if (ours && mystat & STAT_NORM &&
	    natp->nat_stat &STAT_NORM) {
		theirs = natp->nat_level[what];
		if ((shift = min((int)theirs, (int)ours) - 100) > 0) {
			ours -= shift;
			theirs -= shift;
		} else
			shift = 0;
		switch (what) {
		case NAT_TLEV:
			tolerance = 20; break;
		case NAT_RLEV:
			tolerance = 10; break;
		default:
			tolerance = 5;
		}
		if (tolerance > 2 * ours)
			tolerance = (int)(2 * ours);
		if (check(buf, theirs, 2 * ours, -1.0, shift, what, tolerance));
		else if (check(buf, theirs, 1.5*ours, 2.0*ours, shift, what, tolerance));
		else if (check(buf, theirs, 1.2*ours, 1.5*ours, shift, what, tolerance));
		else if (check(buf, theirs, 1.1*ours, 1.2*ours, shift, what, tolerance));
		else if (check(buf, theirs, ours/1.1, 1.1*ours, shift, what, tolerance));
		else if (check(buf, theirs, ours/1.2, ours/1.1, shift, what, tolerance));
		else if (check(buf, theirs, ours/1.5, ours/1.2, shift, what, tolerance));
		else if (check(buf, theirs, ours/2.0, ours/1.5, shift, what, tolerance));
		else if (check(buf, theirs, -1.0, ours/2.0, shift, what, tolerance));
		else sprintf(buf, "    n/a");
	} else
		sprintf(buf, "    n/a");

	pr("%-11s ", buf);
}

static int
check(buf, theirs, min, max, shift, what, tolerance)
	s_char	*buf;
	double	theirs, min, max;
	int	shift;
	int	what;
	int	tolerance;
{
	double	shove;

	if (min < 0) {
		if (theirs <= max) {
			if (max < tolerance)
				max = tolerance;
			sprintf(buf, "   0 - %d", (int)max + shift);
			return 1;
		}
	} else if (max < 0) {
		if (theirs >= min) {
			sprintf(buf, "    >= %d", (int)min + shift);
			return 1;
		}
	} else if (theirs >= min && theirs <= max) {
		if (max - min < tolerance) {
			shove = (tolerance - (max - min)) / 2;
			if (min + shift - shove >= 0) {
				min -= shove;
				max += shove;
			} else {
				min = 0;
				max = tolerance;
			}
		}
		sprintf(buf, "%4d - %d", (int)min + shift, (int)max + shift);
		return 1;
	}

	return 0;
}

