/*
 * mobq.c
 *
 * set the sailing mobility quota for a ship
 *
 * hacked by Robert Forsman <thoth@beach.cis.ufl.edu>
 * by staring at flee.c
 */

#include <ctype.h>
#include "misc.h"
#include "player.h"
#include "var.h"
#include "ship.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

#ifdef	SAIL

mobq()
{
	extern	int ship_mob_max;
	extern	float ship_mob_scale;
	extern	int etu_per_update;
	struct shpstr ship;
	s_char	*cp,*oldmq;
	int	good,mobquota,count=0;
	struct	nstr_item nstr;
	s_char	buf[1024];

/*	getstarg(player->argp[1], "ships? ");*/
	if (!snxtitem(&nstr, EF_SHIP, player->argp[1]))
		return RET_SYN;
	oldmq = player->argp[2];
	if (oldmq)
	  {
	    good = sscanf(oldmq,"%d",&mobquota);
	    if  (!good)
	      return RET_SYN;
	    if (mobquota<0 || mobquota>ship_mob_max)
	      {
		pr("Bad mobility quota value %d.\n",mobquota);
		return RET_SYN;
	      }
	    if (mobquota+(ship_mob_scale*(float)etu_per_update) > ship_mob_max)
	      {
		pr("warning: %d less than optimal\n",mobquota);
	      }
	  }
	while (nxtitem(&nstr, (s_char *)&ship)) {
	  if (!player->owner)
	    continue;
	  if (!oldmq)
	    pr("Ship #%d at %s.  Old value %d.\n",ship.shp_uid,xyas(ship.shp_x,ship.shp_y,ship.shp_own),ship.shp_mobquota);
	  cp = getstarg(player->argp[2],"mobility quota?", buf);
	  good = sscanf(cp,"%d",&mobquota);
	    if  (!good)
	      {
		pr("Huh?\n");
		continue;
	      }
	  if (!oldmq)
	    {
	      if (mobquota<0 || mobquota>ship_mob_max)
		{
		  pr("Bad mobility quota value %d.\n",mobquota);
		  continue;
		}
	      if (mobquota+(ship_mob_scale*(float)etu_per_update)> ship_mob_max)
		{
		  pr("warning: %d less than optimal\n",mobquota);
		}
	    }
	  ship.shp_mobquota = mobquota;
	  count ++;
	  putship(nstr.cur, &ship);
	}
	if (count == 0) {
		if (player->argp[1])
			pr("%s: No ship(s)\n", player->argp[1]);
		else
			pr("%s: No ship(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d ship%s\n", count, splur(count));
	return RET_OK;
}
#endif	/* SAIL */
