#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/comm.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif /* not lint */

/*
 * comm.c
 *
 * do a commodity report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "path.h"
#include "nat.h"
#include "deity.h"
#include "file.h"

static	prthresh();

comm()
{
	struct	sctstr sect;
	s_char	dirstr[12];
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	int	item[I_MAX+1];

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	prdate();
	(void) strcpy(dirstr, ".      $");
	n = 1;
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (nsect++ == 0) {
			if (player->god)
				pr("   ");
			pr("COMMODITIES\n");
			if (player->god)
				pr("   ");
			pr("  sect        sh  gun  pet iron dust  bar  oil  lcm  hcm  rad\n");
		}
		if (player->god)
			pr("%3d", sect.sct_own);
		getvec(VT_ITEM, item, (s_char *)&sect, EF_SECTOR);
		prxy("%4d,%-4d", nstr.x, nstr.y, player->cnum);
		pr(" %c", dchr[sect.sct_type].d_mnem);
		pr("%5d", item[I_SHELL]);
		pr("%5d", item[I_GUN]);
		pr("%5d", item[I_PETROL]);
		pr("%5d", item[I_IRON]);
		pr("%5d", item[I_DUST]);
		pr("%5d", item[I_BAR]);
		pr("%5d", item[I_OIL]);
		pr("%5d", item[I_LCM]);
		pr("%5d", item[I_HCM]);
		pr("%5d", item[I_RAD]);
		pr("\n");
	}
	if (nsect == 0) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d sector%s\n", nsect, splur(nsect));
	return 0;
}

static
prthresh(format, val)
	s_char	*format;
	int	val;
{
	if (val >= 1000)
		val = 'a';
	else if (val > 0)
		val = val / 100 + '0';
	else
		val = '.';
	pr(format, val);
}
