#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/atta.c,v 2.16 1995/10/01 22:35:19 empire Exp $";
#endif /* not lint */

/*
 * atta.c
 *
 * attack another sector.
 *
 * Most of the functions called in this file may be found in lib/subs/attsub.c
 *
 * Ken Stevens, 1995
 */

#include <math.h>
#include "misc.h"
#include "player.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "path.h"
#include "news.h"
#include "treaty.h"
#include "nat.h"
#include "xy.h"
#include "land.h"
#include "nsc.h"
#include "mission.h"
#include "ship.h"
#include "combat.h"

atta() {
	struct	combat off[6];	/* attacking sectors */
	struct	combat def[1];	/* defending sector */
	coord	newx, newy;
	struct	sctstr sect;
	int	fort_sup, ship_sup, land_sup, plane_sup;
	struct	qelem olist;	/* attacking units */
	struct	qelem dlist;	/* defending units */
	int	ototal;		/* total attacking strength */
	int	a_engineer = 0;	/* attacker engineers are present */
	int	a_spy = 0;	/* the best attacker scout */
	double	osupport = 1.0; /* attack support */
	double	dsupport = 1.0; /* defense support */
	int	last, n;
	s_char	*p;
	s_char	buf[1024];

	att_combat_init(def, EF_SECTOR);
	/*
	 * Collect input from the attacker
	 */

	/* What are we attacking? */

	if (!(p = getstarg(player->argp[1], "Sector :  ", buf)))
		return RET_SYN;
	if (!sarg_xy(p, &def->x, &def->y))
		return RET_SYN;
	if (att_abort(A_ATTACK, 0, def))
		return RET_FAIL;

	/* Show what we're attacking */

	att_show(def);

	/* Ask about offensive support */

	att_ask_support(2, &fort_sup, &ship_sup, &land_sup, &plane_sup);
	if (att_abort(A_ATTACK, 0, def)) {
		att_empty_attack(A_ATTACK, 0, def);
		return RET_OK;
	}

	/* initialize the off[] array */

	for (n = 0, last = -1; n < 6; ++n) {	/* Directions */
		newx = def->x + diroff[n+1][0];
		newy = def->y + diroff[n+1][1];
		getsect(newx,newy,&sect);    /* incase cross world boundary */
		if (!player->owner)
			continue;
		att_combat_init(&off[++last], EF_SECTOR);
		off[last].x = sect.sct_x;
		off[last].y = sect.sct_y;
	}
	off->last = last;

	/* Ask the player what he wants to attack with */

	att_ask_offense(A_ATTACK, off, def, &olist, &a_spy, &a_engineer);
	if (att_abort(A_ATTACK, off, def)) {
		pr("Attack aborted\n");
		att_empty_attack(A_ATTACK, 0, def);
		return att_free_lists(&olist, 0);
	}

	/*
	 * Estimate the defense strength and give the player a chance to abort
	 */

	ototal = att_estimate_defense(A_ATTACK, off, &olist, def, a_spy);
	if (att_abort(A_ATTACK, off, def)) {
		pr("Attack aborted\n");
		att_empty_attack(A_ATTACK, 0, def);
		return att_free_lists(&olist, 0);
	}

	/*
	 * We have now got all the answers from the attacker.  From this point
	 * forward, we can assume that this battle is the _only_ thing
	 * happening in the game.
	 */

	/* Get the real defense */

	att_get_defense(&olist, def, &dlist, a_spy, ototal);

	/* Get attacker and defender support */

	att_get_support(A_ATTACK, fort_sup, ship_sup, land_sup, plane_sup,
			&olist, off, &dlist, def, &osupport, &dsupport,
			a_engineer);
	if (att_abort(A_ATTACK, off, def)) {
		pr("Attack aborted\n");
		att_empty_attack(A_ATTACK, 0, def);
		return att_free_lists(&olist, &dlist);
	}

	/*
	 * Death, carnage, and destruction.
	 */

	att_fight(A_ATTACK,off,&olist,osupport,def,&dlist,dsupport);

	return RET_OK;
}
