#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/ship.c,v 2.5 1995/10/11 03:00:05 empire Exp $";
#endif

/*
 * ship.c
 *
 * ship pre-write data massage
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "file.h"
#include "nat.h"
#include "ship.h"
#include "deity.h"
#include "land.h"
#include "plane.h"
#include "nsc.h"

/*ARGSUSED*/
shp_postread(ptr)
	s_char	*ptr;
{
	struct	shpstr *sp = (struct shpstr *)ptr;

	player->owner = (player->god || sp->shp_own == player->cnum);
	return 1;
}

int
shp_prewrite(n, ptr)
	int	n;
	s_char	*ptr;
{
	struct	shpstr *sp = (struct shpstr *) ptr;
	struct	shpstr ship;

	if (sp -> shp_own != 0 && sp->shp_effic < SHIP_MINEFF) {
		mpr(sp->shp_own, "\t%s sunk!\n", prship(sp));
		sp->shp_own = 0;
	}
	sp->ef_type = EF_SHIP;
	sp->shp_uid = n;

	getship(n, &ship);
	prewrite_sync(&ship, sp);

	return 1;
}

int
shp_init(n, ptr)
	int	n;
	s_char	*ptr;
{
	struct	shpstr *sp = (struct shpstr *) ptr;

	sp->ef_type = EF_SHIP;
	sp->shp_uid = n;
	sp->shp_own = 0;
}

s_char *
prship(sp)
	struct	shpstr	*sp;
{
#ifdef	SHIPNAMES
	return prbuf("%s %s(#%d)",
		     mchr[sp->shp_type].m_name, sp->shp_name, sp->shp_uid);
#else
	return prbuf("%s #%d", mchr[sp->shp_type].m_name, sp->shp_uid);
#endif  /* SHIPNAMES */
}
